import java.net.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class PortScan extends Applet implements ActionListener{
 Label ipLabel, startPortLabel, endPortLabel;

 TextField ipField, startPortField, endPortField;

 Button startButton;

 TextArea ergebnisText;

 String ergebnisString;

 public void init(){
  ipLabel = new Label("Enter target IP", Label.CENTER);
  add(ipLabel);
  ipField = new TextField("127.0.0.1",18);
  add(ipField);

  startPortLabel = new Label("Enter first port", Label.CENTER);
  add(startPortLabel);
  startPortField = new TextField("1",5);
  add(startPortField);

  endPortLabel = new Label("Enter last Port", Label.CENTER);
  add(endPortLabel);
  endPortField = new TextField("1000",5);
  add(endPortField);

  startButton = new Button("Start Scan");
  add(startButton);
  startButton.addActionListener(this);

  ergebnisString = "Portscanner in Java by SnakeByte\n(SnakeByte@kryptocrew.de)\nResults : \n";
  ergebnisText = new TextArea(ergebnisString, 30,30);  // verkuerzen..
  add(ergebnisText);
 }  // end init

 public void actionPerformed(ActionEvent e){
  myScan();
 }//end action




 void myScan(){
  int myStartPort, myEndPort;
  Double temp2;
  String myIP, temp;

  temp = startPortField.getText();
  temp2 = new Double(temp);
  myStartPort = temp2.intValue();

  temp = endPortField.getText();
  temp2 = new Double(temp);
  myEndPort = temp2.intValue();

  myIP = ipField.getText();

  int x;
  if ( myStartPort > myEndPort ){
   x = myStartPort;
   myStartPort = myEndPort;
   myEndPort = x;
   temp = temp.valueOf(myStartPort);
   startPortField.setText(temp);
   temp = temp.valueOf(myEndPort);
   endPortField.setText(temp);
  }

  if ( myEndPort > 65535 ) {
   ergebnisString = ergebnisString + "invalid Port entered ! \n\n";
   ergebnisText.setText(ergebnisString);
   return;
  }

  if ( myStartPort < 1 ) {
   ergebnisString = ergebnisString + "invalid Port entered ! \n\n";
   ergebnisText.setText(ergebnisString);
   return;
  }


  ergebnisString = ergebnisString + "Scanning : " + myIP + "\n";
  ergebnisText.setText(ergebnisString);

  for ( x = myStartPort; x <= myEndPort; x = x + 1 ) {
   startPortField.setText(" " + x);
   Socket mySocket;

   try {
    mySocket = new Socket(myIP, x);
    ergebnisString = ergebnisString + "Port " + x + " is open\n";
    ergebnisText.setText(ergebnisString);
   } catch (UnknownHostException e) {
    ergebnisString = ergebnisString + "Can't create socket ! \n\n";
    ergebnisText.setText(ergebnisString);
    return;
   } catch (java.io.IOException a) {
    // port closed or no route to host.. etc
   } // end try
  } // end for
 ergebnisString = ergebnisString + "Scan finished !\n\n";
 ergebnisText.setText(ergebnisString);
 } // end Scan

}// end class


