#!/usr/bin/perl
#
# mldonkey fakecheck.pl for *nix & everything else with perl ;)
# quick hack by snakebyte ( http://www.snake-basket.de )
#
# mldonkey is a peer to peer download program, which uses the edonkey
# protocol to download files ( the CVS version can other p2p protocols
# as welll, but I didn't get it to work, so this script might just work with the
# current stable release )
#
# You need an up2date version of the fakes.dat, leech it at:
#	http://donkey-fakes.ath.cx/fakecheck/update/fakes.dat
#
# The fakes database is provided and maintained by donkey-fakes.de.vu
#
# Usage:
# 	-e "ed2k://|file|you adv. here...."	check an ed2k link
# 	-f /home/foobar/fakes.dat		use another fakes.dat
# 	-i /mldonkey/files.ini			use another files.ini
# 	-u 					update fakes.dat ( needs wget or lynx installed )
# 	-h  					help :)
#
#
# This program is of course released under the gpl ( see gpl.txt for details )
# It comes with no warranty, no support, no documentation, no fish and no chips,
# please do not use it in working environment or on 24/7 servers, when drunk or
# under the influence of drugs... ;)
#
use Getopt::Std;

my $IniFile   = "files.ini";		# default values
my $FakeFile  = "fakes.dat";		# 


print(">> fakecheck for mldonkey by snakebyte [ http://www.snake-basket.de ] <<\n\n");


getopts('e:f:i:uh');

if ( defined $opt_f ){			# don't use the fakes.dat in the current directory
	$FakeFile = $opt_f;
}
if ( defined $opt_i ){			# don't use the files.ini in the current directory
	$IniFile  = $opt_i;
}

if ( defined $opt_u ){			# update the fakes.dat
	system("rm fakes.dat");		# delete the old one
	$url = "http://donkey-fakes.ath.cx/fakecheck/update/fakes.dat";
	if ( ( system("wget $url") != 0 ) && ( system("lynx -dump $url > ./fakes.dat") != 0 ) ){
		print ("wget and lynx --dump failed, either they are not installed, or the server is too busy\n");
	}
	exit(0);
}

if ( defined $opt_h ){			# display a help
	print qq~
  Usage:
	 -e "ed2k://|file|you file...."		check an ed2k link
	 -f /home/foobar/fakes.dat		use another fakes.dat
	 -i /mldonkey/files.ini			use another files.ini
	 -u 					update fakes.dat
	 -h  					help :)


~;
	exit(0);
}

open(Fake, $FakeFile ); # open the fakes database
@FakeDat=<Fake>;
close(Fake);


if ( defined $opt_e ){
	#ed2k://|file|the.ring.2.avi|735090688|61b4fdd22d8405a54add5e76b924e324|
	if ( substr( $opt_e, 0, 13 ) ne "ed2k://|file|" ){
		print("This is not a valid edonkey2000 Link\n");
		exit(0);
	}
	for ( $i = 14; ($i < length( $opt_e )) && ( substr($opt_e, $i, 1) ne "|"); $i++ ){};
	$name = substr( $opt_e, 13, $i-13);
	print ("Filename: $name\n");

	for ( $j = ++$i; ($j < length( $opt_e )) && ( substr($opt_e, $j, 1) ne "|"); $j++ ){};
	$size = substr( $opt_e, $i, $j-$i);
	print("Size: $size\n");

	for ( $i = ++$j; ($i < length( $opt_e )) && ( substr($opt_e, $i, 1) ne "|"); $i++ ){};
	$md4  = substr( $opt_e, $j, $i-$j);
	print("Checksum: $md4\n");
	if ( length($md4) != 32 ){ 
		print("This is not a vaid edonkey2000 Link, checksum is not 32 Byte\n");
		exit(0);
	}
	print("Checking...");
	$k = 0;
	for ( $j = 0; ( $j < @FakeDat ) && ( $k == 0 ); $j++ ){
	   	# $name	$size  $filemd4
		@fake = split(/,/, $FakeDat[$j]);
		if (( $fake[0] eq $md4 ) && ( $fake[1] eq $size )){
			$k = 1;
		}
	}
	if ( $k == 1 ){
		print ( "fake --> $fake[2]\r\n" );
	} else {
		print ( "ok\r\n");
	}
	exit(0);
}


open(Ini, $IniFile ); # open the files.ini
@Downloads=<Ini>;
close(Ini);

my $filemd4 = "";
my $size = "";
my $name = "";

for ( $i = 0; $i < @Downloads; $i++ ){
	if ( $Downloads[$i] =~ /file_md4/i ){ 	# get the md4
		$filemd4 = substr($Downloads[$i], 19, 32);
		$filemd4 =~ s/\"//;
	}
	if ( $Downloads[$i] =~ /file_size/i ){ 	# get the size
		$size = substr($Downloads[$i], 17, length($Downloads[$i]) - 18);
		$size =~ s/\"//;
	}
	if ( $Downloads[$i] =~ /file_filenames/i ){	# get a filename
		$name = substr($Downloads[$i+1], 7, length($Downloads[$i+1]) - 10);
		$name =~ s/\"//;
	}

	if (( $filemd4 ne "" ) && ( $size ne "" ) && ( $name ne "" )){
		printf "Checking File: ";
		for ( ; ( $i < @Downloads ) && ( $Downloads[$i] !~ /}]/i ); $i++ ){ }
		print "$name...";
		$k = 0;
		for ( $j = 0; ( $j < @FakeDat ) && ( $k == 0 ); $j++ ){
		   	# $name	$size  $filemd4
			@fake = split(/,/, $FakeDat[$j]);
			if (( $fake[0] eq $filemd4 ) && ( $fake[1] eq $size )){
				$k = 1;
			}
		}
		if ( $k == 1 ){
			print ( "*-*-* $fake[2]\r\n" );
		} else {
			print ( "ok\r\n");
		}
		$filemd4 = ""; $size = ""; $name = "";	# reset the values to ""
	}
}