
# Copyright (C) 2005-2011 Splunk Inc. All Rights Reserved.  Version 4.3.3
#
# This file contains possible attributes and values for configuring a deployment client to receive
# content (apps and configurations) from a deployment server. 
# 
# To customize the way a deployment client behaves, place a deploymentclient.conf in 
# $SPLUNK_HOME/etc/system/local/ on that Splunk instance. Configure what apps or configuration 
# content is deployed to a given deployment client in serverclass.conf. 
# Refer to serverclass.conf.spec and serverclass.conf.example for more information. 
#
# You must restart Splunk for changes to this configuration file to take effect.
#
# To learn more about configuration files (including precedence) please see the documentation 
# located at http://docs.splunk.com/Documentation/Splunk/latest/Admin/Aboutconfigurationfiles

#***************************************************************************
# Configure a Splunk deployment client.
# 
# Note: At a minimum the [deployment-client] stanza is required in deploymentclient.conf for
# deployment client to be enabled.
#***************************************************************************

[deployment-client]

disabled = [false|true]
    * Defaults to false
    * Enable/Disable deployment client.

clientName = deploymentClient
    * Defaults to deploymentClient.
    * A name that the deployment server can filter on.
    * Takes precedence over DNS names.
    
workingDir = $SPLUNK_HOME/var/run/deploy-client
    * Temporary folder used by the deploymentClient to download apps and configuration content.

repositoryLocation = $SPLUNK_HOME/etc/apps
    * The location into which content is installed after being downloaded from a deployment server.
    * Apps and configuration content must be installed into the default location 
($SPLUNK_HOME/etc/apps) or it will not be recognized by the Splunk instance on the 
deployment client. 
    * Note: Apps and configuration content to be deployed may be located in an alternate location on 
the deployment server. Set both repositoryLocation and serverRepositoryLocationPolicy explicitly to 
ensure that the content is installed into the correct location ($SPLUNK_HOME/etc/apps) 
on the deployment client. 
    * The deployment client uses the 'serverRepositoryLocationPolicy' defined below to determine 
which value of repositoryLocation to use.

serverRepositoryLocationPolicy = [acceptSplunkHome|acceptAlways|rejectAlways]
    * Defaults to acceptSplunkHome.
    * acceptSplunkHome - accept the repositoryLocation supplied by the deployment server, only if it 
is rooted by $SPLUNK_HOME.
    * acceptAlways - always accept the repositoryLocation supplied by the deployment server.
    * rejectAlways - reject the server supplied value and use the repositoryLocation specified 
in the local deploymentclient.conf.

endpoint=$deploymentServerUri$/services/streams/deployment?name=$serverClassName$:$appName$
    * The HTTP endpoint from which content should be downloaded.
    * Note: The deployment server may specify a different endpoint from which to download each set of 
content (individual apps, etc).
    * The deployment client will use the serverEndpointPolicy defined below to determine which value 
to use.
    * $deploymentServerUri$ will resolve to targetUri defined in the [target-broker] stanza below.
    * $serverClassName$ and $appName$ mean what they say.

serverEndpointPolicy = [acceptAlways|rejectAlways]
    * defaults to acceptAlways
    * acceptAlways - always accept the endpoint supplied by the server.
    * rejectAlways - reject the endpoint supplied by the server. Always use the 'endpoint' definition 
above.

phoneHomeIntervalInSecs = <integer in seconds>
    * Defaults to 60.
    * This determines how frequently this deployment client should check for new content. 

# Advanced!
# You should use this property only when you have a hierarchical deployment server installation, and have 
# a Splunk instance that behaves as both a DeploymentClient and a DeploymentServer.

reloadDSOnAppInstall = [false|true]
    * Defaults to false
    * Setting this flag to true will cause the deploymentServer on this Splunk instance to be reloaded whenever 
an app is installed by this deploymentClient.

# The following stanza specifies deployment server connection information

[target-broker:deploymentServer]

targetUri= <deploymentServer>:<mgmtPort>
    * URI of the deployment server.

phoneHomeIntervalInSecs = see phoneHomeIntervalInSecs above

