# Copyright (C) 2005-2011 Splunk Inc. All Rights Reserved.  Version 4.3.3 
#
# This file contains possible attribute/value pairs for configuring limits for search commands.
#
# There is a limits.conf in $SPLUNK_HOME/etc/system/default/.  To set custom configurations, 
# place a limits.conf in $SPLUNK_HOME/etc/system/local/. For examples, see 
# limits.conf.example. You must restart Splunk to enable configurations.
#
# To learn more about configuration files (including precedence) please see the documentation 
# located at http://docs.splunk.com/Documentation/Splunk/latest/Admin/Aboutconfigurationfiles
#
# CAUTION: Do not alter the settings in limits.conf unless you know what you are doing. 
# Improperly configured limits may result in splunkd crashes and/or memory overuse.

* Each stanza controls different parameters of search commands.

[searchresults]
* This stanza controls search results for a variety of Splunk search commands.
          
maxresultrows = <integer>
* Configures the maximum number of events are generated by search commands which 
grow the size of your result set (such as multikv) or that create events. Other search commands are explicitly 
controlled in specific stanzas below.
* This limit should not exceed 50000. Setting this limit higher than 50000 causes instability.
* Defaults to 50000. 

tocsv_maxretry = <integer>
* Maximum number of times to retry the atomic write operation.
* 1 = no retries.
* Defaults to 5.

tocsv_retryperiod_ms = <integer>
* Period of time to wait before each retry.
* Defaults to 500.

[subsearch]
* This stanza controls subsearch results.

maxout = <integer>
* Maximum number of results to return from a subsearch.
* This value cannot be greater than or equal to 10500.
* Defaults to 100.

maxtime = <integer>
* Maximum number of seconds to run a subsearch before finalizing
* Defaults to 60.

ttl = <integer>
* Time to cache a given subsearch's results, in seconds.
* Do not set this below 120 seconds. 
* Defaults to 300.

[anomalousvalue]

maxresultrows = <integer>
* Configures the maximum number of events that can be present in memory at one time. 
* Defaults to searchresults::maxresultsrows (which is by default 50000).
	
maxvalues = <integer>
* Maximum number of distinct values for a field.
* Defaults to 100000.

maxvaluesize = <integer>
* Maximum size in bytes of any single value (truncated to this size if larger).
* Defaults to 1000.

[associate]

maxfields = <integer>
* Maximum number of fields to analyze.
* Defaults to 10000.

maxvalues = <integer>
* Maximum number of values for any field to keep track of.
* Defaults to 10000.

maxvaluesize = <integer>
* Maximum length of a single value to consider.
* Defaults to 1000.


[autoregress]

maxp = <integer>
* Maximum valid period for auto regression 
* Defaults to 10000.

maxrange = <integer>
* Maximum magnitude of range for p values when given a range.
* Defaults to 1000.

[concurrency]
max_count = <integer>
* Maximum number of detected concurrencies.
* Defaults to 10000000


[ctable]
* This stanza controls the contingency, ctable, and counttable commands.

maxvalues = <integer>
* Maximum number of columns/rows to generate (the maximum number of distinct values for the row field and 
column field).
* Defaults to 1000.


[correlate]

maxfields = <integer>
* Maximum number of fields to correlate.
* Defaults to 1000.


[discretize]
* This stanza set attributes for bin/bucket/discretize.

maxbins = <integer> 
* Maximum number of buckets to discretize into.
* If maxbins is not specified or = 0, it defaults to searchresults::maxresultrows (which is by default 50000).

[extern]
perf_warn_limit = <integer>
* Warn when external scripted command is applied to more than this many events
* set to 0 for no message (message is always INFO level)
* Defaults to 10000

[inputcsv]
mkdir_max_retries = <integer>
* Maximum number of retries for creating a tmp directory (with random name as subdir of SPLUNK_HOME/var/run/splunk)
* Defaults to 100.

[indexpreview]
max_preview_bytes = <integer>
* Maximum number of bytes to read from each file during preview
* Defaults to 2000000 (2 MB)

max_results_perchunk = <integer>
* Maximum number of results to emit per call to preview data generator
* Defaults to 2500

soft_preview_queue_size = <integer>
* Loosely-applied maximum on number of preview data objects held in memory
* Defaults to 100

[join]
subsearch_maxout = <integer>
* Maximum result rows in output from subsearch to join against.
* Defaults to 50000

subsearch_maxtime = <integer>
* Maximum search time (in seconds) before auto-finalization of subsearch.
* Defaults to 60 

subsearch_timeout = <integer>
* Maximum time to wait for subsearch to fully finish (in seconds).
* Defaults to 120

[kmeans]

maxdatapoints = <integer>
* Maximum data points to do kmeans clusterings for.
* Defaults to 100000000

maxkvalue = <integer>
* Maximum number of clusters to attempt to solve for.
* Defaults to 1000

maxkrange = <integer>
* Maximum number of k values to iterate over when specifying a range.
* Defaults to 100

[kv]

maxcols = <integer>
* When non-zero, the point at which kv should stop creating new fields.
* Defaults to 512.

limit = <integer>
* Maximum number of keys auto kv can generate.
* Defaults to 50.

maxchars = <integer>
* Truncate _raw to this size and then do auto KV.
* Defaults to 10240 characters.

max_extractor_time = <integer>
* Maximum amount of CPU time, in milliseconds, that a key-value pair extractor will be allowed to 
* take before warning. If the extractor exceeds this execution time on any event a warning will be issued
* Defaults to 1000

avg_extractor_time = <integer>
* Maximum amount of CPU time, in milliseconds, that the average (over search results) execution time of 
* a key-value pair extractor will be allowed to take before warning. Once the average becomes larger 
* than this amount of time a warning will be issued
* Defaults to 500

[lookup]

max_memtable_bytes = <integer> 
* Maximum size of static lookup file to use an in-memory index for.
* Defaults to 10000000 in bytes (10MB

max_matches = <integer>
* maximum matches for a lookup
* Defaults to 1000

max_reverse_matches = <integer> 
* maximum reverse lookup matches (for search expansion)
* Defaults to 50

batch_index_query = <bool>
* Should non-memory file lookups (files that are too large) use batched queries to possibly improve performance?
* Defaults to true

batch_response_limit = <integer>
* When doing batch requests, the maximum number of matches to retrieve                                    
* if more than this limit of matches would otherwise be retrieve, we will fall back to non-batch mode matching
* Defaults to 5000000

[metrics]

maxseries = <integer>
* The number of series to include in the per_x_thruput reports in metrics.log.
* Defaults to 10.

interval = <integer>
* Number of seconds between logging splunkd metrics to metrics.log.
* Minimum of 10.
* Defaults to 30.

[rare]

maxresultrows = <integer>
* Maximum number of result rows to create.
* If not specified, defaults to searchresults::maxresultrows (which is by default 50000).

maxvalues = <integer>
* Maximum number of distinct field vector values to keep track of.
* Defaults 100000.

maxvaluesize = <integer>
* Maximum length of a single value to consider.
* Defaults to 1000.

[restapi]

maxresultrows = <integer>
* Maximum result rows to be returned by /events or /results getters from REST API.
* Defaults to 50000.

time_format_reject = <regular expression>
* HTTP parameters for time_format and output_time_format which match
  this regex will be rejected (blacklisted).
* The regex will be satisfied by a substring match anywhere in the paramater.
* Intended as defense-in-depth against XSS style attacks against browser users
  by crafting specially encoded URLS for them to access splunkd. 
* If unset, all parameter strings will be accepted.
* To disable this check entirely, set the value to empty.
  # Example of disabling: time_format_reject =
* Defaults to [<>!] , which means that the less-than '<', greater-than '>', and
  exclaimation point '!' are not allowed.

[search]

use_bloomfilter = <bool>
* Control whether to use bloom filters to rule out buckets

ttl = <integer>
* How long search artifacts should be stored on disk once completed, in seconds.
* Defaults to 600, which is equivalent to 10 minutes.

default_save_ttl = <integer>
* How long the ttl for a search artifact should be extended in response to the save control action, in second.  0 = indefinitely.
* Defaults to 604800 (1 week)

remote_ttl = <integer>
* How long artifacts from searches run in behalf of a search head should be stored on the indexer 
  after completion, in seconds.
* Defaults to 600 (10 minutes)

status_buckets = <integer>
* The approximate maximum number buckets to generate and maintain in the timeline.
* Defaults to 0, which means do not generate timeline information.

max_bucket_bytes = <integer>
* This setting has been deprecated and has no effect

max_count = <integer>
* The number of events that can be accessible in any given status bucket.
* The last accessible event in a call that takes a base and bounds.
* Defaults to 10000.

max_events_per_bucket = <integer>
* For searches with status_buckets>1 (i.e. Timeline), this setting will specify the maximum number of events to store per timeline bucket.
* Defaults to 1000 in code.  (limits.conf in default will override to 10000 for 4.3.x until 5.0 to maintain existing behavior until the next major release)

truncate_report = [1|0]
* Specifies whether or not to apply the max_count limit to report output.
* Defaults to false (0).

min_prefix_len = <integer>
* The minimum length of a prefix before a * to ask the index about.
* Defaults to 1.

max_results_raw_size = <integer>
* The largest "_raw" volume that should be read in memory.
* If the total volume of _raw fields (the text of the events) exceeds this value, no more results 
will be returned for the search.
* Defaults to 100000000, which is 100MB. 

cache_ttl = <integer>
* The length of time to persist search cache entries (in seconds).
* Defaults to 300.

max_results_perchunk = <integer>
* Maximum results per call to search (in dispatch), must be less than or equal to maxresultrows.
* Defaults to 2500                                                                                      

min_results_perchunk = <integer>
* Minimum results per call to search (in dispatch), must be less than or equal to max_results_perchunk.
* Defaults to 100                                                                       

max_rawsize_perchunk = <integer>
* Maximum raw size of results per call to search (in dispatch).
* 0 = no limit.                   
* Defaults to 5000000

target_time_perchunk = <integer>
* Target duration of a particular call to fetch search results in ms.
* Defaults to 2000

long_search_threshold = <integer>
* Time in seconds until a search is considered "long running".
* Defaults to 2
                                                                                                       
chunk_multiplier = <integer>
* max_results_perchunk, min_results_perchunk, and target_time_perchunk are multiplied by this 
for a long running search.
* Defaults to 5

min_freq = <number>
* Minimum frequency of a field required for including in the /summary endpoint as a fraction (>=0 and <=1).
* Defaults is 0.01 (1%)

reduce_freq = <integer>
* Attempt to reduce intermediate results every how many chunks (0 = never).
* Defaults to 10

reduce_duty_cycle = <number>
* the maximum time to spend doing reduce, as a fraction of total search time
* Must be > 0.0 and < 1.0
* Defaults to 0.25

preview_duty_cycle = <number>
* the maximum time to spend generating previews, as a fraction of total search time
* Must be > 0.0 and < 1.0
* Defaults to 0.25

dispatch_quota_retry = <integer>
* The maximum number of times to retry to dispatch a search when the quota has been reached.
* Defaults to 4

dispatch_quota_sleep_ms = <integer>
* Milliseconds between retrying to dispatch a search if a quota has been reached.
* Retries the given number of times, with each successive wait 2x longer than the previous.
* Defaults to 100

base_max_searches = <int>
* A constant to add to the maximum number of searches, computed as a multiplier of the CPUs.
* Defaults to 4

max_searches_per_cpu = <int>
* The maximum number of concurrent historical searches per CPU. The system-wide limit of 
historical searches is computed as: 
  max_hist_searches =  max_searches_per_cpu x number_of_cpus + base_max_searches
* Note: the maximum number of real-time searches is computed as: 
  max_rt_searches = max_rt_search_multiplier x max_hist_searches
* Defaults to 4

max_rt_search_multiplier = <decimal number>
* A number by which the maximum number of historical searches is multiplied to determine the maximum
* number of concurrent real-time searches 
* Note: the maximum number of real-time searches is computed as: 
  max_rt_searches = max_rt_search_multiplier x max_hist_searches
* Defaults to 3

max_macro_depth = <int> 
* Max recursion depth for macros.
* Considered a search exception if macro expansion doesn't stop after this many levels.
* Must be greater than or equal to 1.
* Default is 100

realtime_buffer = <int>
* Maximum number of accessible events to keep for real-time searches from Splunk Web.
* Acts as circular buffer once this limit is reached
* Must be greater than or equal to 1
* Default is 10000

stack_size = <int>
* The stack size (in bytes) of the thread executing the search.
* Defaults to 4194304  (4 MB)

status_cache_size = <int>
* The number of search job status data splunkd can cache in RAM. This cache improves performance of 
  the jobs endpoint
* Defaults to 2000

timeline_freq = <timespan> or <ratio> 
* Minimum amount of time between timeline commits.
* If specified as a number < 1 (and > 0), minimum time between commits is computed as a ratio of 
  the amount of time that the search has been running.
* defaults to 0 seconds

preview_freq = <timespan> or <ratio>
* Minimum amount of time between results preview updates.
* If specified as a number < 1 (and > 0), minimum time between previews is computed as a ratio of 
the amount of time that the search has been running, or as a ratio of the length of the time window 
for real-time windowed searches.
* Defaults to ratio of 0.05

max_combiner_memevents = <int>
* Maximum size of in-memory buffer for search results combiner, in terms of number of events.
* Defaults to 50000 events. 

replication_period_sec  = <int>
* The minimum amount of time in seconds between two successive bundle replications.
* Defaults to 60

sync_bundle_replication = [0|1|auto]
* Flag indicating whether configuration file replication blocks searches or is run asynchronously 
* When setting this flag to auto Splunk will choose to use asynchronous replication iff all the peers 
* support async bundle replication, otherwise it will fallback into sync replication. 
* Defaults to auto 

multi_threaded_setup = [0|1]
* Flag indicating whether to use multiple threads when setting up distributed search to multiple peers.
* Defaults to false (0)

rr_min_sleep_ms = <int>
* Minimum time to sleep when reading results in round-robin mode when no data is available.
* Defaults to 10.

rr_max_sleep_ms = <int>
* Maximum time to sleep when reading results in round-robin mode when no data is available.
* Defaults to 1000

rr_sleep_factor = <int>
* If no data is available even after sleeping, increase the next sleep interval by this factor.
* defaults to 2

fieldstats_update_freq = <number>
* How often to update the field summary statistics, as a ratio to the elapsed run time so far.
* Smaller values means update more frequently.  0 means as frequently as possible.
* Defaults to 0

fieldstats_update_maxperiod = <int>
* Maximum period for updating field summary statistics in seconds
* 0 means no maximum, completely dictated by current_run_time * fieldstats_update_freq
* defaults to 60

remote_timeline = [0|1]
* If true, allows the timeline to be computed remotely to enable better map/reduce scalability.
* defaults to true (1). 

remote_timeline_min_peers = <int>
* Minimum search peers for enabling remote computation of timelines.
* Defaults to 1 (1).

remote_timeline_fetchall = [0|1]
* If true, fetches all events accessible through the timeline from the remote peers before the job is 
  considered done.
* Defaults to false (0).

remote_timeline_thread = [0|1]
* If true, uses a separate thread to read the full events from remote peers if remote_timeline is used 
and remote_timeline_fetchall is set to true. (Has no effect if remote_timeline or remote_timeline_fetchall is 
false).
* Defaults to true (1).

remote_timeline_max_count = <int>
* Maximum number of events to be stored per timeline bucket on each search peer, 
* Defaults to 10000

remote_timeline_max_size_mb = <int>
* Maximum size of disk that remote timeline events should take on each peer
* If limit is reached, a DEBUG message is emitted (and should be visible from job inspector/messages
* Defaults to 1000

remote_timeline_touchperiod = <int>
* How often to touch remote timeline artifacts to keep them from being deleted by the remote peer, while a 
search is running.
* In seconds, 0 means never.
* Defaults to 300.

remote_timeline_connection_timeout = <int>
* Connection timeout in seconds for fetching events processed by remote peer timeliner.
* Defaults to 5.

remote_timeline_send_timeout = <int>
* Send timeout in seconds for fetching events processed by remote peer timeliner.
* Defaults to 10.

remote_timeline_receive_timeout = <int>
* Receive timeout in seconds for fetching events processed by remote peer timeliner.
* Defaults to 10. 

default_allow_queue = [0|1]
* Unless otherwise specified via REST api argument should an async job spawning request be queued on quota 
violation (if not, an http error of server too busy is returned) 
* Defaults to true (1).

queued_job_check_freq = <int>
* Frequency with which to check queued jobs to see if they can be started, in seconds
* Defaults to 10.

enable_history = <bool>
* Enable keeping track of searches?
* Defaults to true

max_history_length = <int>
* Max number of searches to store in history (per user/app)
* Defaults to 1000

allow_inexact_metasearch = <bool>
* Should a metasearch that is inexact be allow.  If so, an INFO message will be added to the inexact metasearches.  If not, a fatal exception will occur at search parsing time.
* Defaults to false

indexed_as_exact_metasearch = <bool>
* Should we allow a metasearch to treat <field>=<value> the same as <field>::<value> if <field> is an indexed field.  Allowing this will allow a larger set of metasearches when allow_inexact_metasearch is set to false.  However, some of these searches may be inconsistent with the results of doing a normal search.
* Defaults to false

dispatch_dir_warning_size = <int>
* The number of jobs in the dispatch directory when to issue a bulletin message warning that performance could be impacted
* Defaults to 2000

allow_reuse = <bool>
* Allow normally executed historical searches to be implicitly re-used for newer requests if the newer request allows it?
* Defaults to true

reuse_map_maxsize = <int>
* Maximum number of jobs to store in the reuse map 
* Defaults to 1000

use_dispatchtmp_dir = <bool>
* Write temporary files to a different directory from a job's dispatch directory
* Temp files would be written to $SPLUNK_HOME/var/run/splunk/dispatchtmp/<sid>/
* Defaults to true

load_remote_bundles = <bool>
* On a search peer, allow remote (search head) bundles to be loaded in splunkd.
* Defaults to false.

[realtime] 
# Default options for indexer support of real-time searches
# These can all be overriden for a single search via REST API arguments

queue_size = <int>
* Size of queue for each real-time search (must be >0).
* Defaults to 10000

blocking = [0|1] 
* Specifies whether the indexer should block if a queue is full.
* Defaults to false

max_blocking_secs = <int>
* Maximum time to block if the queue is full (meaningless if blocking = false)
* 0 means no limit
* Default to 60 

indexfilter = [0|1]
* Specifies whether the indexer should prefilter events for efficiency.
* Defaults to true (1).

default_backfill = <bool>
* Specifies if windowed real-time searches should backfill events
* Defaults to true

list_maxsize = <int>
* Maximum number of list items to emit when using the list() function stats/sistats
* Defaults to 100

sparkline_maxsize = <int>
* Maximum number of elements to emit for a sparkline
* Defaults to value of list_maxsize setting

enforce_time_order = <bool>
* Specifies if real-time searches should ensure that events are sorted in ascending time order (the UI will automatically reverse the order that it display events for real-time searches so in effect the latest events will be first)
* Defaults to true

[slc]

maxclusters = <integer>
* Maximum number of clusters to create.
* Defaults to 10000.

[sort]

maxfiles = <integer>
* Maximum files to open at once.  Multiple passes are made if the number of result chunks 
exceeds this threshold.
* Defaults to 64.

[stats|sistats]

maxresultrows = <integer>
* Maximum number of result rows to create. 
* If not specified, defaults to searchresults::maxresultrows (which is by default 50000).

maxvalues = <integer>
* Maximum number of values for any field to keep track of.
* Defaults to 0 (unlimited).

maxvaluesize = <integer>
* Maximum length of a single value to consider.
* Defaults to 0 (unlimited).

# rdigest is a data structure used to compute approximate order statistics (such as median and percentiles) 
# using sublinear space.

rdigest_k = <integer>
* rdigest compression factor
* Lower values mean more compression
* After compression, number of nodes guaranteed to be greater than or equal to 11 times k.
* Defaults to 100, must be greater than or equal to 2

rdigest_maxnodes = <integer>
* Maximum rdigest nodes before automatic compression is triggered.
* Defaults to 1, meaning automatically configure based on k value

max_stream_window = <integer>
* For streamstats command, the maximum allow window size
* Defaults to 10000.

max_valuemap_bytes = <integer>
* For sistats command, the maximum encoded length of the valuemap, per result written out
* If limit is exceeded, extra result rows are written out as needed.  (0 = no limit per row)
* Defaults to 100000.

perc_method = nearest-rank|interpolated
* Which method to use for computing percentiles (and medians=50 percentile).
* nearest-rank picks the number with 0-based rank R = floor((percentile/100)*count)
* interpolated means given F = (percentile/100)*(count-1), pick ranks R1 = floor(F) and R2 = ceiling(F).  Answer = (R2 * (F - R1)) + (R1 * (1 - (F - R1)))
* See wikipedia percentile entries on nearest rank and "alternative methods" 
* Defaults to interpolated

approx_dc_threshold = <integer>
* When using approximate distinct count (i.e. estdc(<field>) in stats/chart/timechart), do not use approximated results if the actual number of distinct values is less than this number
* Defaults to 1000

dc_digest_bits = <integer>
* 2^<integer> bytes will be size of digest used for approximating distinct count.
* Defaults to 10 (equivalent to 1KB)
* Must be >= 8 (128B) and <= 16 (64KB)

[thruput]

maxKBps = <integer>
* If specified and not zero, this limits the speed through the thruput processor to the specified 
rate in kilobytes per second.
* To control the CPU load while indexing, use this to throttle the number of events this indexer 
processes to the rate (in KBps) you specify. 

[journal_compression]

threads = <integer>
* Specifies the maximum number of indexer threads which will be work on compressing hot bucket journal data.
* Defaults to the number of CPU threads of the host machine
* This setting does not typically need to be modified.

[top]

maxresultrows = <integer>
* Maximum number of result rows to create.
* If not specified, defaults to searchresults::maxresultrows (usually 50000).

maxvalues = <integer>
* Maximum number of distinct field vector values to keep track of.
* Defaults to 100000.

maxvaluesize = <integer>
* Maximum length of a single value to consider.
* Defaults to 1000.

[transactions]

maxopentxn = <integer>
* Specifies the maximum number of not yet closed transactions to keep in the open pool before starting to evict transactions.
* Defaults to 5000.

maxopenevents = <integer>
* Specifies the maximum number of events (which are) part of open transactions before transaction eviction starts happening, using LRU policy.
* Defaults to 100000.

[inputproc]

max_fd = <integer>
* Maximum number of file descriptors that Splunk will keep open, to capture any trailing data from 
files that are written to very slowly.
* Defaults to 100.

time_before_close = <integer>
* MOVED.  This setting is now configured per-input in inputs.conf.
* Specifying this setting in limits.conf is DEPRECATED, but for now will override the setting for all 
monitor inputs.

tailing_proc_speed = <integer>
* REMOVED.  This setting is no longer used.

[scheduler]
max_searches_perc = <integer>
* The maximum number of searches the scheduler can run, as a percentage of the maximum number of concurrent 
searches, see [search] max_searches_per_cpu for how to set the system wide maximum number of searches.
* Defaults to 25.

max_action_results = <integer>
* The maximum number of results to load when triggering an alert action.
* Defaults to 10000

action_execution_threads = <integer>
* Number of threads to use to execute alert actions, change this number if your alert actions take a long 
time to execute. 
* This number is capped at 10.
* Defaults to 2

actions_queue_size = <integer>
* The number of alert notifications to queue before the scheduler starts blocking, set to 0 for infinite size.
* Defaults to 100

actions_queue_timeout = <integer>
* The maximum amount of time, in seconds to block when the action queue size is full.
* Defaults to 30

alerts_max_count = <integer>
* Maximum number of unexpired alerts information to keep for the alerts manager, when this number is reached 
Splunk will start discarding the oldest alerts.
* Defaults to 50000

alerts_expire_period = <integer>
* The amount of time between expired alert removal
* This period controls how frequently the alerts list is scanned, the only benefit from reducing this is 
better resolution in the number of alerts fired at the savedsearch level.
* Change not recommended.
* Defaults to 120.

peristance_period = <integer>
* The period (in seconds) between scheduler state persistance to disk. The scheduler currently persists 
the suppression and fired-unexpired alerts to disk. 
* This is relevant only in search head pooling mode.
* Defaults to 30.

max_lock_files = <int>
* The number of most recent lock files to keep around. 
* This setting only applies in search head pooling.

max_lock_file_ttl = <int>
* Time (in seconds) that must pass before reaping a stale lock file .
* Only applies in search head pooling.

max_per_result_alerts = <int>
* Maximum number of alerts to trigger for each saved search instance (or real-time results preview for RT alerts)
* Only applies in non-digest mode alerting. Use 0 to disable this limit
* Defaults to 500

max_per_result_alerts_time = <int>
* Maximum number of time to spend triggering alerts for each saved search instance (or real-time results preview for RT alerts)
* Only applies in non-digest mode alerting. Use 0 to disable this limit.
* Defaults to 300

[show_source]
max_count = <integer>
* Maximum number of events accessible by show_source. 
* The show source command will fail when more than this many events are in the same second as the requested event.
* Defaults to 10000

max_timebefore = <timespan>
* Maximum time before requested event to show.
* Defaults to '1day' (86400 seconds)

max_timeafter = <timespan>
* Maximum time after requested event to show.
* Defaults to '1day' (86400 seconds)

distributed = <bool>
* Controls whether we will do a distributed search for show source to get events from all servers and indexes
* Turning this off results in better performance for show source, but events will only come from the initial server and index
* NOTE: event signing and verification is not supported in distributed mode
* Defaults to true

distributed_search_limit = <unsigned int>
* Sets a limit on the maximum events we will request when doing the search for distributed show source
* As this is used for a larger search than the initial non-distributed show source, it is larger than max_count
* Splunk will rarely return anywhere near this amount of results, as we will prune the excess results
* The point is to ensure the distributed search captures the target event in an environment with many events
* Defaults to 30000

[typeahead]
maxcount = <integer>
* Maximum number of typeahead results to find.
* Defaults to 1000

use_cache = [0|1]
* Specifies whether the typeahead cache will be used if use_cache is not specified in the command line or endpoint.
* Defaults to true.

fetch_multiplier = <integer>
* A multiplying factor that determines the number of terms to fetch from the index, fetch = fetch_multiplier x count.
* Defaults to 50

cache_ttl_sec = <integer>
* How long the typeahead cached results are valid, in seconds.
* Defaults to 300. 

min_prefix_length = <integer>
* The minimum string prefix after which to provide typeahead.
* Defaults to 1.

max_concurrent_per_user = <integer>
* The maximum number of concurrent typeahead searches per user. Once this maximum is reached only cached 
* typeahead results might be available
* Defaults to 3.

[typer]
maxlen = <int>
* In eventtyping, pay attention to first <int> characters of any attribute (such as _raw), including individual 
tokens. Can be overridden by supplying the typer operator with the argument maxlen (for example, "|typer maxlen=300").
* Defaults to 10000.

[authtokens]
expiration_time = <integer>
* Expiration time of auth tokens in seconds.
* Defaults to 3600

[sample]

maxsamples = <integer>
* Defaults to 10000

maxtotalsamples = <integer>
* Defaults to 100000

[metadata]
maxresultrows = <integer>
 * the maximum number of results in a single chunk fetched by the metadata command
 * a smaller value will require less memory on the search head in setups with
   large number of peers and many metadata results, though, setting this too
   small will decrease the search performance
 * default is 10000
 * do not change unless instructed to do so by Splunk Support
maxcount = <integer>
 * the total maximum number of results the metadata command will fetch from each indexer

[set]
maxresultrows = <integer>
 * the maximum number of results the set command will use from each resultset to compute the required set operation

[input_channels]
max_inactive = <integer>
* internal setting, do not change unless instructed to do so by Splunk Support

lowater_inactive = <integer>
* internal setting, do not change unless instructed to do so by Splunk Support

inactive_eligibility_age_seconds = <integer>
* internal setting, do not change unless instructed to do so by Splunk Support

[ldap]
max_users_to_precache = <unsigned integer>
* The maximum number of users we will attempt to precache from LDAP after reloading auth
* Set this to 0 to turn off precaching

allow_multiple_matching_users = <bool>
* This controls whether we allow login when we find multiple entries with the same value for the username attribute
* When multiple entries are found, we choose the first user DN lexicographically
* Setting this to false is more secure as it does not allow any ambiguous login, but users with duplicate entries will not be able to login.
* Defaults to true

[spath]
extraction_cutoff = <integer>
* For extract-all spath extraction mode, only apply extraction to the first <integer> number of bytes
* Defaults to 5000

extract_all = <boolean>
* Controls whether we respect automatic field extraction when spath is invoked manually.
* If true, we extract all fields regardless of settings.  If false, we only extract fields used by later splunk commands.

[reversedns]
rdnsMaxDutyCycle = <integer>
* generate diagnostic WARN in splunkd.log if reverse dns lookups are taking 
* more than this percent of time
* range 0-100
* default 10

[viewstates]

enable_reaper = <boolean>
* Controls whether the viewstate reaper runs
* Defaults to true

reaper_freq = <integer>
* Controls how often the viewstate reaper runs
* Defaults to 86400 (1 day)

reaper_soft_warn_level = <integer>
* Controls what the reaper considers an acceptable number of viewstates
* Defaults to 1000

ttl = <integer>
* Controls the age at which a viewstate is considered eligible for reaping
* Defaults to 86400 (1 day)
