import cherrypy, urllib
import os, time
import json
import splunk, splunk.auth, splunk.search
import splunk.search.Parser
import splunk.search.Transformer as xformer
from cherrypy import request
from splunk.appserver.mrsparkle import *
from splunk.search.TransformerUtil import *

import logging
logger = logging.getLogger("splunk.appserver.controller.parser")

#
# setup logger to obtain actual searches executed by instance; output is sent
# to searches.log file.  Each entry is of the format <username> <search>
#
parserLogger = logging.getLogger('splunk.parseLogger')
parserLogger.setLevel(logging.DEBUG)
parserLogger.propagate = False
parserHandler = logging.FileHandler(os.path.join(os.environ['SPLUNK_HOME'], 'var', 'log', 'splunk', 'intentions.log'))
parserHandler.setFormatter(logging.Formatter("%(asctime)s %(message)s"))
parserLogger.addHandler(parserHandler)


class ParserController(BaseController):
    """
    /parser
    """
    
    counter = 0
    
    def _failJSON(self, message):
        """ Create a dictionary that will be JSON''d and returned """
        failDict = {
            "success"  : False,
            "messages" : []
        }
        failDict['messages'].append(message)
        return self.render_json(failDict)

    @expose_page(methods='POST')
    def parse(self, q=None, intentions=None, namespace=None, owner=None):
        """
        EXAMPLE request:
 
        q=search foo bar&intentions=[
             {
                 "name" : "addterm",
                 "arg"       : "baz"
             },
             {
                 "name" : "toggleterm",
                 "arg"       : "quux"
             }
        ]
        """

        self.counter += 1
        sequence = str(time.time()) + '.' + str(self.counter)
        
        logger.debug("Parse/Apply Intentions: q: %s intentions: %s" % (q, intentions))

        try:
            
            if intentions is None:
                # just parse the search
                replacedIntentions = []
                parsedObj = splunk.search.Parser.parseSearch(
                    q, 
                    hostPath=self.splunkd_urlhost, 
                    sessionKey=cherrypy.session['sessionKey'],
                    namespace=namespace,
                    owner=owner
                )
            else:
                logOutput = []
                
                decodedIntentions = json.loads(intentions)
                logOutput.append('PARSE %s IN   %s' % (sequence, json.dumps({'q': q, 'intentions': json.loads(intentions)})))

                # do the string replacement here.
                replacedQ, replacedIntentions = self._applyStringReplacement(q, decodedIntentions)
                logOutput.append('PARSE %s OUT1 %s' % (sequence, json.dumps({'q': replacedQ, 'intentions': replacedIntentions})))

                parsedObj = self._parseAndApplyIntentions(replacedQ, replacedIntentions, namespace=namespace, owner=owner)
                logOutput.append('PARSE %s OUT3 %s' % (sequence, json.dumps(parsedObj.jsonable())))
                parserLogger.error('PARSE %s OUT5 %s' % (sequence, str(parsedObj)))

                #for line in logOutput:
                #    parserLogger.debug(line)

        except Exception, e:
            logger.exception(e)
            return self._failJSON( _("PARSER: Applying intentions failed %s" % str(e) ) )

        # return a JSON object
        logger.debug("SIZE OF INTENTION QUEUE: %s" % len(replacedIntentions) )
        if len(replacedIntentions) < 1:
            logger.debug("RAW JSONABLE %s" % parsedObj.rawJsonable() )
            return self.render_json(parsedObj.rawJsonable())

        return self.render_json(parsedObj.jsonable())


    @expose_page(methods=['POST', 'GET'])
    def decompose(self, q=None, namespace=None, owner=None):
        logger.debug("Decomposing intentions: %s" % q)

        try:
            parsedObj = splunk.search.Parser.parseSearch(
                q, 
                hostPath=self.splunkd_urlhost, 
                sessionKey=cherrypy.session['sessionKey'],
                namespace=namespace,
                owner=owner
            )
            decomposedSearch, intentions = xformer.decomposeSearch(namespace, owner, parsedObj, q)
            logger.debug("Decomposing intentions result search: %s intentions: %s" % (decomposedSearch, intentions))

        except Exception, e:
            return self._failJSON( _("PARSER: Unsupported search (%s): %s" % (q, e)))

        # return a JSON object
        return self.render_json({ "search" : str(decomposedSearch), "intentions": intentions})

    def _applyStringReplacement(self, q, intentions):
        REPLACE_INTENT_NAME = 'stringreplace'

        # find all string replacement intents
        replaceIntents = [intention for intention in intentions if intention[INAME] == REPLACE_INTENT_NAME]
        intentions     = [intention for intention in intentions if intention[INAME] != REPLACE_INTENT_NAME]

        for replacement in replaceIntents:
            for token, props in replacement.get('arg').items():
                default = props.get('default', None);
                value = props.get('value', None)
                prefix = props.get('prefix', '')
                suffix = props.get('suffix', '')
        
                if (not value or value == '') and default:
                    value = default

                if props.get('fillOnEmpty', False) and (value == None):
                    q = q.replace('$%s$' % token, '').strip()
                    continue

                if value != None:
                    replacement_str = prefix + value + suffix
                    q = q.replace('$%s$' % token, replacement_str).strip()

        return q, intentions

    def _parseAndApplyIntentions(self, q=None, intentions=None, namespace=None, owner=None):

        # first, try to parse the given search string
        parsedObj = splunk.search.Parser.parseSearch(
            q, 
            hostPath=self.splunkd_urlhost, 
            sessionKey=cherrypy.session['sessionKey'],
            namespace=namespace,
            owner=owner
        )

        # walk through the transform stack
        for intention in intentions:
            if intention[INAME] not in ["", None]:
                intentName = intention[INAME]
                intentArg = intention.get(IARG, {} )
                intentFlags = intention.get(IFLAGS, None )
                parsedObj = xformer.applyIntention(namespace, owner, parsedObj, intentName, intentArg, intentFlags)
        return parsedObj

    # tests have moved to ../test/test_string_replacement.py
