import cherrypy
import xml.sax.saxutils as su
from splunk.appserver.mrsparkle import *
import logging
import splunk.rest, splunk.rest.format

logger = logging.getLogger('splunk.appserver.controllers.proxy')

class ProxyController(BaseController):
    """/splunkd"""

    @route('/*_proxy_path')
    @expose_page(must_login=False, methods=['GET','POST'])
    def index(self, **args):
        
        if cherrypy.request.method=='POST' and not cherrypy.config.get('enable_proxy_write'):
            return self.generateError(405, _('Write access to the proxy endpoint is disabled.'))

        if not cherrypy.session.get('sessionKey'):
            logger.warn('proxy accessed without stored session key')

        uri = args['_proxy_path']

        if uri.startswith('__raw/'):
            # Don't parse any response even if it's a 404 etc
            rawResult = True
            uri = uri[6:]
        else:
            rawResult = False

        # Force URI to be relative so an attacker can't hit any arbitrary URL
        uri = '/' + uri

        if cherrypy.request.query_string:
            uri += '?' + cherrypy.request.query_string
            
        postargs = None
        if cherrypy.request.method == 'POST':
            postargs = args
            del postargs['_proxy_path']
            
        proxyMode = False
        if 'authtoken' in args:
            proxyMode = True
        
        try:
            
            serverResponse, serverContent = splunk.rest.simpleRequest(
                uri, 
                cherrypy.session.get('sessionKey'), 
                postargs=postargs,
                method=cherrypy.request.method,
                raiseAllErrors=True,
                proxyMode=proxyMode,
                rawResult=rawResult
            )

            for header in serverResponse : 
                cherrypy.response.headers[header] = serverResponse[header]
                
            if serverResponse.messages:
                return self.generateError(serverResponse.status, serverResponse.messages)
            
            if rawResult:
                cherrypy.response.status = serverResponse.status

            return serverContent
                
        except splunk.RESTException, e:
            logger.exception(e)
            return self.generateError(e.statusCode, e.extendedMessages)
            
        except Exception, e:
            logger.exception(e)
            return self.generateError(500, su.escape(str(e)))
            
            
    def generateError(self, status, messages=None):
        output = [splunk.rest.format.XML_MANIFEST, '<response>']
        output.append('<meta http-equiv="status" content="%s" />' % su.escape(str(status)))
        if messages:
            output.append('<messages>')
            
            if isinstance(messages, list):
                for msg in messages:
                    output.append('<msg type="%s">%s</msg>' % (su.escape(msg['type']), su.escape(msg['text'])))
            else:
                output.append('<msg type="ERROR">%s</msg>' % str(messages))
            output.append('</messages>')
            
        output.append('</response>')
        
        return '\n'.join(output)
        
