import base64, zlib
import json
import logging

logger = logging.getLogger('splunk.appserver.lib.statedict')


BASE64=1

class StateDict(dict):
    """
    Simple class to provide a serializable dict for storing state
    in web forms
    """

    def serialize(self, format=BASE64):
        if not len(self):
            return ''
        if format==BASE64:
            return base64.urlsafe_b64encode(zlib.compress(json.dumps(dict(self))))
        raise ValueError("Invalid format specified")

    @classmethod
    def unserialize(cls, data, format=BASE64):
        if not data:
            return cls()
        if format==BASE64:
                try:
                    return cls(json.loads(zlib.decompress(base64.urlsafe_b64decode(str(data)))))
                except Exception ,e:
                    logger.error("Failed to decompress StateDict: %s" % e)
                    raise ValueError("Invalid state string supplied")
        raise ValueError("Invalid format specified")

