import urllib, urllib2, json, string

import cherrypy
import logging
import splunk
import time


logger = logging.getLogger('splunk.appserver.lib.storm')

# Maximum number of times to attempt to contact the storm appserver
MAX_ATTEMPTS = 8

# Number of seconds to wait before the initial retry
INITIAL_DELAY = 0.5

# How much longer to wait for subsequent retries
DELAY_MULTIPLIER = 1.5

# Max aggregate delay with above settings is around 16 seconds


class AppserverUnreachable(BaseException):
    pass


def get_storm_defaults(force_new_session=False):
    host = cherrypy.config.get('storm_host')
    port = cherrypy.config.get('storm_port', 443)
    scheme = cherrypy.config.get('storm_scheme', 'https')

    if not (host and scheme):
        return None

    data = {"token":cherrypy.session.get('storm_token')}
    if not data['token']:
        logger.warn("No storm_token set in the user's session; returning None from get_storm_defaults")
        return None

    storm_route_cache = cherrypy.session.get('storm_route_cache')

    if force_new_session:
        data['newSession'] = '1'
    elif storm_route_cache:
        return storm_route_cache

    if port != 80 and port != 443:
        url = "%s://%s:%s/mgmtapi/getRoute/" % (scheme, host, port)
    else:
        url = "%s://%s/mgmtapi/getRoute/" % (scheme, host)

    response = None
    delay = INITIAL_DELAY
    for attempt in range(MAX_ATTEMPTS):
        req = urllib2.Request(url=url, data=urllib.urlencode(data))
        try:
            logger.info("Begin query storm getRoute API attempt=%s url=%s" % (attempt+1, url))
            response = urllib2.urlopen(req)
            break
        except Exception, e:
            if attempt < (MAX_ATTEMPTS - 1):
                logger.exception("Failed to query storm getRoute API at %s - Retrying in %.1f seconds" % (url, delay))
                time.sleep(delay)
                delay *= DELAY_MULTIPLIER
            else:
                logger.exception("Failed to query storm getRoute API at %s - Giving up after %s attempts" % (url, attempt+1))

    if not response:
        return None

    logger.info("Fetched storm token from getRoute after attempt=%s" % (attempt+1,))

    data = json.loads(response.read())
    if data and data.has_key('searchers'):
        shead = data['searchers'][0]
        result = {
            'host': shead['mach'],
            'port': 8089,
            'protocol': 'https',
            'namespace': 'search',
            'user': shead['slot'], 
            'sessionKey': shead['session']
        }
        cherrypy.session['storm_route_cache'] = result
        return result

    raise AppserverUnreachable()


def hook_storm_session():
    splunk.getDefault = storm_get_default


def storm_get_default(key):
    defaults = get_storm_defaults()
    if defaults:
        return defaults.get(key)
    return None


def decrypt_token(token):
    """Decrypt using stupid simple (and no doubt insecure) xor based algorithm"""
    charset = string.ascii_letters + string.digits + '-;'
    mapping = dict([ (ch, i) for i, ch in enumerate(charset)])
    key = cherrypy.config.get('storm_shared_key')
    data = ''.join( [ charset[ mapping[token[i]] ^ mapping[key[i]] ] for i in xrange(len(token))] )
    try:
        salt, token, timestamp = data.split(';')
    except ValueError:
        logger.warn('Failed to decrypt supplied storm session token')
        return 0, ''
    return int(timestamp), token
