# Copyright (C) 2005-2011 Splunk Inc. All Rights Reserved.  Version 4.0
# All help strings for clilib.
# Help string declarations, and help string calls (addHelp's...)


#Use this command to test for ASCII weirdness
#sed -e "s/[-0-9A-Za-z\"',()#%\^\*_+=\[\/\.:;\t |<>{}\$\!\&\?,@]*//g" -e "s/\]//g" literals.py | grep -v '^\w*$

# this stuff is not to be messed with
helpStrs = {}
def addHelp(cmd, hShort, hLong):
	global helpStrs
	helpStrs[cmd] = {"helpShort" : hShort, "helpLong" : hLong}

###################################################################
######################   Begin Help String Declarations  ###################

###################################################################
# Command definitions
ADDEDIT_LONG="""
   Add or edit data inputs, user accounts, or saved searches.
     
   Type "./splunk help saved-search" to learn how to add alerts and saved 
   searches. 

   Type "./splunk help [topic name | object name | parameter name]" to get 
   help on any topic, object, or parameter.        

   Syntax: 

      add [object] [-parameter <value> | <value>] 
       
      edit [object] [-parameter <value> | <value>]

   Objects:

   (For add ONLY)
      licenses             adds a license to the appropriate stack

   (For edit ONLY)
      app                  edits app properties
      licenser-localslave  edits attributes of local license slave node
      licenser-groups      edits attributes of licenser group

   (For both)
      exec                 adds/edits scripted inputs
      forward-server       adds servers to forward data to
      index                adds/edits indexes on this server
      licenser-pools       adds a pool to a stack
                           edits a pool within a stack
      monitor              adds/edits monitor (filesystem) inputs
      oneshot              adds onetime file input
      saved-search         adds/edits current user saved searches
      search-server        adds/edits servers that this server distributes 
                           searches to
      tcp                  adds/edits TCP (network) inputs
      udp                  adds/edits UDP (network) inputs
      user                 adds/edits users to this Splunk server 
      
   Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for example: 
   127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on IPv4 only. To enable IPv6 
   support, refer to the instructions in:
   http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6
       
   Required Parameters: 

   Object              Parameter       Description

   app                 appname         the name of the app to edit (if optional 
                                       parameters are not included, app properties
                                       are not changed)

   exec                source          command and arguments to be run

   forward-server      hostport        in the format <host>:<port> where host and 
                                       port are hostname or IP address of the 
                                       indexing server and port that the indexer is 
                                       listening on
             
   index               name            name of index (if none set - then use all)
       
   licenser-localslave master_uri      uri of the splunkd license master instance OR 'self' 

   licenser-groups     name            name of the licenser group
                       is_active       whether this licenser group is to be enabled (1)

   licenser-pools      name            for add/edit, name of the new pool
                       quota           for add ONLY, new allocation size of the pool
                       stack_id        for add ONLY, stack that this pool belongs to
   licenses            path            path to the new license file

   monitor             source          path to a directory whose contents will
                                       be indexed
     
   oneshot             filename        name of a file to add to inputs

   saved-search        name            (default) name of saved search to create
                       terms           search terms to be associated with this 
                                       saved search
        
   search-server       <host>:<port>   supply the hostname or IP address and
                                       splunkd port of the remote server
                       remoteUsername  username to access the remote server
                       remotePassword  password to access the remote server
   
   tcp                 source          port where Splunk should listen for events
  
   udp                 source          port where Splunk should listen for events
 
   user                username        create a (default) username for the user
                       full-name       specify the full name of the user in quotes, 
                                       for example: 'First Last'
                       role            assign a role to the user. For multiple roles, 
                                       use separate flags for each role
                       email           specify the email address to assign to the 
                                       user
                       password        specify the password to assign to the user
      
   Optional Parameters:

   app                 label           quoted string description for the app
                       visible         specify whether to display the app (true) or
                                       not to display the app (false) in Splunk Web

   exec                hostregex       regular expression on the file path to set 
                                       as host value
                       hostname        hostname to set as the host value
                       index           index to place events in
                       interval        number of seconds to wait before running the
                                       command
                       keep-open       set the command to not terminate
                       sourcetype      source type value to set for events from the 
                                       source
                           
   forward-server      method          set forwarding method to data-cloning or 
                                       load-balancing (default=clone)
             
   index               dir             specify a directory to create your index in

   licenser-pools      append_slaves   for edit ONLY, a flag to append the slave to the
                                       existing list rather than overwriting it
                       description     for add/edit, human readable description
                       quota           for edit ONLY, new allocation size of the pool
                       slaves          for add/edit, list of slaves that are part of
                                       this pool

   saved-search        alert           make the search an alert (true|false, 
                                       default=false)
                       summary_index   the name of the summary index where to 
                                       add the results of the scheduled search
                       fields          a list of key-value pairs to annotate the 
                                       events inserted into the summary index. 
                                       format pairs as key:value and separate 
                                       multiple entries with a semicolon
                       start_time      the earliest time for the search
                       end_time        the latest time for the search
                       ttl             time-to-live (in seconds) for the artifacts
                                       of the scheduled search

                       (IF optional parameter "alert" is set to true, then the
                       following is REQUIRED)

                          schedule     specify when the alert is run using full
                                       cron format

                       (IF optional parameter "alert" is set to true, then at
                       least one of the following is REQUIRED)

                          email        comma-separated list of email addresses to 
                                       send alerts to (true|false, default=false)
                          attach       specify inclusion of search results in
                                       emails (true|false, default=false)
                          script       script to execute upon alert 
                                       (ex: $SPLUNK_HOME/bin/myScript)
                          threshold    the threshold to trigger the alert action 
                                       [<threshold type>:<relation>:<quantity>]
                                       <threshold type> = num-events,num-sources,num-hosts
                                       <quantity> = any integer
       
   monitor             sourcetype      source type value to set for events from
                                       the source
                       rename-source   For ADD only, explicitly set the source value for events
                       index           index to place events in 
                       hostname        host name to set as the host value
                       hostregex       regular expression on file path to set as
                                       host value
                       hostsegmentnum  number of segments in file path to set 
                                       as host value
                       follow-only     only read from the end of the file 
                                       ("tail -f") (true|false, default=false)
   
   tcp                 remotehost      specify IP address to exclusively accept data from                                
                       sourcetype      source type value to set for events from 
                                       the source
                       index           index to place events from the source
                       hostname        host name to set as the host value
                       resolvehost     specify whether to use DNS to set the host
                                       value (true|false, default=false)

   udp                 remotehost      specify an IP address to exclusively accept data from
                       sourcetype      source type value to set for events from 
                                       the source
                       index           index to place events in
                       hostname        host name to set as the host value
                       resolvehost     specify whether to use DNS to set the host
                                       value (true|false, default=false)
                           
  
    Examples:

          ./splunk add monitor -source /var/log

          ./splunk add monitor -source file.log -rename-source file

          ./splunk add forward-server bologna:9997
       
          ./splunk add search-server hulk:5555 -remoteUsername user1 -remotePassword passwd1

          ./splunk add user aaron -role admin -role user -password changeme 

          ./splunk edit app myapp -label "this is my app" -visible true

          ./splunk edit saved-search apache_errors -terms "404 OR 403"


     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation      
      
   
"""

ANONYMIZE_LONG="""
     Use anonymize to replace identifying data (usernames, IP addresses, domain 
     names, etc.) with fictional values that maintain the same word length and
     event type. Anonymizing data lets Splunk users share log data without 
     revealing  confidential or personal information from their networks.

     You can specify custom rules for Splunk's anonymizer by using the 
     parameters to specify your own word lists.

     Syntax:

        anonymize file -source [-parameter <value>]...

     Objects:

        source           file to anonymize

     Parameters: 

        public-terms     file containing a list of locally-used words to NOT anonymize
                         (default= $SPLUNK_HOME/etc/anonymizer/public-terms.txt)                  

        private-terms    file containing a list of words to anonymize
                         (default= $SPLUNK_HOME/etc/anonymizer/private-terms.txt)  

        name-terms       file containing a list of common English personal
                         names that Splunk uses to anonymize names with
                         (default= $SPLUNK_HOME/etc/anonymizer/names.txt)

        dictionary       file containing a global list of commonly-used 
                         words to NOT anonymize - unless they are in the 
                         private-terms file 
                         (default= $SPLUNK_HOME/etc/anonymizer/dictionary.txt)

        timestamp-config  file that determines how timestamps are parsed
                          (default= $SPLUNK_HOME/etc/anonymizer/
                          anonymizer-time.ini)

     Examples:

        ./splunk anonymize file -source /tmp/messages

        ./splunk anonymize file -source /tmp/messages -name_terms $SPLUNK_HOME/bin/Mynames.txt 


     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation


"""

CLEAN_LONG="""
    The clean command deletes event data, global data, and user account data 
    from your Splunk installation. 
    
    Permanently remove event data from an index by typing, "./splunk clean 
    eventdata". Set the index parameter to delete event data from a specific 
    index. If you don't set an index, Splunk deletes all event data from all 
    indexes.

    Remove global data (tags and source type aliases for events you indexed) 
    from Splunk by typing, "./splunk clean globaldata".

    Remove user data (user accounts you've created) from Splunk by typing, 
    "./splunk clean userdata".

    ** Caution: **
    Removing data is irreversible. Use caution when choosing what data to 
    remove from your Splunk installation. If you want to get your data back, 
    you must re-index the applicable data sources.

    ** Note: **
    Add the -f parameter to force clean to skip its confirmation prompts.


     Syntax: 
        
        clean  eventdata [-f] [-index <name>]
        
        clean [globaldata|userdata|all] [-f]
         
     Objects: 

          eventdata    exported events indexed as raw log files
          
          globaldata   host tags, source type aliases     

          userdata     user accounts

          all          everything on the server

     Required Parameters: 

         eventdata     if no index specified, the default is to clean all 
                       indexes            

     Optional Parameters:

         eventdata     index   name of index whose eventdata should be cleaned
                       f       forces clean to skip its confirmation prompt
                               (Cleaning cannot be undone. Use carefully!)
         
         globaldata    f       forces clean to skip its confirmation prompt
                               (Cleaning cannot be undone. Use carefully!)

         userdata      f       forces clean to skip its confirmation prompt
                               (Cleaning cannot be undone. Use carefully!)          

     Examples:

          ./splunk clean eventdata

          ./splunk clean globaldata

          ./splunk clean eventdata -index main -f

     
     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation
"""

CREATE_LONG="""

     Builds a new app from a template.  

     It provides a scaffolding for development of new apps.

     Syntax:

        create app appname [-parameter <value>]

     Parameters: 

        appname     name of the new app
        
        template    if no template specified, default template will be used

     Examples: 

        ./splunk create app myNewApp -template sample_app

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation
     
"""


DIAG="""
     Collects basic info about your Splunk server, including Splunk's 
     configuration details. 

     ** Important ** It does not include any event data or private 
     information.

     Syntax:

        diag

     Objects: 

        NONE

     Parameters: 

        NONE

     Examples: 

        ./splunk diag

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation
     
"""

DISPATCH_LONG="""
     Searching with dispatch lets you run long-running reports via the CLI. 
     Use dispatch to search a large number (or unlimited) number of results to
     process a report. Searches run using dispatch are only limited by the 
     parameters you set (maxout or maxtime). You can set when to end a 
     dispatched search by setting a maximum time (maxtime) or a maximum number
     of results to output (maxout).

     ** Note: **
     dispatch uses the same syntax as the search command.  


     Syntax:

       dispatch "search string" [-parameter]


     Objects: 

       search string     String to search and report on.


     Required Parameters:

       NONE


     Optional Parameters: 

       maxout     Set the maximum number of results to return from the search
                  string (default=100)
       maxtime    Set the maximum number of seconds to run the search 
                  (default=0 or no limit)


     Examples:

       ./splunk dispatch "source=*hot* | stats count" -maxtime 3

       ./splunk dispatch "sourcetype=access* bytes>1000" -maxout 200 


     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation


"""

DISABLEENABLE_LONG="""
    Disable or enable applications, Splunk server features, and distributed 
    search features.

     Syntax:
 
        disable [object] [-parameter <value> | <value>]
    
        enable [object] [-parameter <value> | <value>]

     Objects:

        app              disable or enable the specified app

        boot-start       set Splunk to run when the operating system boots

        discoverable     broadcast availability for Distributed Search 
                         from other Splunk servers

        dist-search      disable or enable the distributed search capability of
                         the server
 
        deploy-client    disable or enable deployment client server capability
 
        deploy-server    disable or enable deployment server capability

        index            disable or enable writing to an index
 
        listen           open a port to listen for distributed search data from 
                         forwarders
 
        local-index      turn on local file indexing (disabling affects only 
                         forwarders)

        webserver        set whether the Splunk server should be started

        web-ssl          make Splunk Web's HTTP port use SSL encryption
        
     Required Parameters:
 
        app              appname     the name of the app

        index            name        the name of the index

        listen           <port>      which TCP port to listen on

        boot-start       NONE
        discoverable     NONE
        dist-search      NONE
        deploy-client    NONE
        deploy-server    NONE
        local-index      NONE
        webserver        NONE
        web-ssl          NONE


     Optional Parameters:

        boot-start   user   specify which user to run the script as at boot
                            time (default=root)

        NONE for any other object


     Examples:

        ./splunk disable index -name _audit

        ./splunk disable listen 9997
  
        ./splunk enable app unix

        ./splunk enable dist-search

        ./splunk enable index -name main

        ./splunk enable listen 9997

        ./splunk enable boot-start -user bob


     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation    

"""

DISPLAY_LONG="""
   Display the current status of your server's distributed search features.

     Syntax:
 
        display [object] [<value>]

     Objects:

        app              display status information (enabled/disabled, visible/
                         invisible, configured/not configured) about a specific
                         app or all apps

        discoverable     display available Distributed Search servers

        dist-search      display the distributed search capability of the 
                         server

        deploy-client    Shows whether the deployment client is enabled or not

        deploy-server    display deployment server capability
    
        jobs             display the results of the specified asynchronous 
                         search

        listen           display the port to listen for distributed search data 
                         from Splunk forwarders

        local-index      display the index where files are locally stored
        
     Required Parameters:

        app              appname  the name of a specific app to display status
                                  if name is not provided, displays all installed
                                  apps and their status information

        jobs             id    the job id for the asynchronous search              

     Optional Parameters:

        NONE for all objects.

     Examples:
        
        ./splunk display app
 
        ./splunk display app unix

        ./splunk display jobs 1240007498.2 

        ./splunk display local-index


     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation       

"""

EXPORTIMPORT_LONG="""
     Import or export Splunk global data, user data, or event data into or out
     of your Splunk server.

     Use import and export to migrate data from one Splunk installation to 
     another.
           
     Syntax: 
        
        export [object] [-parameter <value>] ...
        
        import [object] [-parameter <value>] ...
         
     Objects:      

          userdata       user accounts

          eventdata      exported events indexed as raw log files 

     Required Parameters: 

          userdata     dir    directory to import data from or export data to

          eventdata    index  (default) specify which Splunk index to export events from
                       dir    specify which directory to export data to 


     Optional Parameters:

          userdata     NONE

          eventdata    host         export events for the specified host
                       source       export events for the specified source
                       sourcetype   export events for the specified sourcetype
                       terms        export events containing the given terms
                        

     Examples:

          ./splunk import userdata -dir /tmp/export.dat

          ./splunk export eventdata -index my_apache_data -dir /tmp/apache_raw_404_logs -host localhost -terms "404 html" 

          ./splunk export eventdata -index main -dir /tmp/events -host www -sourcetype syslog -terms "dhcp OR bind"

     
     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation  

"""

FIND_LONG="""
     Find potential logfiles for Splunk to index. If multiple files
     are found, Splunk prompts the user to collapse the files into a
     common directory. Then, Splunk prompts the user to index all,
     some, or none of the files. Splunk will not index files if that
     input already exists.

     Syntax: 

        find [<searchpath>]

     Object: 

        searchpath      semi-colon separated list of paths to search    

     Examples: 

        ./splunk find "../etc;../var"


     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

HELP_LONG="""
     Display the default help page, or any specific topic or command help page.           

     Syntax: 
        
          help [command|parameter|object|topic] 
            
     Required (default) parameter:

          NONE     if no topic is specified, display the default help page
  

     Optional parameters:

          help                                displays the main help page
          [command|object|parameter|topic]    links to a help page relating to
                                              the specified topic 


     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation   
   
   
  

"""

LIST_LONG="""
     List the status of your Splunk server's configuration attributes.

     Syntax:

        list [object] [<value>]
       
     Objects:
    
        deploy-clients       lists the deployment clients that have contacted this 
                             deployment server
        exec                 lists currently active scripted execution inputs
        forward-server       lists servers that this server forwards data to
        index                lists all indexes on this server. Specify an index name to
                             see attributes for that index.
        jobs                 lists all currently running asynchronous searches, 
                             sorted by job ID. Specify a job ID to see attributes for
                             that search job.
        licenser-groups      lists all current groups
        licenser-localslave  lists attributes of local license slave
        licenser-messages    lists the current licenser messages
        licenser-pools       lists pools across all stacks
        licenser-slaves      lists attributes of license slaves
        licenser-stacks      lists all the current stacks
        licenses             lists all licenses across all stacks
        monitor              lists all active monitored (filesystem) inputs
        saved-search         lists the current user's saved searches
        search-server        lists the other Splunk servers that this server distributes 
                             searches to
        tcp                  lists all active TCP (network) inputs
        udp                  lists all active UDP (network) inputs
        user                 lists all users known to Splunk
        

     Required Parameters:

        NONE

     Optional Parameters:

        NONE

     Examples:

        ./splunk list index _internal

        ./splunk list jobs 1279674107.359
        
        ./splunk list licenser-messages

        ./splunk list monitor

        ./splunk list search-server


     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation   
   

"""

LOGINLOGOUT_LONG="""
           
     Authenticate a session to a Splunk server with an Enterprise license 
    (login). Or, end an authenticated session (logout).

     Login stores authentication information in the /splunk directory of the 
     system user's home directory.

     Syntax: 
        
        login     prompts you for a Splunk username and password
            
        logout    ends an authenticated session

     Parameters:

          NONE

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation   
  
  


"""

PACKAGE_LONG="""
           
     Create tar package of an app.

     The package can be distributed via SplunkBase or deployed locally.

     Syntax: 
        
        package app     packages the app and returns its uri
            
     Parameters:

        appname         name of the app that needs packaging

     Examples: 

       ./splunk package app stubby
        
     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation   
  

"""


INSTALL_LONG="""
           
     Install an app from a tar.gz package to the local Splunk server.

     The package might be referenced either via a url or a local path. 

     Syntax: 
        
        install app     installs the app from a given source
            
     Parameters:

        source          url or local path of the package to be installed

     Examples: 

       ./splunk install app /tmp/imap.tar.gz
       ./splunk install app http://localhost:8080/imap.tar.gz
        
     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation   
  

"""


REFRESH="""
     Update a deployment server with current deployment client server 
     information.

     Syntax: 
   
       refresh [object]

     Objects: 

       deploy-clients    Update a deployment server with the latest deployment 
                         client information

     Required Parameters: 

       NONE

     Optional Parameters:
 
       NONE

     Examples: 

       ./splunk refresh deploy-clients

     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation 

"""

RELOAD_LONG="""

     Reload your authentication system or deployment servers.

     Syntax: 

       reload [object] [-parameter <value>]

     Objects
       
       auth              reload authentication system (no additional 
                         parameters)

       deploy-server     update deployment server with configuration data 
                         on disk
     
     Required Parameters: 

       NONE              

     Optional Parameters:

       for deploy-server ONLY:
 
       class             specify a single server class to be updated
                         (if none specified then all classes are updated)

       check-new         (true|false) causes the server to check for new and 
                         deleted applications instead of only those currently 
                         handled  
   

     Examples: 

       ./splunk reload auth

       ./splunk reload deploy-server -class wwwclass
    
       ./splunk reload deploy-server -check-new true

       
     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation 


"""

REMOVE_LONG="""
     Remove data inputs, user accounts, or saved searches.

     Syntax: 

        remove [object] [-parameter <value> | <value>]

     Objects:

        app             remove specified app name
        exec            remove scripted execution inputs
        forward-server  remove servers to forward data to
        jobs            remove the specified asynchronous search or all 
                        asynchronous searches
        licenser-pools  removes a pool within a stack
        licenses        removes a license from within the stack
        monitor         remove monitored (filesystem) inputs
        saved-search    remove current user saved searches
        search-server   remove servers that this server distributes searches to
        tcp             remove TCP (network) inputs
        udp             remove UDP (network) inputs
        user            remove users to this Splunk server
        
     Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for example: 
     127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on IPv4 only. To enable IPv6 
     support, refer to the instructions in:
     http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6
        
     Required Parameters:

        app             appname         the name of the app

        exec            source          command and arguments to be run

        forward-server  hostport        in the format <host>:<port> where host and port are hostname
                                        or IP address of the indexing server and port that the 
                                        indexer is listening on

        jobs            id              the job id for the asynchronous search 
                        all             cancels all asynchronous searches currently running

        licenser-pools  name            name of the pool to remove

        licenses        hash            has of the license file to remove       

        saved-search    name            (default) name of saved search to create
        
        search-server   <host>:<port>   supply the hostname or IP address and splunkd port 
       
        monitor         source          path to a directory or index
     
        tcp             source          port where Splunk should listen for events
  
        udp             source          port where Splunk should listen for events
 
        user            username        create a (default) username for the user


    Optional Parameters:

        NONE

       
     Examples: 
 
        ./splunk remove app unix

        ./splunk remove monitor -source /var/log

        ./splunk remove jobs 1240007498.2 

        ./splunk remove jobs all 


     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation


"""

RTSEARCH_LONG="""

  Search events before they are indexed and preview reports as the
  events stream in. Use the rtsearch command exactly as you use the
  traditional search command. For more information, type "help search".

  Syntax:

      rtsearch [object][-parameter <value>]

  Note: Parameters that take Boolean values support {0, false, f, no} as
  negatives and {1, true, t, yes} positives.
          
  Objects:

     Search objects are enclosed in single quotes (' ') and can be keywords,
     expressions, or a series of search commands.

  Optional Parameters:

    app          appname     specify an app context to run the search

    batch        true        indicates how to handle updates in preview mode.
                             Defaults to false. 

    detach       true        triggers an asynchronous search and displays
                             the job id and ttl for the search.

    header       false       indicates whether to display a header in the table
                             output mode.

    id           rt_<job id> search job ID number.

    max_time     number      the length of time in seconds that a search job
                             runs before it is finalized. Defaults to 0, which
                             means no time limit.

    maxout       number      the maximum number of events to return or send to
                             stdout (when exporting events). The max allowable
                             value is 10k. Defaults to 0, which means it will
                             output an unlimited number of events.

    output       value       indicates how to display the job. Choices are:
                             rawdata, table, csv, raw, and auto. If not specified,
                             defaults to rawdata for non-transforming searches
                             and table for transforming searches.

    preview      false       indicates that reporting searches should be
                             previewed. Defaults to true.
                         
    timeout      number      the length of time in seconds that a search job 
                             is allowed to live after running. Defaults to 0,
                             which means the job is cancelled immediately after
                             it is run.

    wrap         false       indicates whether to line wrap for individual lines
                             that are longer than the terminal width. Defaults
                             to true.

  See what search language is available for use in the CLI by using these 
  help commands:

      search-fields          a full list of search fields
      search-modifiers       a full list of search modifiers
      search-commands        a full list of usable search commands

  For more information about how to specify time-modifiers, search the online 
  documentation for "search time modifier".

  Examples: 

      ./splunk rtsearch 'error' -wrap false 

      ./splunk rtsearch 'eventtype=webaccess error | top clientip'
  
      ./splunk rtsearch 'eventtype=webaccess error' -output csv

      ./splunk rtsearch -id rt_1293485632.11


  Type "help [object|topic]" to view help on a specific object or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation  
 
"""

SEARCH_LONG="""

    Splunk searches can be simple keyword searches or can be more complex
    searches with data extraction and statistical reporting. Complex searches 
    are constructed by piping commands together with a "|" operator (much like 
    a Unix shell). For more on constructing searches and  search syntax, see 
    our online documentation at: http://docs.splunk.com/Documentation.  

  Syntax:

    search [object][-parameter <value>]

  Note: Parameters that take Boolean values support {0, false, f, no} as
  negatives and {1, true, t, yes} positives.

  Objects:

    Search objects are enclosed in single quotes (' ') and can be keywords,
    expressions, or a series of search commands.

  Optional Parameters:

    app            appname        specify an app context to run the search

    batch          true           indicates how to handle updates in preview 
                                  mode. Defaults to false. 
 
    detach         true           triggers an asynchronous search and displays
                                  the job id and ttl for the search.

    earliest_time  time-modifier  relative time modifier for the start time 
                                  of the search

    header         false          indicates whether to display a header in the 
                                  table output mode.

    id             job id         search job ID number.

    lastest_time   time-modifier  relative time modifier for the end time of the 
                                  search

    max_time       number         the length of time in seconds that a search job
                                  runs before it is finalized. Defaults to 0,
                                  which means no time limit.

    maxout         number         the maximum number of events to return or send
                                  to stdout (when exporting events). Setting this  
                                  to 0 means it will output an unlimited number
                                  of events. The max allowable value is 10k. 
                                  Defaults to 100.

    output         value          indicates how to display the job. Choices are:
                                  rawdata, table, csv, raw, and auto. If not 
                                  specified, defaults to rawdata for non-transforming
                                  searches and table for transforming searches.

    preview        false          indicates that reporting searches should be
                                  previewed. Defaults to true.
                         
    timeout        number         the length of time in seconds that a search 
                                  job is allowed to live after running. Defaults 
                                  to 0, which means the job is cancelled immediately
                                  after it is run.

    wrap           false          indicates whether to line wrap for individual
                                  lines that are longer than the terminal width.
                                  Defaults to true.

  See what search language is available for use in the CLI by using these 
  help commands:

        search-fields        a full list of search fields
        search-modifiers     a full list of search modifiers
        search-commands      a full list of usable search commands

  For more information about how to specify time-modifiers, search the online 
  documentation for "search time modifier".

  Examples: 

        ./splunk search '*' -detach true 

        ./splunk search 'eventtype=webaccess error' -wrap false
  
        ./splunk search 'eventtype=webaccess error' -detach true

        ./splunk search '* | stats count' -earliest_time -1h@h -latest_time @h 

        ./splunk search -id 1293485632.11


    Type "help [object|topic]" to view help on a specific object or topic. 

    Complete documentation is available online at: http://docs.splunk.com/Documentation  
 

"""

SETSHOW_LONG="""
     Set or show current values for settings of your Splunk installation.


     Syntax: 

        set [object][-parameter <value> | <value>]
  
        show [object][<value>]

   
     Objects for the SHOW command ONLY:

        config              show the details of a specified conf file. 
                            (NOTE: this command will only work if the file exists in the location 
                            specified by $SPLUNK_HOME/etc/system/default/conf.conf)

        jobs                show information for the specified asynchronous 
                            search


     Objects for both SET and SHOW:
  
        datastore-dir       set or show which directory is used for Splunk's datastore

        deploy-poll         enable the deployment client and set the deployment server uri to poll

        default-hostname    set or show the default host name used for all data inputs

        default-index       set or show the default index(es) for all data inputs
        
        minfreemb           set or show the minimum free disk space threshold 
                            (if free space falls below this amount Splunk stops indexing data)

        servername          set or show the servername used in a distributed search

        splunkd-port        change the port that the Splunk daemon (splunkd) listens on
        
        web-port            change the port that Splunk Web listens on


     Required Parameters: 

      For set: 

        datastore-dir       <value>       path to new datastore directory

        deploy-poll         uri           deployment server ip:port to poll for deployment class 
                                          updates 
                                          
                            Note: When specifying an IP address, IPv4 and IPv6 formats are 
                            supported, for example: 127.0.0.1:80 or "[2001:db8::1]:80"
                            By default, splunkd listens on IPv4 only. To enable IPv6 support, 
                            refer to the instructions in:
                            http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6

        default-hostname    value         new host name to use

        default-index       value         one or list of indexes; if multiple, delimit each value 
                                          with a comma
                            role          specify a role (admin, power, user) that can view the 
                                          default index
        minfreemb           minspace      new number of megabytes

        servername          <name>        new distributed search name for the server instance

        splunkd-port        <port>        new port that splunkd should listen on
                                         
        web-port            <port>        new port that Splunk Web should listen on

      For show:

        jobs                <id>          the job id for the asynchronous search             

      Examples: 

        ./splunk set default-index mambo,rambo,kambo -role admin

        ./splunk set servername mysplunk

        ./splunk set datastore-dir /media/san
  
        ./splunk set deploy-poll -uri 10.1.1.5:8089

        ./splunk set deploy-poll 10.1.1.5:8089

        ./splunk set web-port 5654

        ./splunk show default-index 

        ./splunk show jobs 1240007498.2 

        ./splunk show minfreemb 


     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation 
 
"""

SPOOL_LONG="""
     
     Add a file to Splunk by reading the input source once. 
      
     Syntax: 
        
        spool <source> 
        
     Objects:

          NONE

     Required Parameters:

          {NULL}    no action

          source    path or file to be indexed
 
     Optional Parameters:

          NONE

     Examples:

          ./splunk spool /tmp/logs.tgz

     
     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation     




"""

STARTSTOPRESTART_LONG="""
     Start, stop, or restart your Splunk server.

     Syntax: 

        [start|stop|restart] object

     Objects: 

        splunkd     starts/stops only the Splunk daemon

        splunkweb   starts/stops only the Splunk Web interface

        NONE        (default) starts both splunkd and Splunk Web

     Parameters: 

        NONE

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation



"""

STATUS_LONG="""
 
     Show the status of Splunk's processes.

     Syntax: 

        status [object]

     Objects: 

        splunkd     shows splunkd's status and reports process ID

        splunkweb   shows Splunk Web's status and reports process ID

        NONE        (default) shows both splunkd and Splunk Web status

     Parameters: 

        NONE

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

TESTTRAIN_LONG="""
     Improve Splunk's handling of dates, source types, and fields.

     Syntax

         train     [object] [parameter <value>]

         test      [object] [parameter <value>]


    Objects:

        fields        (For train ONLY) train Splunk to learn patterns to 
                      extract fields
        dates         train Splunk to learn date patterns, test whether Splunk
                      can parse dates from a given string or file
        sourcetype    train Splunk to recognize source types from a sample file
                      test the source type of the file

    NOTE: Run "train [object]" without additional parameters to access the
    interactive CLI training and testing tool. This tool will ask you to 
    provide the required information, such as a sample file and pattern to 
    test or learn.

    Required Parameters:

        No required parameters.

    Optional Parameters:

        dates          string      double-quoted string
                       filename    text file with sample events
 
        sourcetype     filename    text file with sample events
                                   (For train ONLY) you can specify the source
                                   type that you want Splunk to recognize based 
                                   on this sample file. See Examples.

   Examples:

         ./splunk train fields

         ./splunk train dates

         ./splunk train sourcetype mylog.txt webaccess

         ./splunk test sourcetype mylog.txt


     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

VALIDATE_LONG="""
     Use validate to verify index paths specified in indexes.conf.  

     Syntax: 

        validate [object][-parameter <value>]

     Objects: 

        index      index to validate

     Required Parameters: 

        NONE

     Optional Parameters: 

        index     name       name of index to validate  
                             (If none specified, all indexes are validated)

     Examples: 

        ./splunk validate index main

     Type "help [object|topic]" to view help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation     




"""

VERSION_LONG="""
     Display Splunk's version and build number.

     Syntax: 

        version

     Objects: 

        NONE

     Parameters: 

        NONE

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation

"""


###################################################################
# Object and Parameter Definitions

AUTH_LONG="""
    The authentication parameter for all commands on a Splunk server with an 
    Enterprise license. 

    Add the parameter "-auth username:password" to authenticate in line with 
    execution of any command.  

    Note: You can't use "-auth" with the "login" command.
    
    Syntax:

       [command] [object] -auth username:password

    Objects:

        username:password      login name and password pair

    Examples:

        This example authenticates as user "admin" to change the password for 
        user "newbie":

            ./splunk edit user newbie -password f8h2.$R -auth admin:d3cidr

        This example makes the same change the longer, but less confusing way:

            login
            edit user newbie -password f8h2.$R
            logout

     Type "help [object|topic]" to view help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation    


"""

BOOTSTART_LONG="""
     
     An object used by the enable and disable commands to set Splunk to run 
     when the operating system boots.

     Syntax: 

        [enable|disable] boot-start [parameters]

     Required Parameters: 

        NONE

     Optional Parameters:

        user   specifies which user to run the script as at boot time
               (default=root)

     
     Type "help [command]" to get help with parameters for a specific command on boot-start.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation     

"""


DEPLOYCLIENT_LONG="""
     An object used to tell commands to operate on deployment clients that report to the deployment server.

     Syntax: 

      [list|refresh] deploy-clients
      [disable|enable] deploy-client

     Required Parameters: 

        NONE

     Type "help [command]" to get help with parameters for a specific command on deploy-client.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation         


"""

DEPLOYPOLL_LONG="""
     An object used to enable or set which deployment server to poll.

     Syntax:

        [set|show] deploy-poll [-uri ip:port]

     Optional Parameters:

        uri     deployment server ip:port to poll for deployment class updates
        
                Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for 
                example: 127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on IPv4 
                only. To enable IPv6 support, refer to the instructions in:
                http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6

    
      Type "help [command]" to get help with parameters for a specific command on deploy-poll.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation      
 
"""

DEPLOYSERVER_LONG="""

     An object used to control distributed deployment server capability.
     

     Syntax:

        [disable|display|enable|reload] deploy-server

     Parameters: 

        NONE


      Type "help [command]" to get help with parameters for a specific command on deploy-server.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation                

"""

DISCOVERABLE_LONG="""
     An object used to set or display broadcast availability for distributed search to 
     other Splunk servers.     

     Syntax:

        [disable|enable|display] discoverable

     Parameters: 

        NONE


      Type "help [command]" to get help with parameters for a specific command on discoverable.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation         

"""

DISTSEARCH_LONG="""
     An object used to control a Splunk server's distributed search capability.     

     Syntax:

        [disable|enable|display] dist-search

     Parameters: 

        NONE


      Type "help [command]" to get help with parameters for a specific command on dist-search.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation         


    

"""

EVENTDATA_LONG="""
     An object used to identify data of events that are indexed by Splunk.  

     Syntax: 

        [import|export|clean] eventdata -dir -index [-parameter <value>]

     Required Parameters: 

        dir          directory to export all data to

        index        what index to export data from

     Optional Parameters: 

        host         only export data from this specified host

        source       only export events from this specified source

        sourcetype   only export events from this sourcetype

        terms        only export events containing these specific terms
        
     Examples: 

        ./splunk export eventdata main -dir /tmp/myData

     
      Type "help [command]" to get help with parameters for a specific command on eventdata.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation 

"""

EXEC_LONG="""
    An object used to identify scripted inputs.

     Syntax:

        [list|add|edit|remove] exec scripted_input_source

     Objects: 

        scripted_input_source     specified scripted input source

     Parameters: 

        NONE


      Type "help [command]" to get help with parameters for a specific command on exec.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation   


"""

FORWARDSERVER_LONG="""
     An object used to specify servers or to specify the operation of a command 
     on a Splunk forwarder.

     Syntax:

        [add|remove] forward-server [-parameter <value>]...
        list forward-server

     Required Parameters: 

        hostport   in the format <host>:<port> where host and port are hostname or IP address of 
                   the indexing server and port that the indexer is listening on. 
                   
                   Note: When specifying an IP address, IPv4 and IPv6 formats are supported, 
                   for example: 127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens 
                   on IPv4 only. To enable IPv6 support, refer to the instructions in:
                   http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6
        
     Optional Parameters: 
        
        method     set forwarding method to data-cloning or load-balancing (default=clone)


      Type "help [command]" to get help with parameters for a specific command on forward-server.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation      

"""


GLOBALDATA_LONG="""

     An object used to specify global server data of your Splunk server 
     configuration (ie. tags, source type aliases, host tags, etc.).

     Syntax:

        [clean] globaldata [-f] [-parameter <value>]

     Optional Parameters: 
    
        f        forces clean to skip its confirmation prompt.

    
      Type "help [command]" to get help with parameters for a specific command on globaldata.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation      



"""

INDEX_LONG="""
     An object used to specify an index.

     Syntax: 
   
        validate index [-parameter <value>]

        [spool|monitor|tcp|udp] [path|file] source index [-parameter <value>]

        clean [object] index [-parameter <value>]


     Optional Parameters: 

        name      name of index (if none specified, all indexes are used)


      Type "help [command]" to get help with parameters for a specific command on index.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation 



"""

LICENSE_LONG="""
     An object used to show current Splunk license information.

     Syntax: 

        [add|list|remove] licenses
 
     Parameters: 

        NONE

      Type "help [command]" to get help with parameters for a specific command on license.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation      

 
"""

LISTEN_LONG="""
     An object used to set the port to receive data from other Splunk servers
     (listen on a port).

     Syntax:

        [enable|disable] listen [-parameter <value> | <value>]
        [display] listen

     Required Parameters: 

        port     TCP port to listen on


      Type "help [command]" to get help with parameters for a specific command on listen.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation      


"""

LOCALINDEX_LONG="""
     An object used to specify the local Splunk index. 

     Note: Disabling local indexing only affects Splunk forwarders. 

     Syntax:

        [enable|disable|display] local-index [-parameter <value>]

     Parameters:

        NONE


      Type "help [command]" to get help with parameters for a specific command on local-index.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation   
  

"""


PORT_LONG="""
     A parameter used to specify a network port to perform an action on.  
     Also used as a parameter for other objects such as search-server. 

     Syntax:

        [command] search-server server port port#

        [command] [udp|tcp] port#


     Objects: 

        server    server hostname or IP address.  
        
                  Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for 
                  example: 127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on 
                  IPv4 only. To enable IPv6 support, refer to the instructions in:
                  http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6 

        port#     specified port number (ie 8801)

 
      Type "help [command]" to get help with parameters for a specific command on port.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation         


"""


SEARCHSERVER_LONG="""
    An object used to specify servers to add/remove/list, or operate a 
    command on that the current server distributes to.

    Syntax:

        [add|remove|edit|list] search-server [-parameter <value>]

    Required Parameters: 
    
     Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for example: 
     127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on IPv4 only. To enable IPv6 
     support, refer to the instructions in:
     http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6

     For add and edit:
     
        <host>:<port>    supply the hostname or IP address and splunkd port of the remote server
                              
        remoteUsername   username to access the remote server
        
        remotePassword   password to access the remote server
        
     For remove:
     
        url              host name or IP address of the search server to stop peering with

    Optional Parameters: 

       NONE


    Examples:

          ./splunk add search-server hulk:5555 -remoteUsername user1 -remotePassword passwd1

 
    Type "help [command]" to get help with parameters for a specific command on search-server.  

    Complete documentation is available online at: http://docs.splunk.com/Documentation      



"""

SPOOL_LONG="""
    Use "spool" to index a file once and forget about it.

    Use "add monitor" to index files and directories containing both live 
    and closed files.

    Syntax: 

        spool pathname [-parameter <value>] ...

    Objects:

        NONE 

    Required Parameter:

        pathname    path to a file or directory to be unpacked, uncompressed and indexed

    Optional Parameters:
 
        source      source value to set on events from the file or directory
        
        sourcetype  source type value to set on events
        
        index       Splunk index into which to place events
        
        hostname    hostname to set as the host value for example, web01.mycorp.com
        
        auth        username:password to authenticate the command to Splunk

    Examples:

        ./splunk spool /var/log/messages.1
        
        ./splunk spool /mnt/old/logs -hostname web01 -auth gwb:d3cidr

     Type "help [object|topic]" to get help on a specific object, or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation  


"""

TAIL_LONG="""
    An object used to specify log files and directories to actively index.

    Use no more than one of -hostname, -hostregex or -hostsegmentnum per 
    command.

    Use "spool" to index a file once and forget about it.
    Use "add monitor" to index files and directories containing both live 
    and closed files.


   Syntax:

        [add|edit] monitor source [-parameter <value>] ...
 
        remove monitor source 
 
        list monitor

    Required Parameter:

        source            path to a file or directory whose contents should be
                          indexed by the Splunk server, and then watched for 
                          new input. The Splunk server unpacks tarfiles and 
                          compressed files.

    Optional Parameters:

        sourcetype         source type value to set for events from the source

        index              Splunk index to place events from the source

        hostname           host name to set as the host value

        hostregex          regular expression of file path to set as the host value

        hostsegmentnum     number of segments in the file path to set as the host value

        follow-only        only read from the end of the file. (True|False, default=False) 


    Examples:

        ./splunk add monitor /var/log/


      Type "help [command]" to get help with parameters for a specific command on monitor.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation  



"""

TCPUDP_LONG="""
    Objects used to specify TCP or UDP network inputs.

    Syntax:

        add [tcp|udp] source [-parameter <value>] ...
        edit [tcp|udp] source [-parameter <value>] ... 
        remove [tcp|udp] source 
        list [tcp|udp]

    Required Parameter:


        source         the TCP or UDP network port that the Splunk Server should 
                       listen on

   
    Optional Parameters:

        sourcetype     source type value to set for events from the source
        index          where to index events from the source
        hostname       host name to set as the host value
        resolvehost    use DNS to set the host value (True|False, 
                       default=False)

    Examples:

        ./splunk add udp 514 -sourcetype syslog
        
        ./splunk edit udp 514 -resolvehost true -auth gwb:d3cidr


     Type "help [command]" to get help with parameters for a specific command on tcp or udp.  

    Complete documentation is available online at: http://docs.splunk.com/Documentation  



"""

URI_LONG="""
     
     A parameter used to instruct Splunk to send a command to a specified 
     Splunk server.

     Note: Make sure you have a working connection with the Splunk server 
     you want to send the command to. If you are not properly connected, Splunk
     will generate an error when executing a command with uri.


     Syntax:

        [command] [object] [-parameter <value>]...-uri [required parameter]

     Objects: 

        specified server     [http|https]://[name of server|ip]:[port]
        
        Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for example: 
        127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on IPv4 only. To enable 
        IPv6 support, refer to the instructions in:
        http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6 

  
     Type "help [object|topic]" to get help on a specific object, or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation     
     

"""

USERDATA_LONG="""
     An object used to specify user account data for your Splunk server.

     Syntax:

        clean userdata [-parameter <value>]

        [import|export] userdata [-parameter <value>]...

     Required Parameters: 

        NONE

  
      Type "help [command]" to get help with parameters for a specific command on userdata.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation      



"""

USER_LONG="""
    An object used to specify a username for user account management.

    Syntax: 

        add user <username> [-parameter <value>] ...
        edit user <username> [-parameter <value>]  ...
        remove user <username>
        list user 

    Required Parameters:

    add/edit both require:
        username     the name of the Splunk user account to manage
        role         Admin, Power, or User

    add also requires:
        password     password of the account

    Optional Parameter:

        full-name    Real name of user in quotes (Example: "Nikola Tesla")

    Examples:

        ./splunk add user noobie -password "changeme" -full-name 'New User' -role User
        ./splunk edit user noobie -role Admin

  
      Type "help [command]" to get help with parameters for a specific command on user.  

     Complete documentation is available online at: http://docs.splunk.com/Documentation  

"""


WATCH_LONG="""

    Works exactly like monitor.  See help monitor for more details.

"""

###################################################################
# Meta-definitions 

HELP_DEFAULT_LONG="""
    
  Welcome to Splunk's Command Line Interface (CLI).  

  Type these commands for more help:
 
    help simple, cheatsheet    display a list of common commands with syntax
    help commands              display a full list of CLI commands
    help [command]             type a command name to access its help page
    help control, controls     tools to start, stop, manage Splunk processes
    help [object]              type an object name to access its help page
    help [topic]               type a topic keyword to get help on a topic
    help datastore             manage Splunk's local filesystem use
    help distributed           manage distributed configurations such as
                               data cloning, routing, and distributed search
    help forwarding            manage deployments
    help input, inputs         manage data inputs
    help licensing             manage licenses for your Splunk server
    help settings              manage settings for your Splunk server
    help tools                 tools to help your Splunk server      
    help search                help with Splunk searches 

  Universal Parameters:

    The following parameters are usable by any command. For more details on each 
    parameter, type "help [parameter]".

    Parameter syntax: 
      
      [command] [object] [-parameter <value> | <value>]... [-uri][-auth]

      app        specify the app or namespace to run the command; for search, defaults to 
                 the Search app
                 
      auth       specify login credentials to execute commands that require you to be logged in
      
      owner      specify the owner/user context associated with an object; if not specified, 
                 defaults to the currently logged in user
                 
      uri        execute a command on any specified Splunk server. Use the
                 format: <ip>:<port> 
                 
      Note: When specifying an IP address, IPv4 and IPv6 formats are supported, for example: 
      127.0.0.1:80 or "[2001:db8::1]:80". By default, splunkd listens on IPv4 only. To enable 
      IPv6 support, refer to the instructions in:
      http://docs.splunk.com/Documentation/Splunk/latest/Admin/ConfigureSplunkforIPv6

      
     Type "help [object|topic]" to get help on a specific object or topic.

     Complete documentation is available online at: http://docs.splunk.com/Documentation         

"""

CHEATSHEETSIMPLE_LONG="""
This page will get you started with some basic commands, examples of usage,
and a list of help commands for reference on Splunk search.

 Splunk CLI command syntax: 

      ./splunk [command] [object] [-parameter <value>]...

 Syntax notation: 
        * Plain text: indicate required arguments
        * [Text in brackets]: indicate optional arguments
        * Parameters always have a "-" with no space 
          (Example: "-parameter" NOT "- parameter")
        * ... indicates that you can add multiple arguments
  
 Basic Splunk CLI commands:

        search                         search a Splunk index
        login,logout                   authenticate a session to a 
                                       Splunk server
        start,stop,restart,status      manage Splunk processes
        spool                          load a file or directory into an index
        add,edit,remove,list           manage data inputs, user accounts, 
                                       saved searches 
        set,show                       manage Splunk settings
        enable,disable                 turn features on and off
        help                           show the main help page
        refresh                        update a deployment server with 
                                       client server information
        reload                         reload deployment servers 
        
    Examples of typical commands:

        ./splunk search "session root daysago=1"
        ./splunk add monitor /var/applog -sourcetype myApp
        ./splunk remove monitor /var/log
        ./splunk list monitor
        ./splunk spool /my/random/logs.tgz -sourcetype linux_messages_syslog
        ./splunk add udp 514
        ./splunk edit udp 514 &mdash;sourcetype asterisk_event_syslog
        ./splunk add forward 10.1.1.123:8089
        ./splunk enable boot-start
        ./splunk add search-server splunk03
        ./splunk help commands

    Splunk search cheatsheets: 

        help search             search syntax reference
        help search-modifiers   complete list of modifiers and usage examples
        help search-fields      complete list of fields indexed by Splunk
        help search-commands    complete list of search commands


     Type "help [object|topic]" to get help on a specific object or topic. 

     Complete documentation is available online at: http://docs.splunk.com/Documentation    


"""

COMMANDS_LONG="""

  This page shows you the syntax and summary of the Splunk CLI commands.

  Splunk CLI command syntax: 

    ./splunk [command] [object] [-parameter <value>]...

    * Some commands don't require an object or parameters.
    * Some commands have a default parameter that can be specified by its 
      value alone.

  Commands and objects:

    * A command is an action that you can perform.
    * An object is something you perform an action on. 

  Supported commands and objects:

    [command]             [objects]

    add                   [exec|forward-server|index|licenser-pools|licenses|
                          monitor|oneshot|saved-search|search-server|tcp|udp|user]

    anonymize             source

    clean                 [eventdata|globaldata|userdata|all]

    create                app
 
    disable               [app|deploy-client|deploy-server|discoverable|
                          dist-search|index|listen|local-index|boot-start|
                          webserver|web-ssl]

    edit                  [app|exec|forward-server|index|licenser-localslave|licenses|
                          licenser-gropups|
                          monitor|saved-search|search-server|tcp|udp|user]

    enable                [app|deploy-client|deploy-server|discoverable|
                          dist-search|index|listen|local-index|boot-start|
                          webserver|web-ssl]

    display               [app|deploy-server|discoverable|dist-search|index|
                          jobs|listen|local-index|boot-start|webserver|web-ssl]

    export,import         [eventdata|userdata]

    find                  logs 

    help                  NONE

    list                  [deploy-clients|exec|forward-server|index|licenser-groups|
                          licenser-localslave|licenser-messages|licenser-pools|
                          licenser-slaves|licenser-stacks|licenses|jobs|monitor|
                          saved-search|search-server|source|sourcetype|tcp|udp|user]

    login,logout          NONE

    package               app
 
    refresh               deploy-clients
 
    reload                [auth|deploy-server]

    remove                [app|exec|forward-server|jobs|licenser-pools|licenses|
                          monitor|saved-search|search-server|source|sourcetype|tcp|udp|user]

    search                NONE

    set                   [datastore-dir|deploy-poll|default-hostname|default-index|
                          minfreemb|servername|splunkd-port|web-port]

    show                  [config|datastore-dir|deploy-poll|default-hostname|
                          default-index|jobs|minfreemb|servername|
                          splunkd-port|web-port]
 
    spool                 NONE

    start,stop,restart    [monitor|splunkd|splunkweb]

    status                [monitor|splunkd|splunkweb]


   Type "help [object|topic]" to get help on a specific object, or topic. 

   Complete documentation is available online at: http://docs.splunk.com/Documentation   


"""
 

CONTROL_LONG="""

  Start and stop Splunk server processes, or show process status. 

  Commands

    start [splunkd|splunkweb]

    stop [splunkd|splunkweb]

    restart [splunkd|splunkweb]

    status

  Objects

     splunkd      The Splunk server daemon
     splunkweb    Splunk's Web interface process

  Required Parameters

     NONE

  Examples

      ./splunk start splunkd
      ./splunk restart splunkweb -auth gwb:d3cidr
      ./splunk status

  Type "help [object|topic]" to get help on a specific object, or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

DATASTORE_LONG="""
 
 Manage indexes and user or global data that is stored on the server. 

 Commands:

    add index [-name <name> | <name>] [-dir <value>] ...

    edit index [-name <name> | <name>] [-dir <value>] ...

    list index

    export [eventdata|userdata] 

    import [eventdata|userdata] 

    clean  [all|eventdata|globaldata|userdata] [-f] [-index <name>]

  Objects:

    all           everything on the server
    eventdata     indexed events and fields for each event
    globaldata    host tags, source type aliases, server tag data 
    userdata      user account information
  
  Parameters:

    For add and edit index ONLY

    dir       <value>   specify a directory to add your index
    name      <value>   name of the index

    For clean ONLY

    f                   forces skip confirmation prompt 
    index     <name>    name of the index


  Type "help [object|topic]" to get help on a specific object, or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation


"""


DISTRIBUTED_SEARCH_LONG=""" 
  
  Distributed search, cloning, and deployment configuration management tools.

  Commands:

    disable [discoverable|listen|dist-search|local-index|deploy-client|
            deploy-server] [-parameter <value>] ...

    enable  [discoverable|listen|dist-search|local-index|deploy-client|
            deploy-server] [-parameter <value>] ...

    display [discoverable|listen|dist-search|local-index|deploy-server]

    add [forward-server|search-server] server

    remove [forward-server|search-server] server

    list [deployt-clients|forward-server|search-server]

    reload  deploy-server

    refresh deploy-clients

    set [deploy-poll]

    show [deploy-poll]

  Objects:

    discoverable         broadcast availability for Distributed Search from other 
                         Splunk servers
    dist-search          distribute searches to other Splunk servers
    listen               reception of data to be indexed from other Splunk servers
    forward-server       a Splunk server to which to forward data to be indexed
    search-server        a Splunk server to which to forward searches
    local-index          maintain a search index on this Splunk server 
    deploy-client        a deployment client
    deploy-clients       deployment clients 
    deploy-server        a deployment server  
    deploy-poll          enables deployment client and sets which deployment server 
                         to poll

  Parameters:
 
    For a complete list of parameters, type "./splunk help [command|object]". 
  

  Type "help [object|topic]" to get help on a specific object, or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

FILE_LONG="""

  To tell Splunk to index a file or directory, use one of these actions:

     spool [pathname]         read a file or directory one time

     add monitor [pathname]   continuously monitor a file or directory 
                              for new live data and files

  Type "help [object|topic]" to get help on a specific object, or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

FORWARDING_LONG="""

  Data forwarding configuration management tools.
    
  Commands:

    enable local-index [-parameter <value>] ...

    disable local-index [-parameter <value>] ...

    display local-index

    add [forward-server|search-server] server

    remove [forward-server|search-server] server

    list [forward-server|search-server]


  Objects:

    forward-server       a Splunk forwarder to forward data to be indexed
    search-server        a Splunk server to forward searches
    local-index          a local search index on the Splunk server
 
  Parameters:
 
    For a complete list of parameters, type "./splunk help [command|object]". 
  

  Type "help [object|topic]" to get help on a specific object, or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

INPUT_LONG="""

  Data input configuration options.

  Actions:

    add [exec|monitor|tcp|udp] [source] [-parameter <value>] ...

    edit [exec|monitor|tcp|udp] [source] [-parameter <value>] ...

    remove [monitor|tcp|udp] [source]

    list [monitor|tcp|udp] 

  Objects:

    exec       a scripted input
    fifo       (no longer supported)   
    monitor    a file or directory to be continuously monitored for new input
    tcp        a TCP socket
    udp        a UDP socket
 
  Default Parameter:

    source    file, directory, scripted input, or socket to manage

  Optional Parameters:
 
    For a complete list of parameters, type "./splunk help [command|object]".  


  Type "help [object|topic]" to view help on a specific object or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation  


"""

SAVEDSEARCH_LONG="""

  Configuration options for saved searches and alerts. Alerts are controlled by the 
  saved-search object of the add and remove commands. Alerts can be scheduled to be 
  run at a specified time, or can be set to trigger when a certain threshold is reached.

  Syntax:

    add saved-search [-parameter <value>]

    edit saved-search [-parameter <value>]

    list saved-search 

    remove saved-search

  Required Parameters:

    name           (default) name of saved search to create

    terms          search terms to be associated with this saved search

  Optional Parameters:

    alert           make the search an alert (true|false, default=false)
                    IF alert=true, "schedule" and "threshold" are required, and
                    "email", "attach" or "script" options are required.

    end_time        the latest time for the search

    fields          a list of key-value pairs to annotate the events inserted into 
                    the summary index. format pairs as key:value and separate multiple 
                    entries with a semicolon

    summary_index   the name of the summary index where to add the results of the
                    scheduled search

    start_time      the earliest time for the search

    ttl             time-to-live (in seconds) for the artifacts of the scheduled search


    (IF optional parameter "alert" is set to true, then the following is REQUIRED)

    schedule        specify when the alert is run using full cron format


    (IF optional parameter "alert" is set to true, then AT LEAST ONE of the following 
    is REQUIRED)

    email           comma-separated list of email addresses to send alerts to (true|false)
                    default=false

    attach          specify inclusion of search results in emails (true|false) default=false

    script          script to execute upon alert (ex: $SPLUNK_HOME/bin/myScript)

    threshold       the threshold to trigger the alert action 
                    [<threshold type>:<relation>:<quantity>]
                    <threshold type>= num-events,num-sources,num-hosts
                    <quantity>= any integer


  Complete documentation is available online at: http://docs.splunk.com/Documentation


"""

SEARCHFIELDS_LONG="""

  Fields contain data that is identified in key/value pairs at index time. Splunk indexes
  time, host, source, and sourcetype data automatically. Fields can be used for searching, 
  to refine the scope of an existing search, or for reporting purposes. Some fields let 
  you use wildcards, regular expressions, and comparison operations to specify values to
  match. Custom fields can also be created. See the online documentation for a complete
  reference of custom and default fields.


     _raw            the original raw data of an event
     _time           an event's timestamp in Unix Time
     date_hour       the hour that an event occurred in
     date_mday       the day of the month an event occurred on
     date_minute     the minute that an event occurred in
     date_month      the month that an event occurred in
     date_second     the seconds portion of an event's timestamp
     date_wday       the day of the week that an event occurred on 
     date_year       the year that an event occurred in 
     date_zone       the time of the local timezone of an event in Unix Time
     eventtype       event type names that an event matches
     host            the name of the host that the event originated from 
     index           the name of the index where an event is located
     linecount       the number of lines and event contains
     punct           the punctuation pattern extracted from an event 
     source          the name or path of the source where an event is from
     sourcetype      the name of an event's sourcetype 
     splunk-server   the name of the splunk-server
     timestamp       an event's timestamp extracted at index time


  Complete documentation is available online at: http://docs.splunk.com/Documentation


"""

SEARCHMODIFIERS_LONG="""

  Use modifiers to narrow your searches within the "search" (or "dispatch") command. 
  You can narrow(modify) your searches by constraining the time range (using time-based
  modifiers), or by specifying field tags, or a saved search to match. Some modifiers 
  let you use wildcards, regular expressions, and comparison operations to specify values 
  to match.  See the online documentation for a complete reference of the search modifiers.


  Search modifiers:
     savedsearch             returns the search results of a saved search
     tag                     returns events with matching field values


  Time-based modifiers:  
     daysago                 events within the last N days
     enddaysago              events are before the specified number of days ago
     endhoursago             events are before the specified number of hours ago 
     endminutesago           events are before the specified number of minutes ago
     endmonthsago            events are before the specified number of months ago
     endtime                 events are before the specified time
     hoursago                events within the last N hours
     minutesago              events within the last N minutes
     monthsago               events within the last N months
     searchtimespandays      events within a specified range of days 
     searchtimespanhours     events within a specified range of hours   
     searchtimespanminutes   events within a specified range of minutes
     searchtimespanmonths    events within a specified range of months
     startdaysago            events after the specified number of days ago
     starthoursago           events after the specified number of hours ago
     startminutesago         events after the specified number of minutes ago
     startmonthsago          events after the specified number of months ago
     starttime               events after the specified timestamp
     starttimeeu             events after the specified European format timestamp
     timeformat              change the format of the timestamp


  Complete documentation is available online at: http://docs.splunk.com/Documentation

"""

SEARCHCOMMANDS_LONG="""

  All Splunk Search commands can be piped together to form a more complex search string.
  Data-generating commands generate data. Data-processing commands require results from
  data-generating commands to perform their processing operations.

  For a complete reference on Splunk search, search syntax, and all of the search commands
  see our online user documentation at: http://docs.splunk.com/Documentation/

  Search commands available to use in the Splunk CLI: 

    abstract       Produce an abstract (summary) of each search result
    addinfo        Add general information about the current search to your search results
    addtotals      Compute the sum of all numeric fields for each result
    admin          Return the values of a specified .conf file
    anomalousvalue Find and summarize uncommon search results
    associate      Identify relationships between pairs of fields
    audit          View information about events that have been cryptographically signed
    bucket         Put continuous numerical field values into discrete sets
    cluster        Cluster  events together based on their similarity
    collect        Place search results into a summary index
    contingency    Build a contingency table for two fields
    convert        Change the format of field values to numerical quantities
    correlate      Calculate the correlation between different fields
    crawl          Generate a list of sources you can possibly index
    dedup          Remove duplicate events matching a specified criteria
    diff           Compare two search results and return a single search result
    eval           Perform an SQLite expression evaluation on results
    eventstats     Generate summary statistics of all fields and append them to your search
                   results
    excerpt        See "abstract"
    extract        Extract key-value pairs from search results
    fields         Remove fields from search results
    file           Generate events from a file in the local filesystem
    fillnull       Replace null field values with a specified value
    format         Format the results of a subsearch into a single result
    head           Return the first occurring N search results
    highlight      Highlight any string of text in your search results by specifying strings
                   in a list
    kmeans         Perform k-means clustering on selected fields
    kv             See "extract"
    localize       Return a list of time ranges that results were found in
    makemv         Change a specified field into a multi-value field
    mvcombine      Combine events into a single event with differing field values in a multi-
                   value field
    mvexpand       Expand multi-value field values into separate events for each value
    multikv        Extract fields from events with information in a tabular format
    nomv           Change a multi-value field into a single-value field at search time
    overlap        Find overlaps or gaps in events in a summary index
    outlier        Remove or truncate outlying values in selected fields
    rare           Display the least common values of a field
    regex          Remove results that do not match a regular expression
    rename         Rename one or more fields
    replace        Replace values of specified fields with a specified new value
    reverse        Reverse the display order of the entire result set
    rex            Use Perl regular expression grouping to extract fields while you search 
    run            Run an external perl or python program to modify search results
    savedsearch    Return the search results of a saved search
    search         Perform a search by retrieving results from the Splunk index
    set            Perform set operations on subsearches
    sort           Perform sort operations on subsearches
    stats          Perform stats operations on subsearches
    strcat         Combine any number of strings and fields together from your search results
    tail           Return the last occurring N search results
    transaction    Find transactions based on various constraints
    typelearner    Generate a list of queries based on search results to use as event types
    typer          Calculate the eventtype field for search results that match a known event
                   type
    top            Display the most common values of a field
    where          Run an SQLite statement against the search results
    xmlkv          Find and extract XML key-value pairs
    xmlunescape    Un-escape XML entity references (for: &, >, and <) in your search results
      

  Complete documentation is available online at: http://docs.splunk.com/Documentation  


"""

TOOLS_LONG="""

  Useful commands to help your Splunk server.  These commands don't require Splunk to be 
  running, and don't reconfigure any of your Splunk settings.

  Syntax: 

   anonymize source [-parameter <value>]...

   find logs searchpath

   validate object [-parameter <value>]

       
  Objects:

    logs           logs that find will identify and find in the specified searchpaths
    source         the source that anonymize will perform action on
    
    For validate ONLY:

    index          index to check for correctness

  Optional Parameters:
 
     For a complete list of parameters, type "./splunk help [command|object]". 


  Type "help [object|topic]" to get help on a specific object, or topic. 

  Complete documentation is available online at: http://docs.splunk.com/Documentation  


"""

EXTRACT_I18N_LONG="""

  Extract translatable strings from an application, ready to be translated with a 
  gettext compatible editor.

  Creates or replaces locale/messages.pot in the application's directory.

  Syntax:
       
    extract i18n -app <application name>

  Documentation on creating i18n compliant applications is available online at
  http://docs.splunk.com/Documentation

"""


###################################################################
# Deprecated search command info

REMOTE_LONG= """
     The remote command has been deprecated in versions 3.2 and later. Instead of using remote, 
     use the "dispatch" CLI command to execute searches across remote machines.  

     Type "help [object|topic]" to view help on a specific object or topic.

"""

FIFO_LONG="""
     The object 'fifo' is no longer supported.
 
     Type "help [command|object|topic]" to view help for a specific command, object, or topic. 

"""

DEPLOYMULTICAST_LONG="""
     The object 'deploy-multicast' is no longer supported. 

     Type "help [object|topic]" to view help on a specific object or topic. 

"""

BLACKLIST_LONG="""
     The object 'blacklist' is no longer supported.
 
     Type "help [command|object|topic]" to view help for a specific command, object, or topic.     

"""

###################################################################

########################### end help declarations ####################### 


###################################################################
######################   Begin Help calls ###############################
#
# format is addHelp("command name", "short help string", """long help string""")
# 

# command help strings

# ADDEDIT_LONG
addHelp("add","", ADDEDIT_LONG)
addHelp("edit","",ADDEDIT_LONG)

# ANONYMIZE_LONG
addHelp("anonymize","",ANONYMIZE_LONG)

# CLEAN_LONG
addHelp("clean","",CLEAN_LONG)

# DISABLEENABLE_LONG
addHelp("disable","",DISABLEENABLE_LONG) 
addHelp("enable","",DISABLEENABLE_LONG)
addHelp("display","",DISABLEENABLE_LONG)

# DISPATCH_LONG
addHelp("dispatch","",DISPATCH_LONG)

# DISPLAY_LONG
addHelp("display","",DISPLAY_LONG)

# EXPORTIMPORT_LONG
addHelp("export","",EXPORTIMPORT_LONG)
addHelp("import","",EXPORTIMPORT_LONG)

# FIND_LONG
addHelp("find","",FIND_LONG)
addHelp("logs","",FIND_LONG)

# HELP_LONG  aka default help string HELP_DEFAULT_LONG

# LIST_LONG
addHelp("list","",LIST_LONG)

# LOGINLOGOUT_LONG
addHelp("login","",LOGINLOGOUT_LONG)
addHelp("logout","",LOGINLOGOUT_LONG)

# REFRESH
addHelp("refresh","",REFRESH)

# RELOAD_LONG
addHelp("reload","",RELOAD_LONG)

# REMOVE_LONG
addHelp("remove","",REMOVE_LONG)

# RTSEARCH_LONG
addHelp("rtsearch","",RTSEARCH_LONG)
addHelp("realtime","",RTSEARCH_LONG)
addHelp("real-time","",RTSEARCH_LONG)
addHelp("livetail","",RTSEARCH_LONG)
addHelp("live-tail","",RTSEARCH_LONG) 

# SEARCH_LONG
# search meta-definition
addHelp("search","",SEARCH_LONG)
addHelp("searches","",SEARCH_LONG)
addHelp("searching","",SEARCH_LONG)
addHelp("search-help","",SEARCH_LONG)

# SETSHOW_LONG
addHelp("set","",SETSHOW_LONG)
addHelp("show","",SETSHOW_LONG)
addHelp("settings","",SETSHOW_LONG)
addHelp("setting","",SETSHOW_LONG)

# SPOOL_LONG
addHelp("spool","",SPOOL_LONG)

# CONTROL_LONG  aka start stop restart
addHelp("start","",CONTROL_LONG)
addHelp("stop","",CONTROL_LONG)
addHelp("restart","",CONTROL_LONG)
addHelp("control","",CONTROL_LONG)
addHelp("controls","",CONTROL_LONG)
addHelp("splunkd","", CONTROL_LONG)
addHelp("splunkweb","", CONTROL_LONG)

# STATUS_LONG
addHelp("status","",STATUS_LONG)
addHelp("server-status","",STATUS_LONG)

# TESTTRAIN_LONG
# addHelp("test","",TESTTRAIN_LONG)
# addHelp("train","",TESTTRAIN_LONG)
# addHelp("training","",TESTTRAIN_LONG)

# VALIDATE_LONG
addHelp("validate","",VALIDATE_LONG)

# VERSION_LONG
addHelp("version","",VERSION_LONG)
addHelp("splunk-version","",VERSION_LONG)


# object and parameter strings

# AUTH_LONG
addHelp("auth","", AUTH_LONG)
addHelp("login","", AUTH_LONG)

# BLACKLIST_LONG
addHelp("blacklist","",BLACKLIST_LONG)

# BOOTSTART_LONG
addHelp("boot-start","",BOOTSTART_LONG)

# DEPLOYCLIENT_LONG
addHelp("deploy-client","",DEPLOYCLIENT_LONG)
addHelp("deploy-clients","",DEPLOYCLIENT_LONG)
addHelp("client","",DEPLOYCLIENT_LONG)

# DEPLOYMULTICAST_LONG
addHelp("deploy-multicast","",DEPLOYMULTICAST_LONG)
addHelp("deploymulticast","",DEPLOYMULTICAST_LONG)
addHelp("multicast","",DEPLOYMULTICAST_LONG)

# DEPLOYPOLL_LONG
addHelp("deploy-poll","",DEPLOYPOLL_LONG)
addHelp("deploypoll","",DEPLOYPOLL_LONG)
addHelp("poll","",DEPLOYPOLL_LONG)

# DEPLOYSERVER_LONG
addHelp("deploy-server","",DEPLOYSERVER_LONG)
addHelp("deployserver","",DEPLOYSERVER_LONG)
addHelp("server","",DEPLOYSERVER_LONG)

# DISCOVERABLE_LONG
addHelp("discoverable","",DISCOVERABLE_LONG)

# DISTSEARCH_LONG
addHelp("dist-search","",DISTSEARCH_LONG)

# EVENTDATA_LONG
addHelp("eventdata","",EVENTDATA_LONG)
addHelp("event","",EVENTDATA_LONG)

# EXEC_LONG
addHelp("exec","",EXEC_LONG)
addHelp("scripted","",EXEC_LONG)

# FIFO_LONG
addHelp("fifo","",FIFO_LONG)

# FORWARDSERVER_LONG
addHelp("forward-server","",FORWARDSERVER_LONG)
addHelp("forwardserver","",FORWARDSERVER_LONG)

# GLOBALDATA_LONG
addHelp("globaldata","",GLOBALDATA_LONG)
addHelp("global","",GLOBALDATA_LONG)

# INDEX_LONG
addHelp("index","",INDEX_LONG)

# LICENSE_LONG
addHelp("license","",LICENSE_LONG)

# LISTEN_LONG
addHelp("listen","",LISTEN_LONG)

# LOCALINDEX_LONG
addHelp("local","",LOCALINDEX_LONG)
addHelp("local-index","",LOCALINDEX_LONG)

# PORT_LONG
addHelp("port","",PORT_LONG)
addHelp("ports","",PORT_LONG)

# SAVEDSEARCH_LONG
addHelp("alert","",SAVEDSEARCH_LONG)
addHelp("alerts","",SAVEDSEARCH_LONG)
addHelp("savedsearch","",SAVEDSEARCH_LONG)
addHelp("saved-search","",SAVEDSEARCH_LONG)

# SEARCHSERVER_LONG
addHelp("searchserver","",SEARCHSERVER_LONG)
addHelp("search-server","",SEARCHSERVER_LONG)

# SPOOL_LONG
addHelp("spool","",SPOOL_LONG)

# TAIL_LONG
addHelp("tail","",TAIL_LONG)
addHelp("monitor","",TAIL_LONG)

# TCPUDP_LONG
addHelp("tcp","",TCPUDP_LONG)
addHelp("udp","",TCPUDP_LONG)

# URI_LONG
addHelp("uri","",URI_LONG)


# USERDATA_LONG
addHelp("userdata","",USERDATA_LONG)

# USER_LONG
addHelp("user","",USER_LONG)
addHelp("username","",USER_LONG)
addHelp("users","",USER_LONG)

# WATCH_LONG
addHelp("watch","",WATCH_LONG)


# meta-definitions

# HELP_DEFAULT_LONG     aka DEFAULT HELP PAGE
addHelp("help","",HELP_DEFAULT_LONG)
addHelp("splunk","",HELP_DEFAULT_LONG)
addHelp("parameters","",HELP_DEFAULT_LONG)
addHelp("parameter","",HELP_DEFAULT_LONG)
addHelp("","",HELP_DEFAULT_LONG)


# CHEATSHEETSIMPLE_LONG
addHelp("cheatsheet","",CHEATSHEETSIMPLE_LONG)
addHelp("simple", "", CHEATSHEETSIMPLE_LONG)

# COMMANDS_LONG
addHelp("command","",COMMANDS_LONG)
addHelp("commands","",COMMANDS_LONG)
addHelp("cmd","",COMMANDS_LONG)

# DATASTORE_LONG
addHelp("data","",DATASTORE_LONG)
addHelp("datastore","",DATASTORE_LONG)
addHelp("store","",DATASTORE_LONG)

# DISTRIBUTED_SEARCH_LONG
addHelp("distributed","",DISTRIBUTED_SEARCH_LONG)
addHelp("distributed-search","",DISTRIBUTED_SEARCH_LONG)
addHelp("cloning","", DISTRIBUTED_SEARCH_LONG)
addHelp("routing","", DISTRIBUTED_SEARCH_LONG)
addHelp("deployments","", DISTRIBUTED_SEARCH_LONG)
addHelp("deployment","",DISTRIBUTED_SEARCH_LONG)

# FILE_LONG
addHelp("file","",FILE_LONG)
addHelp("add files","",FILE_LONG)
addHelp("dir","",FILE_LONG)
addHelp("directory","",FILE_LONG)
addHelp("path","",FILE_LONG)
addHelp("pathname","",FILE_LONG)

# FORWARDING_LONG
addHelp("forwarding","", DISTRIBUTED_SEARCH_LONG)

# INPUT_LONG
addHelp("input","",INPUT_LONG)
addHelp("inputs","",INPUT_LONG)

# SEARCHFIELDS_LONG
addHelp("fields","",SEARCHFIELDS_LONG)
addHelp("search fields","",SEARCHFIELDS_LONG)
addHelp("search-fields","",SEARCHFIELDS_LONG)
addHelp("search-field","",SEARCHFIELDS_LONG)

# SEARCHMODIFIERS_LONG
addHelp("modifiers","",SEARCHMODIFIERS_LONG)
addHelp("modifier","",SEARCHMODIFIERS_LONG)
addHelp("search modifiers","",SEARCHMODIFIERS_LONG)
addHelp("search modifier","",SEARCHMODIFIERS_LONG)
addHelp("search-modifier","",SEARCHMODIFIERS_LONG)
addHelp("search-modifiers","",SEARCHMODIFIERS_LONG)

# SEARCHCOMMANDS_LONG
addHelp("search-commands","",SEARCHCOMMANDS_LONG)
addHelp("search commands","",SEARCHCOMMANDS_LONG)
addHelp("search command","",SEARCHCOMMANDS_LONG)
addHelp("operators","",SEARCHCOMMANDS_LONG)
addHelp("search-operators","",SEARCHCOMMANDS_LONG)


# TOOLS_LONG
addHelp("tools", "",TOOLS_LONG)

# I18N TEXT EXTRACTION
addHelp('extract', '', EXTRACT_I18N_LONG)


########################### end help calls ############################ 

def helpShort(cmd):
	return helpStrs[cmd]["helpShort"]

def helpLong(cmd):
	return helpStrs[cmd]["helpLong"]

def hasHelp(cmd):
	return cmd in helpStrs

