################################################################################
# How to run this test:
# - Make sure splunkd is NOT running
# - Make sure splunk env is set (source $SPLUNK_HOME/bin/setSplunkEnv)
# - $SPLUNK_HOME should be pointing to a 4.X instance
# - python migration_test.py <path to some 3.X etc> <expected result>
#
# DETAILS:
# The test will do the following:
#       - move original 4.X etc to $SPLUNK_HOME/etc.original_backup
#       - overwrite $SPLUNK_HOME/etc with <path to some 3.X etc> argument
#       - overlay original etc over the 3.X etc
#       - run the migration
#       - perform diff between results $SPLUNK_HOME/etc and <expected result>
#       - save off resulting etc to $SPLUNK_HOME/etc.migration_result
#       - restore original 4.X etc (from etc.orginal_backup)
################################################################################

import os
import sys
import shutil
import filecmp
import splunk.clilib.cli_common as comm
import splunk.clilib.bundle_paths as bundle_paths
import splunk.clilib.migration as migr


BACKUP_EXT=".original_backup"
MIGRATION_RESULT_EXT=".migration_result"

#
# just uses $SPLUNK_HOME/etc for now
#
def splunk_etc():
        return bundle_paths.etc()

def my_move(src, dst):
        shutil.move( src, dst )
        print "successful in moving" + src + " to " + dst
        return True
    
def my_copytree(src, dst):
        if not os.path.exists( src ):
                print "copytree fail: cannot locate src:",src,"dst=",dst
                return False
        if not os.path.exists( dst ):
                os.makedirs(dst)

        names = os.listdir(src)
        for name in names:
                srcpath = os.path.join(src, name)
                dstpath = os.path.join(dst, name)
                if os.path.isdir(srcpath):
                        if not my_copytree(srcpath, dstpath):
                                return False
                else:
                        shutil.copy2(srcpath, dstpath)
        shutil.copystat(src, dst)

        print "successful in copying" + src + " to " + dst
        return True

def verify_exists_or_die(dir):
        if not os.path.exists( dir ):
                print "cannot find:",dir
                sys.exit(1)

def remove_or_die(dir):
        if os.path.exists( dir ):
                shutil.rmtree( dir )

def runtest():
        # check args
        if len( sys.argv ) != 3:
                print "Usage: migration_test.py <3.X etc> <expected result etc>"
		sys.exit(1)

        etc_3x = sys.argv[1]
        etc_expected = sys.argv[2]

        # verify all the required dirs are there
        verify_exists_or_die( splunk_etc() )
        verify_exists_or_die( etc_3x )
        verify_exists_or_die( etc_expected )

        # remove any remnants from older runs
        remove_or_die( splunk_etc() + BACKUP_EXT )
        remove_or_die( splunk_etc() + MIGRATION_RESULT_EXT )

        # mv etc etc.bak
        if not my_move( splunk_etc(), splunk_etc()+BACKUP_EXT ):
                print "moving splunk etc to backup failed"
                return False

        # mv etc_3x etc
        if not my_copytree( etc_3x, splunk_etc() ):
                return False

        # overlay etc.bak (4.x etc) onto etc_3x in prepartion for migration
        if not my_copytree( splunk_etc()+BACKUP_EXT, splunk_etc() ):
                return False

        # run the migration
        migr.autoMigrate(False)

        diff_result = filecmp.dircmp( splunk_etc(), etc_expected )

        # if there is any diff between the two, report failure
        if len(diff_result.diff_files) > 0\
                or len(diff_result.funny_files) > 0\
                or len(diff_result.left_only) > 0\
                or len(diff_result.right_only) > 0\
                or len(diff_result.common_funny) > 0:
                        print "FAIL: migration result differs from " + etc_expected
                        #TODO: perhaps dump everything out in verbose mode
                        #diff_result.report_full_closure()
                        return False

        # we're done, in the words of Ali G, SUCCCESSSSS
        print "OK"
        return True

def mymain():
        rc = runtest()

        # cleanup
        # save off migration result and restore original etc
        #
        if not my_move( splunk_etc(), splunk_etc() + MIGRATION_RESULT_EXT ):
                print "WARNING: could not save off migration results, filesystem fail maybe???"

        if os.path.exists( splunk_etc() + BACKUP_EXT ):
                if not my_move( splunk_etc() + BACKUP_EXT, splunk_etc() ):
                        print "WARNING: could not restore original $SPLUNK_HOME/etc, filesystem fail maybe???"
                        sys.exit(1)
                
        if not rc:
                sys.exit(1)
        sys.exit(0)

mymain()
