Splunk.namespace("Module");

Splunk.Module.XAxisTitleFormatter = $.klass(Splunk.Module.BaseChartFormatter, {
   
    initialize: function($super, container){
        $super(container);
   
        this.logger = Splunk.Logger.getLogger("x_axis_title_formatter.js");

        this._formElement = $("input",this.container)
            .bind("change", this.handleInputChange.bind(this));

        this._contextKey = "charting.primaryAxisTitle.text";
    },
    
    getGenericTitle: function() {
        var context = this.getContext();
        var search  = context.get("search");
        var plotIntention = search.popIntention("plot");
        var title = "";
        if (plotIntention && plotIntention["arg"].hasOwnProperty("mode")) {
            var mode = plotIntention["arg"]["mode"];
            if (mode == "timechart") {
                title = "time";
            } else if (mode=="top" || mode=="rare") {
                if (plotIntention["arg"].hasOwnProperty("fields")) {
                    title = plotIntention["arg"]["fields"];
                    if (typeof title == "object" && title.hasOwnProperty('clauses')) {
                        title = title['clauses'][0];
                    } else if (typeof title == "object") {
                        title = '';
                    }

                } else {
                    this.logger.error("top/rare mode, but no fields specified");
                }
            } 
        }
        
        return title;
    },
    
    getModifiedContext: function(){
        var context = this.getContext();
        var value = this.escapePropertyManagerControlChars(this._formElement.val())
        context.set(this._contextKey, value);
        return context;
    },
    
    onContextChange: function($super) {
        // if its showing nothing or it's showing the last one we autogenerated
        if (!this._formElement.val() || this._formElement.val() == this._lastGenericTitle) {
            var title = this.getGenericTitle();
            this._lastGenericTitle = title;
            this._formElement.val(title);
            this.setParam("default", title);
        }
        $super();
    },

    /**
     * disable for gauges
     */
    isCompatibleWithContext: function() {
        var context = this.getContext();
        if (!context.has("charting.chart")) return true;
        
        var incompatibleChartTypes = {
            'radialGauge':1,
            'fillerGauge':1,
            'markerGauge':1,
            'pie':1,
            'ratioBar':1
        }
        return !incompatibleChartTypes.hasOwnProperty(context.get('charting.chart'));
    }
});
