# httpd.rs - Unix HTTP Plugin Written By Narrow (nss@privacyx.com)

push @uplugins, 'un_httpd';
push @uplugins, 'un_h8080';

sub un_h8080 {
$httpd_host = shift;
&un_httpd($httpd_host, 8080);
}

sub un_httpd {
$httpd_host = shift;
$httpd_port = shift;
$httpd_port = 80 if (!$httpd_port); 
if($debug) { print "Checking for httpd:$httpd_port ...\n"; }
$server="";
$SIG{"ALRM"} = sub { close sock; return 0; };
alarm($time_con);
$iaddr = inet_aton($httpd_host) || return 0;
$paddr = sockaddr_in($httpd_port, $iaddr);
$proto = getprotobyname('tcp');
socket(sock, PF_INET, SOCK_STREAM, $proto) || return 0;
connect(sock, $paddr) || return 0;
send(sock, "HEAD / HTTP/1.0\r\nConnection: close\r\n\r\n", 0);

while(<sock>) {
    if (/^Server: (.*)/) {
	$server=$1;
	close sock;
    }
}
close sock; chomp $server;
if(!$server) { return; }
$_=$server;
    if(/ncsa/i && /1.3/) {
	print "[$httpd_host] - [NCSA 1.3]\n";
	print LOG "[$httpd_host] - [NCSA 1.3]\n";
	return;
    }
    if(/ncsa/i && /1.4.1/) {
	print "[$httpd_host] - [NCSA 1.4.1]\n";
	print LOG "[$httpd_host] - [NCSA 1.4.1]\n";
	return;
    }
    if(/ncsa/i && /1.4.2/) {
	print "[$httpd_host] - [NCSA 1.4.2]\n";
	print LOG "[$httpd_host] - [NCSA 1.4.2]\n";
	return;
    }
    if(/ncsa/i && /1.5.1/) {
	print "[$httpd_host] - [NCSA 1.5.1]\n";
	print LOG "[$httpd_host] - [NCSA 1.5.1]\n";
	return;
    }
    if(/ncsa/i && /1.5.2/) {
	print "[$httpd_host] - [NCSA 1.5.2]\n";
	print LOG "[$httpd_host] - [NCSA 1.5.2]\n";
	return;
    }
    if(/ncsa/i && /1.4/) {
	print "[$httpd_host] - [NCSA 1.4]\n";
	print LOG "[$httpd_host] - [NCSA 1.4]\n";
	return;
    }
    if(/ncsa/i && /1.5/) {
	print "[$httpd_host] - [NCSA 1.5]\n";
	print LOG "[$httpd_host] - [NCSA 1.5]\n";
	return;
    }
    if(/dwhttpd/i && /3.1a4/) {
	print "[$httpd_host] - [dwhttpd 3.1a4]\n";
	print LOG "[$httpd_host] - [dwhttpd 3.1a4]\n";
	return;
    }
    if(/ews/i && /1.1/) {
	print "[$httpd_host] - [EWS 1.1]\n";
	print LOG "[$httpd_host] - [EWS 1.1]\n";
	return;
    }
    if(/teamtrack/i && /3.00/) {
	print "[$httpd_host] - [TeamTrack 3.00]\n";
	print LOG "[$httpd_host] - [TeamTrack 3.00]\n";
	return;
    }
    if(/lotus domino/i && /4.6.([4-6])/) {
	print "[$httpd_host] - [Lotus Domino Server 4.6.$1]\n";
	print LOG "[$httpd_host] - [Lotus Domino Server 4.6.$1]\n";
	return;
    }
    if(/netscape fasttrack/i && /2.01a/) {
	print "[$httpd_host] - [Netscape FastTrack 2.01a]\n";
	print LOG "[$httpd_host] - [Netscape FastTrack 2.01a]\n";
	return;
    }
    if(/apache/i && /1.0.3/) {
	print "[$httpd_host] - [Apache Web Server 1.0.3]\n";
	print LOG "[$httpd_host] - [Apache Web Server 1.0.3]\n";
	return;
    }
    if(/WN/ && /1./) {
	print "[$httpd_host] - [Web Server: WN 1.x]\n";
	print LOG "[$httpd_host] - [Web Server: WN 1.x]\n";
	return;
    }
    if(/WN/ && /2.([0-1])/) {
	print "[$httpd_host] - [Web Server: WN 2.$1]\n";
	print LOG "[$httpd_host] - [Web Server: WN 2.$1]\n";
	return;
    }
} print;