# named.rs - Unix Named Plugin Written By Narrow (nss@privacyx.com)

push @uplugins, 'un_named';

sub un_named {
if($debug) { print "Checking for named ...\n"; }
$named_host = shift;
$SIG{"ALRM"} = sub { close named; return 0; };
alarm($time_con);
$iaddr = inet_aton($named_host) || return 0;
$paddr = sockaddr_in(53, $iaddr);
$proto = getprotobyname('tcp');
socket(named, PF_INET, SOCK_STREAM, $proto) || return 0;
connect(named, $paddr) || return 0;
close named;

open(CMD, "/usr/bin/dig \@$named_host txt chaos version.bind |") || return 0;
while(<CMD>) { chomp;
($string, $os, $chaos, $txt, $version) = split;
if($string eq "VERSION.BIND.") {
if($version =~ /4.9.([3-6])/) {
    print "[$named_host] - [Named: $version]\n";
    print LOG "[$named_host] - [Named: $version]\n";
    close CMD;
    return;
}
if($version =~ /8.([1-2])/ && $version !~ /8.2.([2-99])/ && $version !~ /8.1.2/) {
    print "[$named_host] - [Named: $version]\n";
    print LOG "[$named_host] - [Named: $version]\n";
    close CMD;
    return;
  }
 }
}
close CMD;
} print;