# pop3.rs - Unix POP3 Plugin By Narrow (nss@privacyx.com)

push @uplugins, 'un_pop3';

sub un_pop3 {
if($debug) { print "Checking for pop3 ...\n"; }
$pop3_host = shift;
$SIG{"ALRM"} = sub { close pop3; return 0; };
alarm($time_con);
$iaddr = inet_aton($pop3_host) || return 0;
$paddr = sockaddr_in(110, $iaddr);
$proto = getprotobyname('tcp');
socket(pop3, PF_INET, SOCK_STREAM, $proto) || return 0;
connect(pop3, $paddr) || return 0;

while(<$pop3>) { chomp;
    if(/qpop/i && /ersion 2.4b2/) {
	print "[$pop3_host] - [QPOP 2.4b2]\n";
	print LOG "[$pop3_host] - [QPOP 2.4b2]\n";
	close pop3;
	return;
    }
    if(/qpop/i && /ersion 2.41beta1/) {
	print "[$pop3_host] - [QPOP 2.41beta1]\n";
	print LOG "[$pop3_host] - [QPOP 2.41beta1]\n";
	close pop3;
	return;
    }
    if(/qpop/i && /ersion 3.0b([1-29])/) {
	print "[$pop3_host] - [QPOP 3.0b$1]\n";
	print LOG "[$pop3_host] - [QPOP 3.0b$1]\n";
	close pop3;
	return;
    }
    if(/sco/i && /2.1.4\-R3/) {
	print "[$pop3_host] - [ScoPOP 2.1.4\-R3]\n";
	print LOG "[$pop3_host] - [ScoPOP 2.1.4\-R3]\n";
	close pop3;
	return;
    }
    if(/sco/i && /5.0.0/) {
	print "[$pop3_host] - [ScoPOP 5.0.0]\n";
	print LOG "[$pop3_host] - [ScoPOP 5.0.0]\n";
	close pop3;
	return;
    }
    if(/qpop/i && /ersion 2.2/) {
	print "[$pop3_host] - [QPOP 2.2]\n";
	print LOG "[$pop3_host] - [QPOP 2.2]\n";
	close pop3;
	return;
    }
    if(/qpop/i && /ersion 2.3/) {
	print "[$pop3_host] - [QPOP 2.3]\n";
	print LOG "[$pop3_host] - [QPOP 2.3]\n";
	close pop3;
	return;
    }
    if(/qpop/i && /ersion 2.4/) {
	print "[$pop3_host] - [QPOP 2.4]\n";
	print LOG "[$pop3_host] - [QPOP 2.4]\n";
	close pop3;
	return;
    }
    if(/ucb/i && /popper/i && /1.831beta/) {
	print "[$pop3_host] - [UCB Pop Server 1.831beta]\n";
	print LOG "[$pop3_host] - [UCB Pop Server 1.831beta]\n";
	close pop3;
	return;
    }
    if(/mercur pop3-server/i && /v3.20.01/) {
	print "[$pop3_host] - [Mercur POP3 Server v3.20.01]\n";
	print LOG "[$pop3_host] - [Mercur POP3 Server v3.20.01]\n";
	close pop3;
	return;
    }

close pop3;
 }
} print;