package com.zend.ide.classbrowser;

import java.io.*;
import com.zend.ide.highlighter.*;
import com.javacup.runtime.*;
import com.javacup.*;


%%

%class CompletionLexer
%implements ParserConstants
%unicode
%line

/* %cup */
%implements com.javacup.runtime.Scanner
%function next_token
%type com.javacup.runtime.Symbol
%eofval{
  return new com.javacup.runtime.Symbol(sym.EOF);
%eofval}
%eofclose

%caseless

%standalone
%state ST_IN_SCRIPTING
%state ST_DOUBLE_QUOTES
%state ST_SINGLE_QUOTE
%state ST_BACKQUOTE
%state ST_HEREDOC
%state ST_LOOKING_FOR_PROPERTY
%state ST_LOOKING_FOR_VARNAME
%state ST_COMMENT
%{

    private String heredoc = null;
    private boolean asp_tags = false;
    private boolean short_tags_allowed = true;
    private StateStack stack = new StateStack();
    private int numberOfr;
    ParserClient parserClient;

    private void pushState(int state) {
        stack.pushStack(yy_lexical_state);
        yybegin(state);
    }

    private void popState() {
        yybegin(stack.popStack());
    }

    public int getCurrentLine() {
        return yyline;
    }

    private void maintainReof() {
        numberOfr = 0;
    }

    private void maintainR(String text) {
        //if (temp)System.out.println("*** " + yyline + " " + numberOfr + " " + (text.indexOf("\r")>=0));
        for (int i = 0; i < text.length(); i++) {
            if (text.charAt(i) == '\r') {
                //if (temp)System.out.println("*** " + yyline + " " + numberOfr + " " + (text.indexOf("\r")>=0));
                numberOfr++;
            }
        }
    }

    private int getLeftPosition() {
        return yy_startRead - yy_pushbackPos - numberOfr;
    }

    private int getRightPosition() {
        return yy_currentPos - yy_pushbackPos - numberOfr;
    }

    public void setParserClient(ParserClient parserClient) {
        this.parserClient = parserClient;
    }

    private void handlePHPStart() {
        if (parserClient != null) {
            parserClient.handlePHPStart(getRightPosition());
        }
    }

    private void handlePHPEnd() {
        if (parserClient != null) {
            parserClient.handlePHPEnd(getLeftPosition());
        }
    }

    private Symbol createNewSymbol(int symbolNumber) {
        return new Symbol(symbolNumber, getLeftPosition(), getRightPosition(), yytext());
    }

%}

LNUM=[0-9]+
DNUM=([0-9]*[\.][0-9]+)|([0-9]+[\.][0-9]*)
EXPONENT_DNUM=(({LNUM}|{DNUM})[eE][+-]?{LNUM})
HNUM="0x"[0-9a-fA-F]+
LABEL=[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*
WHITESPACE=[ \n\r\t]+
TABS_AND_SPACES=[ \t]*
ESCAPED_AND_WHITESPACE=[\n\t\r #'.:;,()|\^&+-/*=%!~<>?@]+
ANY_CHAR=(.|[\n])
NEWLINE=("\r"|"\n"|"\r\n")

%%

<YYINITIAL>{
    (([^<]|"<"[^?%s<])+)|"<s"|"<" {
        maintainR(yytext());
	    return new Symbol(ParserConstants.T_INLINE_HTML, getLeftPosition(), getRightPosition());
    }

    "<?"|"<script"{WHITESPACE}+"language"{WHITESPACE}*"="{WHITESPACE}*("php"|"\"php\""|"\'php\'"){WHITESPACE}*">" {
        maintainR(yytext());
        if (short_tags_allowed || yylength()>2) { /* yyleng>2 means it's not <? but <script> */
            handlePHPStart();
            yybegin(ST_IN_SCRIPTING);
            //return T_OPEN_TAG;
        } else {
            return new Symbol(ParserConstants.T_INLINE_HTML, getLeftPosition(), getRightPosition());
        }
    }

    "<%="|"<?=" {
        if ((yytext().charAt(1)=='%' && asp_tags)
            || (yytext().charAt(1)=='?' && short_tags_allowed)) {
            handlePHPStart();
            yybegin(ST_IN_SCRIPTING);
            //return T_OPEN_TAG_WITH_ECHO;
        } else {
            return new Symbol(ParserConstants.T_INLINE_HTML, getLeftPosition(), getRightPosition());
        }
    }

    "<%" {
        if (asp_tags) {
            handlePHPStart();
            yybegin(ST_IN_SCRIPTING);
        } else {
            return new Symbol(ParserConstants.T_INLINE_HTML, getLeftPosition(), getRightPosition());
        }
    }

    "<?php"([ \t]|{NEWLINE}) {
        maintainR(yytext());
        handlePHPStart();
    	yybegin(ST_IN_SCRIPTING);
    }

    "<?php_track_vars?>"{NEWLINE}? {
        maintainR(yytext());
    }

}

<ST_IN_SCRIPTING> {

    "exit"                  {return createNewSymbol(ParserConstants.T_EXIT);}
    "die"                   {return createNewSymbol(ParserConstants.T_EXIT);}
    "function"|"cfunction"  {return createNewSymbol(ParserConstants.T_FUNCTION);}
    "const"                 {return createNewSymbol(ParserConstants.T_CONST);}
    "return"                {return createNewSymbol(ParserConstants.T_RETURN);}
    "if"                    {return createNewSymbol(ParserConstants.T_IF);}
    "elseif"                {return createNewSymbol(ParserConstants.T_ELSEIF);}
    "endif"                 {return createNewSymbol(ParserConstants.T_ENDIF);}
    "else"                  {return createNewSymbol(ParserConstants.T_ELSE);}
    "while"                 {return createNewSymbol(ParserConstants.T_WHILE);}
    "endwhile"              {return createNewSymbol(ParserConstants.T_ENDWHILE);}
    "do"                    {return createNewSymbol(ParserConstants.T_DO);}
    "for"                   {return createNewSymbol(ParserConstants.T_FOR);}
    "endfor"                {return createNewSymbol(ParserConstants.T_ENDFOR);}
    "foreach"               {return createNewSymbol(ParserConstants.T_FOREACH);}
    "endforeach"            {return createNewSymbol(ParserConstants.T_ENDFOREACH);}
    "declare"               {return createNewSymbol(ParserConstants.T_DECLARE);}
    "enddeclare"            {return createNewSymbol(ParserConstants.T_ENDDECLARE);}
    "as"                    {return createNewSymbol(ParserConstants.T_AS);}
    "switch"                {return createNewSymbol(ParserConstants.T_SWITCH);}
    "endswitch"             {return createNewSymbol(ParserConstants.T_ENDSWITCH);}
    "case"                  {return createNewSymbol(ParserConstants.T_CASE);}
    "default"               {return createNewSymbol(ParserConstants.T_DEFAULT);}
    "break"                 {return createNewSymbol(ParserConstants.T_BREAK);}
    "continue"              {return createNewSymbol(ParserConstants.T_CONTINUE);}
    "echo"                  {return createNewSymbol(ParserConstants.T_ECHO);}
    "print"                 {return createNewSymbol(ParserConstants.T_PRINT);}
    "class"                 {return createNewSymbol(ParserConstants.T_CLASS);}
    "try"                   {return createNewSymbol(ParserConstants.T_TRY);}
    "catch"                 {return createNewSymbol(ParserConstants.T_CATCH);}
    "throw"                 {return createNewSymbol(ParserConstants.T_THROW);}
    "instanceof"            {return createNewSymbol(ParserConstants.T_INSTANCEOF);}
    "interface"             {return createNewSymbol(ParserConstants.T_INTERFACE);}
    "implements"            {return createNewSymbol(ParserConstants.T_IMPLEMENTS);}
    "abstract"              {return createNewSymbol(ParserConstants.T_ABSTRACT);}
    "final"                 {return createNewSymbol(ParserConstants.T_FINAL);}
    "private"               {return createNewSymbol(ParserConstants.T_PRIVATE);}
    "protected"             {return createNewSymbol(ParserConstants.T_PROTECTED);}
    "public"                {return createNewSymbol(ParserConstants.T_PUBLIC);}
    "extends"               {return createNewSymbol(ParserConstants.T_EXTENDS);}
    "::"                    {return createNewSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);}
    "new"                   {return createNewSymbol(ParserConstants.T_NEW);}
    "var"                   {return createNewSymbol(ParserConstants.T_VAR);}
    "eval"                  {return createNewSymbol(ParserConstants.T_EVAL);}
    "include"               {return createNewSymbol(ParserConstants.T_INCLUDE);}
    "include_once"          {return createNewSymbol(ParserConstants.T_INCLUDE_ONCE);}
    "require"               {return createNewSymbol(ParserConstants.T_REQUIRE);}
    "require_once"          {return createNewSymbol(ParserConstants.T_REQUIRE_ONCE);}
    "use"                   {return createNewSymbol(ParserConstants.T_USE);}
    "global"                {return createNewSymbol(ParserConstants.T_GLOBAL);}
    "isset"                 {return createNewSymbol(ParserConstants.T_ISSET);}
    "empty"                 {return createNewSymbol(ParserConstants.T_EMPTY);}
    "static"                {return createNewSymbol(ParserConstants.T_STATIC);}
    "unset"                 {return createNewSymbol(ParserConstants.T_UNSET);}
    "=>"                    {return createNewSymbol(ParserConstants.T_DOUBLE_ARROW);}
    "list"                  {return createNewSymbol(ParserConstants.T_LIST);}
    "array"                 {return createNewSymbol(ParserConstants.T_ARRAY);}
    "++"                    {return createNewSymbol(ParserConstants.T_INC);}
    "--"                    {return createNewSymbol(ParserConstants.T_DEC);}
    "==="                   {return createNewSymbol(ParserConstants.T_IS_IDENTICAL);}
    "!=="                   {return createNewSymbol(ParserConstants.T_IS_NOT_IDENTICAL);}
    "=="                    {return createNewSymbol(ParserConstants.T_IS_EQUAL);}
    "!="|"<>"               {return createNewSymbol(ParserConstants.T_IS_NOT_EQUAL);}
    "<="                    {return createNewSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);}
    ">="                    {return createNewSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);}
    "+="                    {return createNewSymbol(ParserConstants.T_PLUS_EQUAL);}
    "-="                    {return createNewSymbol(ParserConstants.T_MINUS_EQUAL);}
    "*="                    {return createNewSymbol(ParserConstants.T_MUL_EQUAL);}
    "/="                    {return createNewSymbol(ParserConstants.T_DIV_EQUAL);}
    ".="                    {return createNewSymbol(ParserConstants.T_CONCAT_EQUAL);}
    "%="                    {return createNewSymbol(ParserConstants.T_MOD_EQUAL);}
    "<<="                   {return createNewSymbol(ParserConstants.T_SL_EQUAL);}
    ">>="                   {return createNewSymbol(ParserConstants.T_SR_EQUAL);}
    "&="                    {return createNewSymbol(ParserConstants.T_AND_EQUAL);}
    "|="                    {return createNewSymbol(ParserConstants.T_OR_EQUAL);}
    "^="                    {return createNewSymbol(ParserConstants.T_XOR_EQUAL);}
    "||"                    {return createNewSymbol(ParserConstants.T_BOOLEAN_OR);}
    "&&"                    {return createNewSymbol(ParserConstants.T_BOOLEAN_AND);}
    "OR"                    {return createNewSymbol(ParserConstants.T_LOGICAL_OR);}
    "AND"                   {return createNewSymbol(ParserConstants.T_LOGICAL_AND);}
    "XOR"                   {return createNewSymbol(ParserConstants.T_LOGICAL_XOR);}
    "<<"                    {return createNewSymbol(ParserConstants.T_SL);}
    ">>"                    {return createNewSymbol(ParserConstants.T_SR);}
    ";"                     {return createNewSymbol(ParserConstants.T_SEMICOLON);}
    ":"                     {return createNewSymbol(ParserConstants.T_NEKUDOTAIM);}
    ","                     {return createNewSymbol(ParserConstants.T_COMMA);}
    "."                     {return createNewSymbol(ParserConstants.T_NEKUDA);}
    "["                     {return createNewSymbol(ParserConstants.T_OPEN_RECT);}
    "]"                     {return createNewSymbol(ParserConstants.T_CLOSE_RECT);}
    "("                     {return createNewSymbol(ParserConstants.T_OPEN_PARENTHESE);}
    ")"                     {return createNewSymbol(ParserConstants.T_CLOSE_PARENTHESE);}
    "|"                     {return createNewSymbol(ParserConstants.T_OR);}
    "^"                     {return createNewSymbol(ParserConstants.T_KOVA);}
    "&"                     {return createNewSymbol(ParserConstants.T_REFERENCE);}
    "+"                     {return createNewSymbol(ParserConstants.T_PLUS);}
    "-"                     {return createNewSymbol(ParserConstants.T_MINUS);}
    "/"                     {return createNewSymbol(ParserConstants.T_DIV);}
    "*"                     {return createNewSymbol(ParserConstants.T_TIMES);}
    "="                     {return createNewSymbol(ParserConstants.T_EQUAL);}
    "%"                     {return createNewSymbol(ParserConstants.T_PRECENT);}
    "!"                     {return createNewSymbol(ParserConstants.T_NOT);}
    "~"                     {return createNewSymbol(ParserConstants.T_TILDA);}
    "$"                     {return createNewSymbol(ParserConstants.T_DOLLAR);}
    "<"                     {return createNewSymbol(ParserConstants.T_RGREATER);}
    ">"                     {return createNewSymbol(ParserConstants.T_LGREATER);}
    "?"                     {return createNewSymbol(ParserConstants.T_QUESTION_MARK);}
    "@"                     {return createNewSymbol(ParserConstants.T_AT);}
    "__FILE__"              {return createNewSymbol(ParserConstants.T_FILE);}
    "__CLASS__"             {return createNewSymbol(ParserConstants.T_CLASS_C);}
    "__FUNCTION__"          {return createNewSymbol(ParserConstants.T_FUNC_C);}
    "__METHOD__"            {return createNewSymbol(ParserConstants.T_CLASS_C);}
    "__LINE__"              {return createNewSymbol(ParserConstants.T_LINE);}

    "define"                {return createNewSymbol(ParserConstants.T_DEFINE);} /* not a keyword, hust for recogmize constans.*/

    "("{TABS_AND_SPACES}("int"|"integer"){TABS_AND_SPACES}")"           {return createNewSymbol(ParserConstants.T_INT_CAST);}
    "("{TABS_AND_SPACES}("real"|"double"|"float"){TABS_AND_SPACES}")"   {return createNewSymbol(ParserConstants.T_DOUBLE_CAST);}
    "("{TABS_AND_SPACES}"string"{TABS_AND_SPACES}")"                    {return createNewSymbol(ParserConstants.T_STRING_CAST);}
    "("{TABS_AND_SPACES}"array"{TABS_AND_SPACES}")"                     {return createNewSymbol(ParserConstants.T_ARRAY_CAST);}
    "("{TABS_AND_SPACES}"object"{TABS_AND_SPACES}")"                    {return createNewSymbol(ParserConstants.T_OBJECT_CAST);}
    "("{TABS_AND_SPACES}("bool"|"boolean"){TABS_AND_SPACES}")"          {return createNewSymbol(ParserConstants.T_BOOL_CAST);}
    "("{TABS_AND_SPACES}("unset"){TABS_AND_SPACES}")"                   {return createNewSymbol(ParserConstants.T_UNSET_CAST);}

    "{" {
        pushState(ST_IN_SCRIPTING);
        return createNewSymbol(ParserConstants.T_CURLY_OPEN);
    }

    "}" {
        if (!stack.isEmpty()) {
            popState();
        }
	    return createNewSymbol(ParserConstants.T_CURLY_CLOSE);
    }

    {DNUM}|{EXPONENT_DNUM}|{LNUM}|{HNUM} {
	    return createNewSymbol(ParserConstants.T_DNUMBER);
    }

    "->" {
	    pushState(ST_LOOKING_FOR_PROPERTY);
	    return createNewSymbol(ParserConstants.T_OBJECT_OPERATOR);
    }

    "$"{LABEL} {
	    return createNewSymbol(ParserConstants.T_VARIABLE);
	}

    {LABEL} {
	    return createNewSymbol(ParserConstants.T_STRING);
	}

    {WHITESPACE} {
        maintainR(yytext());
    }

    ([#]|"//")([^\n\r?]|"?"[^>\n\r])*("?\n"|"?\r\n")? { /* eat one line comments */
        maintainR(yytext());
    }

    "/**" ~"*/"{WHITESPACE}?("function"|"public"|"protected"|"private"|"static"|"abstract"){WHITESPACE} {
        String text = yytext();
        int c = text.lastIndexOf("*/") + 2;
        String comment = text.substring(0, c);
        maintainR(comment);
        yypushback(text.length() - comment.length());
        return createNewSymbol(ParserConstants.T_FUNCTION_COMMENT);

    }

    "/*"{WHITESPACE}"@var"{WHITESPACE}("$"?){LABEL}{WHITESPACE}{LABEL}{WHITESPACE}"*/" {
        maintainR(yytext());
        return createNewSymbol(ParserConstants.T_VAR_COMMENT);
    }

    "/*" {
        yybegin(ST_COMMENT);
    }

    ("?>"|"</script"{WHITESPACE}*">"){NEWLINE}? {
        maintainR(yytext());
        handlePHPEnd();
        yybegin(YYINITIAL);
        return createNewSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
    }

    "%>"{NEWLINE}? {
        maintainR(yytext());
        if (asp_tags) {
            handlePHPEnd();
            yybegin(YYINITIAL);
            //return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
        } else {
            return createNewSymbol(ParserConstants.T_INLINE_HTML);
        }
    }

    ([\"]([^$\"\\]|("\\".))*[\"]) {
	    return createNewSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
    }

    ([']([^'\\]|("\\".))*[']) {
        maintainR(yytext());
        return createNewSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
    }

    [\"] {
        yybegin(ST_DOUBLE_QUOTES);
        return createNewSymbol(ParserConstants.T_QUATE);
    }

    "<<<"{TABS_AND_SPACES}{LABEL}{NEWLINE} {
        maintainR(yytext());
        heredoc = yytext().substring(3).trim();    // for '<<<'
        yybegin(ST_HEREDOC);
        return createNewSymbol(ParserConstants.T_START_HEREDOC);
    }

    [`] {
        yybegin(ST_BACKQUOTE);
        return createNewSymbol(ParserConstants.T_BACKQUATE);
    }

    ['] {
        yybegin(ST_SINGLE_QUOTE);
        return createNewSymbol(ParserConstants.T_SINGLE_QUATE);
    }
}

<ST_SINGLE_QUOTE> {
    ([^'\\]|\\[^'\\])+ {
        maintainR(yytext());
        return createNewSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
    }

    "\\'" {
	    return createNewSymbol(ParserConstants.T_CHARACTER);
	}

    "\\\\" {
	    return createNewSymbol(ParserConstants.T_CHARACTER);
	}

    ['] {
	    yybegin(ST_IN_SCRIPTING);
	    return createNewSymbol(ParserConstants.T_SINGLE_QUATE);
	}
}

<ST_DOUBLE_QUOTES,ST_BACKQUOTE,ST_HEREDOC> {
    "->" {
	    pushState(ST_LOOKING_FOR_PROPERTY);
	    return createNewSymbol(ParserConstants.T_OBJECT_OPERATOR);
    }

    "${" {
	    pushState(ST_LOOKING_FOR_VARNAME);
	    return createNewSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
	}

    {LNUM}|{HNUM} { /* treat numbers (almost) as strings inside encapsulated strings */
	    return createNewSymbol(ParserConstants.T_NUM_STRING);
	}

    "$"{LABEL} {
	    return createNewSymbol(ParserConstants.T_VARIABLE);
	}
}

<ST_HEREDOC> {
    ^{LABEL}(";")?{NEWLINE} {
        maintainR(yytext());
        String text = yytext();
        int length = text.length();
        text = text.trim();
        boolean foundNP = false;
        if (text.endsWith(";")) {
            text = text.substring(0, text.length() - 1);
            foundNP = true;
        }
        if (text.equals(heredoc)) {
            if (foundNP) {
                yypushback(length - text.length());
            }
            heredoc = null;
            yybegin(ST_IN_SCRIPTING);
            return createNewSymbol(ParserConstants.T_END_HEREDOC);
        } else {
            return createNewSymbol(ParserConstants.T_STRING);
        }
    }
}

<ST_DOUBLE_QUOTES,ST_BACKQUOTE,ST_HEREDOC> {
    {LABEL} {
	    return createNewSymbol(ParserConstants.T_STRING);
	}

    {ESCAPED_AND_WHITESPACE} {
        maintainR(yytext());
	    return createNewSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
	}

    "$"[^a-zA-Z_\x7f-\xff{] {
        if (yylength() == 2) {
            yypushback(1);
        }
        return createNewSymbol(ParserConstants.T_CHARACTER);
    }

    "["     {return createNewSymbol(ParserConstants.T_OPEN_RECT);}

    "]"     {return createNewSymbol(ParserConstants.T_CLOSE_RECT);}

    "$"     {return createNewSymbol(ParserConstants.T_DOLLAR);}

    "{$" {
        pushState(ST_IN_SCRIPTING);
        yypushback(yylength()-1);
        return createNewSymbol(ParserConstants.T_CURLY_OPEN);
    }
}

<ST_DOUBLE_QUOTES> {
    [`]+ {
	    return createNewSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
	}

    "\\\"" {
	    return createNewSymbol(ParserConstants.T_CHARACTER);
	}
}

<ST_BACKQUOTE> {
    [\"]+ {
	    return createNewSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
	}

    "\\`" {
	    return createNewSymbol(ParserConstants.T_CHARACTER);
	}
}

<ST_DOUBLE_QUOTES,ST_BACKQUOTE,ST_HEREDOC>{
    "\\"[0-7]{1,3} {
	    return createNewSymbol(ParserConstants.T_CHARACTER);
	}

    "\\x"[0-9A-Fa-f]{1,2} {
	    return createNewSymbol(ParserConstants.T_CHARACTER);
	}

    "\\"{ANY_CHAR} {
        switch (yytext().charAt(1)) {
            case 'n':
                break;
            case 't':
                break;
            case 'r':
                break;
            case '\\':
                break;
            case '$':
                break;
            case '{':
                break;
            default:
                return createNewSymbol(ParserConstants.T_BAD_CHARACTER);
        }
        maintainR(yytext());
        return createNewSymbol(ParserConstants.T_CHARACTER);
    }
}

<ST_HEREDOC>{
    [\"'`]+ {
	    return createNewSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
	}
}

<ST_DOUBLE_QUOTES>{
    [\"] {
	    yybegin(ST_IN_SCRIPTING);
	    return createNewSymbol(ParserConstants.T_QUATE);
	}
}

<ST_BACKQUOTE>{
    [`] {
	    yybegin(ST_IN_SCRIPTING);
	    return createNewSymbol(ParserConstants.T_BACKQUATE);
	}
}

<ST_COMMENT>{
    "*/" {
        yybegin(ST_IN_SCRIPTING);
    }
}

<ST_LOOKING_FOR_VARNAME>{
    {LABEL} {
	    popState();
	    pushState(ST_IN_SCRIPTING);
	    return createNewSymbol(ParserConstants.T_STRING_VARNAME);
    }

    {ANY_CHAR} {
    	yypushback(yylength());
	    popState();
	    pushState(ST_IN_SCRIPTING);
    }
}

<ST_LOOKING_FOR_PROPERTY> {
    {LABEL} {
	    popState();
	    return createNewSymbol(ParserConstants.T_STRING);
    }

    {ANY_CHAR} {
    	yypushback(yylength());
	    popState();
    }
}

<ST_IN_SCRIPTING,ST_DOUBLE_QUOTES,ST_BACKQUOTE,YYINITIAL,ST_LOOKING_FOR_PROPERTY,ST_COMMENT><<EOF>> {
    maintainReof();
	return createNewSymbol(0); //ParserConstants.T_EOF;
}

<ST_IN_SCRIPTING,ST_DOUBLE_QUOTES,ST_SINGLE_QUOTE,ST_BACKQUOTE,ST_HEREDOC,ST_COMMENT>{ANY_CHAR} {
    maintainR(yytext());
	// do nothing
}