// BPX detection by TSCube (29/04/2000)

#include <windows.h>
#include <string.h>
#include "resource.h"


BOOL CALLBACK DialogProc (HWND, UINT, WPARAM, LPARAM) ;
int check(HWND);

HINSTANCE hInst;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
	hInst = hInstance; // see WM_INITDIALOG
	DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_DIALOG1),NULL,(DLGPROC)DialogProc,0);
	return 0;
}


BOOL CALLBACK DialogProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{	
	switch (message)
	{    
	case WM_CLOSE:
		EndDialog(hwnd,0);
		return 1 ;
	
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{ 
		case IDC_GENERATE :
			check(hwnd);
			break;

		case IDC_ABOUT :
			MessageBox(hwnd,"BPX detection by TSCube (29/04/2000)","About",MB_ICONINFORMATION);
			break;
		}
		
		return 1;
		
		case WM_INITDIALOG:

			// display icon :
			 SendMessage( hwnd, WM_SETICON, TRUE,(LPARAM)LoadIcon(hInst, MAKEINTRESOURCE(IDI_TSC)));

			
			RECT DlgRect;
			RECT DesktopRect;
			HWND hwindow;
		 
			// center window (based on source code by Iczelion) :
			GetWindowRect(hwnd,&DlgRect); // retrieves the dimensions of the bounding rectangle of the specified window
			hwindow = GetDesktopWindow(); 
			GetWindowRect(hwindow,&DesktopRect); // returns the handle of the Windows desktop window
			 
			int DlgHeight = DlgRect.bottom - DlgRect.top;
			int DlgWidth = DlgRect.right - DlgRect.left;
			int x=(DesktopRect.right+DesktopRect.left-DlgWidth)/2;
			int y =(DesktopRect.bottom+DesktopRect.top-DlgHeight)/2;
			MoveWindow(hwnd,x,y,DlgWidth,DlgHeight,FALSE);
		 
			return 1 ;
	 
	}
     return 0;
}



//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////

int check(HWND hwnd)
{
	char name[100];
	char serial[100];
	char correctSerial[100];

	GetDlgItemText(hwnd,IDC_NAME,name,100); 
	GetDlgItemText(hwnd,IDC_SERIAL,serial,100); 

	if ( (strlen(name)==0))
	{
		MessageBox(hwnd,"Please type your name !","Registration Error",MB_ICONEXCLAMATION);
		return 1;
	}

	if ( (strlen(serial)==0))
	{
		MessageBox(hwnd,"Please type your serial !","Registration Error",MB_ICONEXCLAMATION);
		return 1;
	}


	MessageBox(hwnd,"Start of BPX detection","BPX detection",MB_ICONINFORMATION);
	int numberofcc = 0;
	__asm
	{
		mov edi,offset begin_bpxdetection
		mov ecx,offset end_bpxdetection
		sub ecx,edi
		mov al,0CCh
search :
		repnz scasb
		jne end
		inc numberofcc
		mov ecx,offset end_bpxdetection
		sub ecx,edi
		jmp search
end :
	}

	if (numberofcc>0) // you'll have to change this number according to YOUR code
	{
		MessageBox(hwnd,"Don't BPX me !","BPX Detection",MB_ICONEXCLAMATION);
		return 1;
	}

	MessageBox(hwnd,"End of BPX detection : no BPX detected !","BPX detection",MB_ICONINFORMATION);

		

	// BPX will be search in the following code :
	__asm nop // use this to locate the following code in softice
	__asm nop
begin_bpxdetection :
	unsigned int i;
	for (i=0;i<strlen(name);i++)
	{
		correctSerial[i] = (((name[i] + name[i+1]) ^ name[i]) % 9) +'0';
	}
	correctSerial[i]=0x00;

	if (strcmp(correctSerial,serial)!=0)
	{
		MessageBox(hwnd,"Invalid serial !","Registration Error",MB_ICONEXCLAMATION);
	}
	else
	{
		MessageBox(hwnd,"Thanks for registering !","Registration",MB_ICONINFORMATION);
	}

	end_bpxdetection :
	__asm nop
	__asm nop
	// End of BPX search

	return 0;
}


