#ifndef RTCP_H
#define RTCP_H

/*
	VoIPong Voice Over IP Sniffer
	Copyright (C) 2004 Murat Balaban <murat || enderunix.org>
	All rights reserved.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <osspecific.h>

typedef struct tsap_rtcp {
	u_int32_t sip;
	u_int32_t dip;
	u_int16_t sp;
	u_int16_t dp;
	struct tsap_rtcp *next;
} tsap_rtcp;

unsigned int hash(u_int32_t sip, u_int32_t dip, u_int16_t sp, u_int16_t dp);
void check_rtcp_hash(u_int32_t sip, u_int32_t dip, u_int16_t sp, u_int16_t dp);
unsigned int has_rtcp_pair(u_int32_t sip, u_int32_t dip, u_int16_t sp, u_int16_t dp);
int odd(int n);
void probertcp(u_char *udata, const struct pcap_pkthdr *pkthdr, const u_char *packet);

#endif
