
/*
	VoIPong Voice Over IP Sniffer
	Copyright (C) 2004 Murat Balaban <murat || enderunix.org>
	All rights reserved.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <pcap.h>

#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#define __USE_BSD 1
#define __FAVOR_BSD 1

#include <netinet/ip.h>
#include <netinet/udp.h>
#include <voipong.h>
#include <voipongsock.h>
#include <voipongpcap.h>
#include <voipongrtp.h>
#include <voipongrtcp.h>
#include <miscutil.h>
#include <conf.h>


static pcap_t *pd = NULL;
static char filter[256];
static int dllen = 14;
static voipstat stats;

extern char gdevice[256];
extern char gfilter[1024];
extern int gpromisc;
extern int gsnaplen;
extern int greadtmt;

void packet_handler(u_char *udata, const struct pcap_pkthdr *pkthdr, const u_char *packet);

voipstat *
getstats()
{
	return &stats;
}

void
setstats(voipstat *s)
{
	memcpy(&stats, s, sizeof(voipstat));
}

int
initpcap(char *errbuf)
{
	bpf_u_int32 netp;
	bpf_u_int32 maskp;
	char netstr[64], maskstr[64];
	struct bpf_program fprog;
	struct in_addr in;
	char *dev;
	char perrbuf[PCAP_ERRBUF_SIZE];

	if (strlen(gdevice) == 0) {
		if ((dev = pcap_lookupdev(perrbuf)) == NULL) {
			snprintf(errbuf, ERRBUFSIZ - 2, "cannot find any available device to sniff on: %s\n", perrbuf);
			return -1;
		}
		strncpy(gdevice, dev, sizeof(gdevice) - 2);
	}
	if ((pd = pcap_open_live(gdevice, gsnaplen, gpromisc, greadtmt, perrbuf)) == NULL) {
		snprintf(errbuf, ERRBUFSIZ - 2, "pcap_open_live: %s\n", perrbuf);
		return -1;
	}

	pcap_lookupnet(gdevice, &netp, &maskp, perrbuf);
	in.s_addr = netp;
	strncpy(netstr, inet_ntoa(in), sizeof(netstr) - 2);
	in.s_addr = maskp;
	strncpy(maskstr, inet_ntoa(in), sizeof(netstr) - 2);

	switch(pcap_datalink(pd)) {
		case DLT_EN10MB:
			dllen = 14;
			break;
		case DLT_IEEE802:
			dllen = 22;
			break;
		case DLT_FDDI:
			dllen = 21;
			break;
		case DLT_PPP:
			dllen = 12;
			break;
		case DLT_NULL:
			dllen = 4;
			break;
	}
	misc_debug(0, "%s has been opened in  %s mode, data link: %d (%s/%s)\n", gdevice, (gpromisc ? "promisc" : "non-promisc"), dllen,netstr, maskstr);
	if (strlen(gfilter) == 0)
		strcpy(gfilter, "proto udp");
	pcap_compile(pd, &fprog, filter, 0, netp);
	pcap_setfilter(pd, &fprog);
	pcap_freecode(&fprog);
	if (pcap_setnonblock(pd, 1, perrbuf) == -1) {
		misc_debug(0, "pcap_netnonblock: %s\n", perrbuf);
		wexit(1);
	}
	return pcap_fileno(pd);
}

void
peekpcap()
{
	while (pcap_dispatch(pd, 100, packet_handler, (u_char *)dllen) != 0)
		;
}

int getdllen(pcap_t *pd) 
{
	return dllen;
}

void packet_handler(u_char *udata, const struct pcap_pkthdr *pkthdr, const u_char *packet)
{
	int offset = (int)udata;
	struct ip *ip;
	struct udphdr *udp;

	ip = (struct ip *)(packet + offset);
/*	misc_debug(4, "bir IP paketi geldi!\n"); */
	if (ip->ip_p == IPPROTO_UDP) {
		udp = (struct udphdr *)(packet + offset + sizeof(struct ip));
		if (ntohs(udp->uh_sport) < 5000 || ntohs(udp->uh_dport) < 5000)
			return;
		if (ODD(ntohs(udp->uh_sport)) && ODD(ntohs(udp->uh_dport)))
			probertcp(udata, pkthdr, packet + offset);
	}
}
