
/*
	VoIPong Voice Over IP Sniffer
	Copyright (C) 2004 Murat Balaban <murat || enderunix.org>
	All rights reserved.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <pcap.h>

#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>

#include <arpa/inet.h>
#define __USE_BSD 1
#define __FAVOR_BSD 1

#include <netinet/ip.h>
#include <netinet/udp.h>
#include <voipong.h>
#include <voipongrtcp.h>
#include <voipongrtp.h>

extern char gdevice[];

struct tsap_rtcp *list[MAXNODE];

unsigned int 
hash(u_int32_t sip, u_int32_t dip, u_int16_t sp, u_int16_t dp)
{
	return (sip + dip - sp - dp) % MAXNODE;
}

unsigned int 
has_rtcp_pair(u_int32_t sip, u_int32_t dip, u_int16_t sp, u_int16_t dp)
{

	int h;
	struct tsap_rtcp *r;

	h = hash(sip, dip, sp, dp);
	for (r = list[h]; r != NULL; r = r->next) {
		if ((sip == r->sip || sip == r->dip) && (dip == r->dip || dip == r->sip) && (sp == r->sp || sp == r->dp) && (dp == r->dp || dp == r->sp)) {
			return 1;
		}
	}
	return 0;
}
	

void
probertcp(u_char *udata, const struct pcap_pkthdr *pkthdr, const u_char *packet)
{
	rtp_session *rtp;
	struct ip *ip;
	struct udphdr *udp;
	u_char *rtcp;
	
	ip = (struct ip *)packet;
	udp = (struct udphdr *)(packet + sizeof(struct ip));
	rtcp = (u_char *)(packet + sizeof(struct ip) + sizeof(struct udphdr));

	if (rtcp[0] == 0x80 || rtcp[0] == 0x81)
		if (rtcp[1] == 0xc8 || rtcp[1] == 0xc9) {
			if ((has_rtcp_pair(ip->ip_src.s_addr, ip->ip_dst.s_addr, 
					ntohs(udp->uh_sport), ntohs(udp->uh_dport)) == 0)
					&&
				(!worker_isexist(ip->ip_src.s_addr, ip->ip_dst.s_addr, 
					htons(ntohs(udp->uh_sport) - 1), htons(ntohs(udp->uh_dport) - 1)))
					) {
				rtp = (rtp_session *)malloc(sizeof(rtp_session));
				rtp->pid = -1;
				rtp->ip1 = ip->ip_src.s_addr;
				rtp->port1 = htons(ntohs(udp->uh_sport) - 1);
				rtp->ip2 = ip->ip_dst.s_addr;
				rtp->port2 = htons(ntohs(udp->uh_dport) - 1);
				strncpy(rtp->dev, gdevice, 255);
				rtp->rate = 8000;
				rtp->size = 16;
				rtp->enc = 0;
				time(&(rtp->stime));
				worker_create(&rtp);
				return;
			}
			check_rtcp_hash(ip->ip_src.s_addr, ip->ip_dst.s_addr, 
					ntohs(udp->uh_sport), ntohs(udp->uh_dport));
		}
}






void check_rtcp_hash(u_int32_t sip, u_int32_t dip, u_int16_t sp, u_int16_t dp)
{
	int h;
	struct tsap_rtcp *r;

	h = hash(sip, dip, sp, dp);
	for (r = list[h]; r != NULL; r = r->next) {
		if ((sip == r->sip || sip == r->dip) && (dip == r->dip || dip == r->sip) && (sp == r->sp || sp == r->dp) && (dp == r->dp || dp == r->sp))
			return;
	}
	r = (struct tsap_rtcp *)malloc(sizeof(struct tsap_rtcp));
	r->sip = sip;
	r->dip = dip;
	r->sp = sp;
	r->dp = dp;
	r->next = list[h];
	list[h] = r;
}

