/*
    Interrupt Descriptor Table (IDT) Guard.
    VERSiON 1.0 - (c) December, 2005 - 

    Copyright (C) 2005 Matthieu Suiche <msuiche@gmail.com> www.msuiche.net

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 59 Temple
    Place, Suite 330, Boston, MA 02111-1307 USA
*/

typedef LONG				NTSTATUS;
typedef LARGE_INTEGER PHYSICAL_ADDRESS, *PPHYSICAL_ADDRESS; // windbgkd

#ifndef STATUS_SUCCESS
#define STATUS_SUCCESS			((NTSTATUS)0x00000000L)
#endif

#define NT_SUCCESS(Status) ((NTSTATUS)(Status) >= STATUS_SUCCESS)

#ifndef STATUS_INFO_LENGTH_MISMATCH
#define STATUS_INFO_LENGTH_MISMATCH	((NTSTATUS)0xC0000004L)
#endif

#define	SystemModuleInformation		11

#define LEN_PATH			252
#define MAX_INTERRUPTION		256

#define GATE_INTERRUPT_32 0x0E //Binary: 1110
#define GATE_INTERRUPT_16 0x06 //Binary: 0110

#define GATE_TRAP_32 0x0F //Binary: 1111
#define GATE_TRAP_16 0x07 //Binary: 0111

#define GATE_TASK_32 0x0D //Binary: 1101
#define GATE_TASK_16 0x05 //Binary: 0101

#define OBJ_CASE_INSENSITIVE    0x00000040L
#define OBJ_KERNEL_HANDLE    	0x00000200L

#define InitializeObjectAttributes( p, n, a, r, s ) { \
	(p).Length = sizeof( OBJECT_ATTRIBUTES );          \
	(p).RootDirectory = r;                             \
	(p).Attributes = a;                                \
	(p).ObjectName = n;                                \
	(p).SecurityDescriptor = s;                        \
	(p).SecurityQualityOfService = NULL;               \
    }

#define InitializeUserAccess(p, n ) {		\
	(p).grfAccessPermissions = SECTION_MAP_WRITE;				\
	(p).grfAccessMode = GRANT_ACCESS;					\
	(p).grfInheritance = NO_INHERITANCE;					\
	(p).Trustee.pMultipleTrustee = NULL;					\
	(p).Trustee.MultipleTrusteeOperation = NO_MULTIPLE_TRUSTEE;		\
	(p).Trustee.TrusteeForm = TRUSTEE_IS_NAME;				\
	(p).Trustee.TrusteeType = TRUSTEE_IS_USER;				\
	(p).Trustee.ptstrName = n;						\
    }

typedef struct _UNICODE_STRING {
    USHORT Length;
    USHORT MaximumLength;
#ifdef MIDL_PASS
    [size_is(MaximumLength / 2), length_is((Length) / 2) ] USHORT * Buffer;
#else // MIDL_PASS
    PWSTR  Buffer;
#endif // MIDL_PASS
} UNICODE_STRING;
typedef UNICODE_STRING *PUNICODE_STRING;

typedef enum _SECTION_INHERIT {
    ViewShare = 1,
    ViewUnmap = 2
} SECTION_INHERIT;

typedef struct _OBJECT_ATTRIBUTES {
    ULONG Length;
    HANDLE RootDirectory;
    PUNICODE_STRING ObjectName;
    ULONG Attributes;
    PVOID SecurityDescriptor;        // Points to type SECURITY_DESCRIPTOR
    PVOID SecurityQualityOfService;  // Points to type SECURITY_QUALITY_OF_SERVICE
} OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES *POBJECT_ATTRIBUTES;

typedef struct _KIDTRAWENTRY {
	union {
	DWORD Offset;
		struct {
		WORD OffsetLow;
		WORD OffsetHigh;
		};
	};
	BYTE Reserved;
	BYTE Type:4;
	BYTE Always0:1;
	BYTE Dpl:2;
	BYTE Present:1;
	WORD Selector;
} *PKIDTRAWENTRY, KIDTRAWENTRY;

typedef struct _KGDT {
   WORD Limit;
   DWORD Base;
} KGDT, *PKGDT;

typedef struct _KIDTENTRY {
        WORD OffsetLow;
        WORD Selector;
        BYTE Reserved;
        BYTE Type:4;
        BYTE Always0:1;
        BYTE Dpl:2;
        BYTE Present:1;
        WORD OffsetHigh;
} KIDTENTRY, *PKIDTENTRY;

typedef struct _SYSTEM_MODULE_INFORMATION {

	ULONG ModulesCount;
//SYSTEM_MODULE
	ULONG Reserved1;
	ULONG Reserved2;
	DWORD ImageBaseAddress;
	ULONG ImageSize;
	ULONG Flags;
	WORD Id;
	WORD Rank;
	WORD w018;
	WORD NameOffset;
	BYTE Name[LEN_PATH];

} SYSTEM_MODULE_INFORMATION, *PSYSTEM_MODULE_INFORMATION;

NTSTATUS  (WINAPI *NtQuerySystemInformation) (SYSTEM_INFORMATION_CLASS,PVOID,ULONG,PULONG);
NTSTATUS  (WINAPI *NtOpenSection) (PHANDLE, ACCESS_MASK, POBJECT_ATTRIBUTES);
NTSTATUS  (WINAPI *NtMapViewOfSection) (HANDLE, HANDLE, PVOID, ULONG, ULONG, PLARGE_INTEGER, PULONG, ULONG, ULONG, ULONG);
NTSTATUS  (WINAPI *NtUnmapViewOfSection) (HANDLE, PVOID);
VOID      (WINAPI *RtlInitUnicodeString) (PUNICODE_STRING, PCWSTR);
ULONG	  (WINAPI *RtlNtStatusToDosError) (NTSTATUS);
NTSTATUS  (WINAPI *NtClose)(HANDLE); 

DWORD 			GetKernelInformation(void);
DWORD	 		GetNtdllFunction(void);
HANDLE 			OpenPhysicalMemory(void);
PHYSICAL_ADDRESS	GetPhysicalAddress(ULONG vAddress);
DWORD 			GetRawInterruption(PKIDTRAWENTRY IdtRaw);
DWORD 			GetMemoryInterruption(PKIDTRAWENTRY IdtMem, DWORD VirtualAddress);
DWORD 			CompareInterruption(PKIDTRAWENTRY IdtRaw, PKIDTRAWENTRY IdtMem);
DWORD 			RestoreInterruptionByHandle(DWORD Index, PKIDTRAWENTRY IdtRaw, PKIDTRAWENTRY IdtMem, PKIDTENTRY IdtEntry);
DWORD			GetHelp(void);
DWORD 			ShowDashboard(void);
DWORD			StartUp(void);
DWORD 			UpdateAffinityMask(void);
DWORD 			CheckOsVersion(void);
DWORD			CleanUp(DWORD VirtualAddress);