/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.

Module Name:

    checksum.h

Abstract:

    - tcpxsum()

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/

#include <windows.h>
#include <winnt.h>

#ifndef _CHECKSUM_H_
#define _CHECKSUM_H_

#ifdef __cplusplus
extern "C"
{
#endif
//
//
//
#define AddCarry(a, b)     \
{                          \
    _asm mov eax, b        \
    _asm adc a, eax        \
}

#define RotateRight(a, b)   _asm ror [a], b
#define RotateRight16(a, b) _asm ror word ptr [a], b

typedef struct _CHECKSUM_BLOCK {

    ULONG u00;             // 0x00
    ULONG u04;             // 0x04
    ULONG u08;             // 0x08
    ULONG u0C;             // 0x0C
    ULONG u10;             // 0x10
    ULONG u14;             // 0x14
    ULONG u18;             // 0x18
    ULONG u1C;             // 0x1C
    ULONG u20;             // 0x20
    ULONG u24;             // 0x24
    ULONG u28;             // 0x28
    ULONG u2C;             // 0x2C
    ULONG u30;             // 0x30
    ULONG u34;             // 0x34
    ULONG u38;             // 0x38
    ULONG u3C;             // 0x3C
    ULONG u40;             // 0x40
    ULONG u44;             // 0x44
    ULONG u48;             // 0x48
    ULONG u4C;             // 0x4C
    ULONG u50;             // 0x50
    ULONG u54;             // 0x54
    ULONG u58;             // 0x58
    ULONG u5C;             // 0x5C
    ULONG u60;             // 0x60
    ULONG u64;             // 0x64
    ULONG u68;             // 0x68
    ULONG u6C;             // 0x6C
    ULONG u70;             // 0x70
    ULONG u74;             // 0x74
    ULONG u78;             // 0x78
    ULONG u7C;             // 0x7C

} CHECKSUM_DATA, *PCHECKSUM_DATA;

//
// Checksum function
//
ULONG
tcpxsum(
    USHORT AdjustWord,
    PUCHAR Buffer,
    ULONG Size
);

#ifdef __cplusplus
}
#endif

#endif