/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.

Module Name:

    compression.h

Abstract:

    - Windows hibernation compression functions definition.
    - TODO: Windows 2000.

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/
#ifndef _COMPRESSION_
#define _COMPRESSION_

#include <windows.h>
#include <stdio.h>
#include "hiber.h"

#ifdef __cplusplus
extern "C"
{
#endif

//
// xpress encoding!
//
#define XPRESS_MAGIC   "\x81\x81xpress"
#define XPRESS_ENCODE_MAGIC  0x19880922
#define DELTA_PAGE ((2 * PAGE_SIZE) - 1)
#define UNCOMPRESSED_BLOCK_SIZE (PAGE_SIZE * 0x10)

//
//
//

#define NextXpressBlock(pIXH)                                         \
{                                                                     \
    PtrToUlong(pIXH) += (ULONG)(GetXpressBlockSize( pIXH )            \
                     + (ULONG)sizeof(IMAGE_XPRESS_HEADER));           \
    while (memcmp(pIXH, XPRESS_MAGIC, 8) != 0)                        \
    {                                                                 \
         PtrToUlong(pIXH) += (ULONG)(sizeof(XPRESS_MAGIC) - 1);       \
    }                                                                 \
}

//
// Prototypes.
//

//
// XpressDecode
//
ULONG
XpressDecode(
    PUCHAR InputBuffer,
    ULONG InputSize, 
    PUCHAR OutputBuffer, 
    ULONG OutputSize
);

//
// XpressEncode
//
ULONG
XpressEncode(
    PUCHAR InputBuffer, 
    ULONG InputSize, 
    PUCHAR OutputBuffer, 
    ULONG OutputSize
);

ULONG
GetXpressBlockSize(
    PIMAGE_XPRESS_HEADER CompressedBlockHeader
);

VOID
SetXpressBlockSize(
   PIMAGE_XPRESS_HEADER pIXH, 
   ULONG Size
);
#ifdef __cplusplus
}
#endif

#endif