/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.



Module Name:

    internals.h

Abstract:

    - Some definition used by library-side.

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/

//
// Structs
//
__declspec(align(1)) 
typedef struct _KGDTENTRY
{
    USHORT LimitLow;
    USHORT BaseLow;
    UCHAR BaseMid;
    UCHAR Reserved05;
    UCHAR Reserved06;
    UCHAR BaseHigh;
} KGDTENTRY, *PKGDTENTRY;

typedef struct _PEB
{
    UCHAR Reserved00[0xA4];
    ULONG OSMajorVersion;
    ULONG OSMinorVersion;
    USHORT OSBuildNumber;
} PEB, *PPEB; 
