/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.

Module Name:

    mm.h

Abstract:

    - TODO: Update PDE/PTE structure 4/8bytes.

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/

#ifndef _MM_
#define _MM_

#include <windows.h>
#include "sandman.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct _PAGE_ENTRY {
    ULONG Flags:12;
    ULONG PageFrameNumber:24;
    ULONG Reserved:28;
} PAGE_ENTRY, *PPAGE_ENTRY;

typedef struct _VIRTUAL_ADDRESS_PAE_4MB {
    union
    {
        ULONG u;
        struct
        {
            ULONG PageOffset:21;
            ULONG PageDirectoryEntry:9;
            ULONG PageDirectoryPointerTable:2;
        };
    };
} VIRTUAL_ADDRESS_PAE_4MB, *PVIRTUAL_ADDRESS_PAE_4MB;

typedef struct _VIRTUAL_ADDRESS_PAE_4KB {
    union
    {
        ULONG u;
        struct
        {
            ULONG PageOffset:12;
            ULONG PageTableEntry:9;
            ULONG PageDirectoryEntry:9;
            ULONG PageDirectoryPointerTable:2;
        };
    };
} VIRTUAL_ADDRESS_PAE_4KB, *PVIRTUAL_ADDRESS_PAE_4KB;

typedef struct _VIRTUAL_ADDRESS_4MB {
    union
    {
        ULONG u;
        struct
        {
            ULONG PageOffset:22;
            ULONG PageDirectoryEntry:10;
        };
    };
} VIRTUAL_ADDRESS_4MB, *PVIRTUAL_ADDRESS_4MB;

typedef struct _VIRTUAL_ADDRESS_4KB {
    union
    {
        ULONG u;
        struct
        {
            ULONG PageOffset:12;
            ULONG PageTableEntry:10;
            ULONG PageDirectoryEntry:10;
        };
    };
} VIRTUAL_ADDRESS_4KB, *PVIRTUAL_ADDRESS_4KB;

typedef struct _HARDWARE_PTE
{
     union
     {
          ULONG u;
          struct
          {
              ULONG Valid: 1;
              ULONG Write: 1;
              ULONG Owner: 1;
              ULONG WriteThrough: 1;
              ULONG CacheDisable: 1;
              ULONG Accessed: 1;
              ULONG Dirty: 1;
              ULONG LargePage: 1;
              ULONG Global: 1;
              ULONG CopyOnWrite: 1;
              ULONG Prototype: 1;
              ULONG reserved0: 1;
              ULONG PageFrameNumber: 10;
            };
     };
} HARDWARE_PTE, *PHARDWARE_PTE;

ULONG 
FastGetPhysicalAddress(
    ULONG BaseAddress
);

PHYSICAL_ADDRESS 
MmGetPhysicalAddress(
    PSANDMAN_OBJECT Hiberfil,
    ULONG BaseAddress
);

//
// Macros
//
#define GetPage(x) ((((x.HighPart << 20) >> 20) << 12) | (x.LowPart >> 12))

#define MAKE_PHYS_ADDR(x, low, high)                                  \
{                                                                     \
    x.LowPart = low;                                                  \
    x.HighPart = high;                                                \
}
#ifdef __cplusplus
}
#endif

#endif