/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.

Module Name:

    sandman.h

Abstract:

    - Sandman public API header

Environment:

    - User mode

Revision History:

    - 06-23-2008: Update compression functions.
    - Matthieu Suiche, Nicolas Ruff

--*/
#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "hiber.h"
#ifndef _SANDMAN_
#define _SANDMAN_

#ifdef __cplusplus
extern "C"
{
#endif

//
// Definitions
//
#define SANDMAN_AUTHOR  "Matthieu Suiche && Nicolas Ruff"
#define SANDMAN_VERSION "1.1.20080804 - blackhat release"
#define SANDMAN_WEB     "http://sandman.msuiche.net"

//#undef VISTA_TARGET
#define VISTA_TARGET

#undef _PYTHON_BUILD_
//#define _PYTHON_BUILD_

//
// Structures
//
typedef struct _SANDMAN_TREE {
    ULONG PageNumber;                       // Page number in physical memory.
    PIMAGE_XPRESS_HEADER ImgXpressHeader;   // Pointer to \x81\x81xpress
    ULONG XpressPage;                       // [0-15]
} SANDMAN_TREE, *PSANDMAN_TREE;

typedef struct _SANDMAN_OBJECT {
    UCHAR  FileName[ MAX_PATH ];        // Hibernation file filename
    HANDLE hFile;                       // File handle to opened file
    HANDLE hMap;                        // Mapping handle to opened file
    PUCHAR Map;                         // Mapping of opened file
    PIMAGE_HIBER_HEADER FileHdr;        // Alias to file header (file offset 0)
    PULONG FreePages;                   // TODO
    PKPROCESSOR_STATE32 ProcState;      // Alias to processor state
    PMEMORY_RANGE_ARRAY MemArray;       // Alias to 1st element in Memory Array list
    PSANDMAN_TREE PagesListHead;        // Alias to page memory.
    ULONG TotalListEntries;             // Linked to PagesListHead
    ULONG MemRangesCount;               // Stats
    ULONG HighestPage;                  // Used for size.
} SANDMAN_OBJECT, *PSANDMAN_OBJECT;

typedef LARGE_INTEGER PHYSICAL_ADDRESS, *PPHYSICAL_ADDRESS;

//
// Public API
//

PSANDMAN_OBJECT HiberOpen(
    UCHAR FileName[]
);

VOID HiberClose(
    PSANDMAN_OBJECT SandmanObject
);

ULONG HiberCreateFile(
    PUCHAR FileName,
    ULONG Size
);

ULONG
HiberGetPhysicalMemorySize(
    PSANDMAN_OBJECT Hiberfile
);

BOOLEAN
HiberPatch(
   PSANDMAN_OBJECT Hiberfil,
   PHYSICAL_ADDRESS PhysicalAddress,
   PUCHAR BytesArray,
   ULONG SizeOfBytesArray
);

ULONG
HiberBuildPhysicalMemoryDump(
     PSANDMAN_OBJECT Hiberfil,
     UCHAR DumpFileName[]
);

ULONG
HiberReadFileHeader(
    PSANDMAN_OBJECT Hiberfil,
    PIMAGE_HIBER_HEADER32 HiberHeader
);

ULONG
HiberWriteFileHeader(
     PSANDMAN_OBJECT Hiberfil,
     PIMAGE_HIBER_HEADER32 HiberHeader
);

ULONG
HiberReadProcState(
    PSANDMAN_OBJECT Hiberfil,
    PKPROCESSOR_STATE32 ProcessorState
);

ULONG
HiberWriteProcState(
    PSANDMAN_OBJECT Hiberfil,
    PKPROCESSOR_STATE32 ProcessorState
);

ULONG
HiberGetVersion(
    PSANDMAN_OBJECT Hiberfil
);


PSANDMAN_TREE
HiberGetPageFirst(
    PSANDMAN_OBJECT Hiberfil 
);

PSANDMAN_TREE
HiberGetPageNext(
    PSANDMAN_TREE PagesList
);


BOOLEAN 
HiberIsPagePresent(
    PSANDMAN_OBJECT Hiberfil,
    PHYSICAL_ADDRESS PhysicalAddress
);

PUCHAR
HiberGetPageAt(
    PSANDMAN_OBJECT Hiberfil,
    PHYSICAL_ADDRESS PhysicalAddress
);

ULONG
HiberCountMemoryRanges(
    PSANDMAN_OBJECT Hiberfil
);

PSANDMAN_TREE HiberCreateTree(
    PSANDMAN_OBJECT Hiberfil
);

ULONG
HiberDestroyTree(
    PSANDMAN_OBJECT pHiberfil
);

BOOLEAN
HiberPageReplace(
    PSANDMAN_OBJECT Hiberfil,
    PHYSICAL_ADDRESS PhysicalAddress,
    PUCHAR Source
);

BOOLEAN
HiberPageRemove(
    PSANDMAN_OBJECT Hiberfil,
    PHYSICAL_ADDRESS PhysicalAddress
);

ULONG
HiberFreePage(
    PUCHAR Page
);

PUCHAR
HiberGetPageAtVirtualAddress(
     PSANDMAN_OBJECT Hiberfil,
     ULONG VirtualAddress
);

PHYSICAL_ADDRESS 
HiberGetPhysicalAddress(
    PSANDMAN_OBJECT Hiberfil,
    ULONG BaseAddress
);


PUCHAR
HiberGetFastPageAtVirtualAddress
    (PSANDMAN_OBJECT Hiberfil,
    ULONG VirtualAddress
);
#ifdef __cplusplus
}
#endif

#endif