/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.

Module Name:

    checksum.c

Abstract:

    - tcpxsum function.

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/

#include "checksum.h"

/*++
Function Name: tcpxsum

Overview:

Parameters:
         - USHORT  AdjustWord
         - PCHAR Buffer
         - ULONG Size

Return Values:

--*/
ULONG
tcpxsum(USHORT AdjustWord,
        PUCHAR Buffer,
        ULONG Size
        )

{
ULONG Checksum, Lenght, Result, Case;
PUCHAR Pointer;
PCHECKSUM_DATA Data;

        if(Size <= 0) return FALSE;

        Lenght = Size;
        Pointer = Buffer;
        Result = 0;
        Checksum = 0;

        if (1 & PtrToUlong(Buffer))
        {
            (UCHAR)Checksum = *Pointer;
            Checksum <<= 8;
            Pointer++;
            Lenght--;
        }

        Lenght >>= 1;
        if (Lenght >= 0) 
        {
            (UCHAR)Checksum = *(PUCHAR)(Pointer+Lenght*2);
        }

        if (2 & PtrToUlong(Buffer))
        {
            Result = *(PUSHORT)(Pointer);
            Pointer += sizeof(USHORT);
            Checksum += Result;
            Lenght--;
        }

        Lenght >>= 1;

        if (Lenght > 1)
        {

            Data = (PCHECKSUM_DATA)Pointer;
            Result = Data->u00;
            (PUCHAR)Data += sizeof(ULONG);

            Lenght--;

            Case = Lenght & 0x1F;
            Lenght = (Lenght + 0x1F) >> 5;

            if (Case) (PUCHAR)Data += (Case*sizeof(ULONG)-sizeof(CHECKSUM_DATA));

            while (Lenght)
            {
                switch (Case)
                {
                    case 0:
                        AddCarry(Checksum, Result)
                        Result = Data->u00;

                    case 32:
                        AddCarry(Checksum, Result)
                        Result = Data->u04;

                    case 31:
                        AddCarry(Checksum, Result)
                        Result = Data->u08;

                    case 30:
                        AddCarry(Checksum, Result)
                        Result = Data->u0C;

                    case 29: 
                        AddCarry(Checksum, Result)
                        Result = Data->u10;

                    case 28:
                        AddCarry(Checksum, Result)
                        Result = Data->u14;

                    case 26:
                        AddCarry(Checksum, Result)
                        Result = Data->u18;

                    case 25:
                        AddCarry(Checksum, Result)
                        Result = Data->u1C;

                    case 24:
                        AddCarry(Checksum, Result)
                        Result = Data->u20;

                    case 23:
                        AddCarry(Checksum, Result)
                        Result = Data->u24;

                    case 22:
                        AddCarry(Checksum, Result)
                        Result = Data->u28;

                    case 21:
                        AddCarry(Checksum, Result)
                        Result = Data->u2C;

                    case 20:
                        AddCarry(Checksum, Result)
                        Result = Data->u30;

                    case 19:
                        AddCarry(Checksum, Result)
                        Result = Data->u34;

                    case 18:
                        AddCarry(Checksum, Result)
                        Result = Data->u38;

                    case 17:
                        AddCarry(Checksum, Result)
                        Result = Data->u3C;

                    case 16:
                        AddCarry(Checksum, Result)
                        Result = Data->u40;

                    case 15:
                        AddCarry(Checksum, Result)
                        Result = Data->u44;

                    case 14:
                        AddCarry(Checksum, Result)
                        Result = Data->u48;

                    case 13:
                        AddCarry(Checksum, Result)
                        Result = Data->u4C;

                    case 12:
                        AddCarry(Checksum, Result)
                        Result = Data->u50;

                    case 11:
                        AddCarry(Checksum, Result)
                        Result = Data->u54;

                    case 10:
                        AddCarry(Checksum, Result)
                        Result = Data->u58;

                    case 9:
                        AddCarry(Checksum, Result)
                        Result = Data->u5C;

                    case 8:
                        AddCarry(Checksum, Result)
                        Result = Data->u60;

                    case 7:
                        AddCarry(Checksum, Result)
                        Result = Data->u64;

                    case 6:
                        AddCarry(Checksum, Result)
                        Result = Data->u68;

                    case 5:
                        AddCarry(Checksum, Result)
                        Result = Data->u6C;

                    case 4:
                        AddCarry(Checksum, Result)
                        Result = Data->u70;

                    case 3:
                        AddCarry(Checksum, Result)
                        Result = Data->u74;

                    case 2:
                        AddCarry(Checksum, Result)
                        Result = Data->u78;

                    case 1:
                        AddCarry(Checksum, Result)
                        Result = Data->u7C;
                        Data++;
                }
                Lenght--;
                Case = 0;
           }
            AddCarry(Checksum, Result)
            Result = 0;
            AddCarry(Checksum, Result)
        }

        if ((Size >> 1) & 1)
        {
            Checksum += (USHORT)(Data->u00);
            AddCarry(Checksum, 0);
        }

        Lenght = Checksum;
        RotateRight(Lenght, 16)
        Checksum = (Checksum + Lenght) >> 16;

        if (PtrToUlong(Buffer) & 1) RotateRight16(Checksum, 8)

        Checksum += AdjustWord;
        AddCarry(Checksum, 0)

        //
        // Return checksum.
        //
        return (Checksum-2);
}
