/*++
SandMan framework.
Copyright 2008 (c) Matthieu Suiche. <msuiche[at]gmail.com>

This file is part of SandMan.

SandMan is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

SandMan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SandMan.  If not, see <http://www.gnu.org/licenses/>.

Module Name:

    mm.c

Abstract:

    - 

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/

/*++
Function Name: FastGetPhysicalAddress

Overview:

Parameters:
         -

Return Values:
         - 

--*/

#include "sandman.h"
#include "mm.h"

/*++
Function Name: FastGetPhysicalAddress

Overview:

Parameters:
         - ULONG BaseAddress

Return Values:

--*/
ULONG FastGetPhysicalAddress (ULONG BaseAddress
                              )
{
   if (BaseAddress > 0x80000000 || BaseAddress < 0xA0000000)
   {
      return (BaseAddress & 0x1FFFF000);
   }
   return FALSE;
}

/*++
Function Name: MmGetPhysicalAddress

Overview: 

Parameters:
            - PSANDMAN_OBJECT Hiberfil
            - ULONG BaseAddress

Return Values:

--*/
PHYSICAL_ADDRESS MmGetPhysicalAddress (PSANDMAN_OBJECT Hiberfil,
                                       ULONG BaseAddress)
{
ULONG ulPpde, ulPde, ulPte, ulData;

VIRTUAL_ADDRESS_4KB va4Kb;
VIRTUAL_ADDRESS_PAE_4KB va4KbPae;

VIRTUAL_ADDRESS_4MB va4Mb;
VIRTUAL_ADDRESS_PAE_4MB va4MbPae;

PUCHAR pPpde, pPde, pPte;

ULONG PAE;
ULONG Cr3;

PHYSICAL_ADDRESS Phys;

HARDWARE_PTE hPde;

    Cr3 = Hiberfil->ProcState->SpecialRegisters.Cr3;
    PAE = Hiberfil->ProcState->SpecialRegisters.u_cr4.PhysicalAddressExtension;

    if (PAE)
    {
        //
        // PAE is Enabled.
        //
        va4KbPae.u = BaseAddress;
		printf("VA: 0x%08X\n", BaseAddress);
        //
        // Pointer to page directory entry.
        //
        ulPpde = Cr3;
        ulPpde += va4KbPae.PageDirectoryPointerTable * sizeof(HARDWARE_PTE);
        MAKE_PHYS_ADDR(Phys, ulPpde, 0);
		printf("ulPpde: [%08X] = ", ulPpde);
        pPpde = HiberGetPageAt(Hiberfil, Phys);
        ulPpde = *(PULONG)(pPpde);
        HiberFreePage(pPpde);
		printf("0x%08X\n", ulPpde);

        //
        // Page directory entry.
        //
        ulPde = ((ulPpde >> 12) * PAGE_SIZE);
        ulPde += (va4KbPae.PageDirectoryEntry * sizeof(HARDWARE_PTE));

        MAKE_PHYS_ADDR(Phys, ulPde, 0);

		printf("pPde: [%08X] = ", ulPde);
        pPde = HiberGetPageAt(Hiberfil, Phys);
        ulPde = *(PULONG)(pPde);
        HiberFreePage(pPde);
		printf("0x%p\n",pPde);

        //
        // Large Page or Not?
        //
        hPde.u = ulPde;
        if (hPde.LargePage == 0)
        {
			printf("* PAE *\n");
            //
            // 4Kbytes page.
            //
			printf("4Kb\n");
            //
            // Page table entry.
            //
            ulPte = ((ulPde >> 12) * PAGE_SIZE);
            ulPte += va4KbPae.PageTableEntry * sizeof(HARDWARE_PTE);

            MAKE_PHYS_ADDR(Phys, ulPte, 0);
			printf("ulPte: [%08X] = ", ulPte);
            pPte = HiberGetPageAt(Hiberfil, Phys);
            ulPte = *(PULONG)(pPte);
            HiberFreePage(pPte);
			printf("0x%08X\n", ulPte);
            
            //
            // Offset data.
            //
            ulData = ((ulPte >> 12) * PAGE_SIZE) + va4KbPae.PageOffset;
            printf("va4KbPae.PageOffset: 0x%08X\n", va4KbPae.PageOffset);

            MAKE_PHYS_ADDR(Phys, ulData, 0);
        }
        else
        {
            //
            // 4Mbytes page.
            //
            va4MbPae.u = BaseAddress;

            //
            // Data
            //
            ulData = ((ulPde >> 21) * PAGE_SIZE);
            ulData += va4MbPae.PageOffset;

            MAKE_PHYS_ADDR(Phys, ulData, 0);

        }

    }
    else
    {
        //
        // PAE isn't Enabled.
        //
        va4Kb.u = BaseAddress;

        //
        // Page directory entry
        //
        ulPde = Cr3;
        ulPde += va4Kb.PageDirectoryEntry * sizeof(ULONG);
        MAKE_PHYS_ADDR(Phys, ulPde, 0);

        pPde = HiberGetPageAt(Hiberfil, Phys);
        ulPde = *(PULONG)(pPde);
        HiberFreePage(pPde);

        //
        // Large Page or Not?
        //
        hPde.u = ulPde;
        if (hPde.LargePage == 0)
        {
            
        printf("* NOPAE 4kb\n");
            //
            // 4Kbytes page.
            //

            //
            // Page table entry
            //
            
            ulPte = ((ulPde >> 12) * PAGE_SIZE);
            ulPte += va4Kb.PageTableEntry * sizeof(ULONG);
            MAKE_PHYS_ADDR(Phys, ulPte, 0);

            pPte = HiberGetPageAt(Hiberfil, Phys);
            ulPte = *(PULONG)(pPte);
            HiberFreePage(pPte);

            //
            // Data
            //
            ulData = ((ulPte >> 12) * PAGE_SIZE) + va4Kb.PageOffset;
            MAKE_PHYS_ADDR(Phys, ulData, 0);
        }
        else
        {
            
        printf("* NOPAE 4Mb\n");
            //
            // 4Mbytes page.
            //
            va4Mb.u = BaseAddress;

            //
            // Data
            ulData = ulPde & 0xFFC00000;
            ulData += BaseAddress & 0x003FFFFF;
            MAKE_PHYS_ADDR(Phys, ulData, 0);
        }

    }
    return Phys;
}