/*++
    Copyright (C) 2009  Matthieu Suiche http://www.msuiche.net

Environment:

    - User mode

Revision History:

    - Matthieu Suiche

--*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

typedef enum _SYSTEM_INFORMATION_CLASS
{
    // NtQueryEx
    SystemLogicalProcessorAndGroupInformation = 107,
    SystemLogicalGroupInformation = 108,

    SystemStoreInformation = 109,
    SystemVhdBootInformation = 112,
    SystemCpuQuotaInformation = 113,

    // Removed in build 7100
    SystemHardwareCountersInformation = 115, //115

    SystemLowPriorityInformation = 116,
    SystemTpmBootEntropyInformation = 117,
    SystemVerifierInformation = 118,

    // NtQueryEx
    SystemNumaNodesInformation = 121,
    //
    // Added in build 7100
    //
    SystemHalInformation = 122, // 8 bytes size
    SystemCommittedMemoryInformation = 123, 
    MaxSystemInfoClass = 124
} SYSTEM_INFORMATION_CLASS, *PSYSTEM_INFORMATION_CLASS;

typedef struct _COMMITTED_MEMORY_INFORMATION
{
    ULONG MmAvailablePages;
    ULONG MmTotalCommittedPages;
    ULONG MmTotalCommitLimit;
    ULONG MmPeakCommitment;
} COMMITTED_MEMORY_INFORMATION, *PCOMMITTED_MEMORY_INFORMATION;

#define STATUS_SUCCESS 0

NTSTATUS (WINAPI *NtQuerySystemInformation)(SYSTEM_INFORMATION_CLASS SystemInformationClass,
                                            PVOID SystemInformation,
                                            ULONG SystemInformationLength,
                                            PULONG ReturnLength);

int main(int argc, char **argv)
{
COMMITTED_MEMORY_INFORMATION CommittedMemoryInformation;

ULONG ReturnedLength;
ULONG NtStatus;

OSVERSIONINFO VerInfo;

    wprintf(L"\n"
                L"  CommittedMemoryInformation v0.1 - .\n"
                L"  Copyright (c) 2007 - 2009, Matthieu Suiche <http://www.msuiche.net>\n"
                L"  Copyright (c) 2009, MoonSols <http://www.moonsols.com>\n"
                L"\n");

    ZeroMemory(&VerInfo, sizeof(OSVERSIONINFO));
    VerInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

    GetVersionEx(&VerInfo);

    if (!((VerInfo.dwMajorVersion >= 6) && (VerInfo.dwMinorVersion >= 1) && (VerInfo.dwBuildNumber >= 7100)))
    {
        wprintf(L"The system does not meet the requirements. Windows 7 (build 7100) or later is required.\n");
    }

    *(FARPROC *)&NtQuerySystemInformation = GetProcAddress(LoadLibraryA("ntdll.dll"), "NtQuerySystemInformation");


    memset(&CommittedMemoryInformation, 0, sizeof(CommittedMemoryInformation));

    NtStatus = NtQuerySystemInformation(SystemCommittedMemoryInformation,
                                        &CommittedMemoryInformation,
                                        sizeof(CommittedMemoryInformation),
                                        &ReturnedLength);

    if (NtStatus == STATUS_SUCCESS)
    {
        wprintf(L"SystemCommittedMemoryInformation class:\n");
        wprintf(L"  MmAvailablePages: 0x%08X\n"
                L"  MmTotalCommittedPages: 0x%08X\n"
                L"  MmTotalCommitLimit: 0x%08X\n"
                L"  MmPeakCommitment: 0x%08X\n",
                CommittedMemoryInformation.MmAvailablePages,
                CommittedMemoryInformation.MmTotalCommittedPages,
                CommittedMemoryInformation.MmTotalCommitLimit,
                CommittedMemoryInformation.MmPeakCommitment);
    }
    else
    {
        wprintf(L"Error: NtQuerySystemInformation call failed.\n");
    }

    return TRUE;
}
