/*
 * this file isn't original includes.h from ssh package
 * unnecessary/network/etc parts removed!
 */

/*

includes.h

Author: Tatu Ylonen <ylo@cs.hut.fi>

Copyright (c) 1995 Tatu Ylonen <ylo@cs.hut.fi>, Espoo, Finland
                   All rights reserved

Created: Thu Mar 23 16:29:37 1995 ylo

This file includes most of the needed system headers.

*/

#ifndef INCLUDES_H
#define INCLUDES_H

/* Note: autoconf documentation tells to use the <...> syntax and have -I. */
#include <config.h>

typedef unsigned short word16;

#if SIZEOF_LONG == 4
typedef unsigned long word32;
#else
#if SIZEOF_INT == 4
typedef unsigned int word32;
#else
#if SIZEOF_SHORT >= 4
typedef unsigned short word32;
#else
YOU_LOSE
#endif
#endif
#endif

#if defined(SCO) && !defined(SCO5)
/* this is defined so that winsize gets ifdef'd in termio.h */
#define _IBCS2
#endif

#if defined(__mips)
/* Mach3 on MIPS defines conflicting garbage. */
#define uint32 hidden_uint32
#endif /* __mips */
#include <sys/types.h>
#if defined(__mips)
#undef uint32
#endif /* __mips */

#ifdef HAVE_MACHINE_ENDIAN_H
#include <sys/param.h>
#include <machine/endian.h>
#endif

#if defined(linux)
#include <endian.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <assert.h>
#include <signal.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#else /* STDC_HEADERS */
/* stdarg.h is present almost everywhere, and comes with gcc; I am too lazy
   to make things work with both it and varargs. */
#include <stdarg.h>
#ifndef HAVE_STRCHR
#define strchr index
#define strrchr rindex
#endif
char *strchr(), *strrchr();
#ifndef HAVE_MEMCPY
#define memcpy(d, s, n) bcopy((s), (d), (n))
#define memmove(d, s, n) bcopy((s), (d), (n))
#define memset(d, ch, n) bzero((d), (n)) /* We only memset to 0. */
#define memcmp(a, b, n) bcmp((a), (b), (n))
#endif
#endif /* STDC_HEADERS */

#include <pwd.h>
#include <grp.h>
#ifdef HAVE_GETSPNAM
#include <shadow.h>
#endif /* HAVE_GETSPNAM */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef TIME_WITH_SYS_TIME
#ifndef SCO
/* I excluded <sys/time.h> to avoid redefinition of timeval 
   which SCO puts in both <sys/select.h> and <sys/time.h> */
#include <sys/time.h>
#endif /* SCO */
#include <time.h>
#else /* TIME_WITH_SYS_TIME */
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else /* HAVE_SYS_TIME_H */
#include <time.h>
#endif /* HAVE_SYS_TIME_H */
#endif /* TIME_WITH_SYS_TIME */

#if HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#endif /* INCLUDES_H */
