/*
lps modified for windows
The ADM Crew 

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "ip.h"
#include "tcp.h"
#include <netdb.h>
#include <sys/ioctl.h>
#include <string.h>
#include <arpa/inet.h>

#define MY_PORT 47850
#define TIMEOUT_COUNT 600
#define USLEEP_VALUE 5000

struct pseudohdr {
	unsigned long saddr;
	unsigned long daddr;
	char useless;
	unsigned char protocol;
	unsigned short leng;
};

char *progname;
u_char *iplist_ptr;
int iplist_count = 0;

void usage() {
	printf("usage: %s yourIP port\n", progname);
	exit(0);
}

int addIP(u_char *ip) {
	u_char *tmp;

	if (iplist_count == 0) {
		iplist_count++;
		iplist_ptr = (char *)malloc(iplist_count * 4);
		memcpy(iplist_ptr, ip, 4);
		return(1);
	}

	tmp = iplist_ptr;
	while (tmp < (iplist_ptr + (iplist_count * 4))) {
		if (*(u_long *)ip == *(u_long *)tmp) return(0);
		tmp += 4;
	}

	iplist_count++;
	iplist_ptr = (char *)realloc(iplist_ptr, iplist_count * 4);
	memcpy(iplist_ptr + ((iplist_count * 4) - 4), ip, 4);

	return(1);
}

unsigned short in_cksum(addr, len)
u_short *addr;
int len;
{
	register int nleft = len;
	register u_short *w = addr;
	register int sum = 0;
	u_short answer = 0;

	while (nleft > 1) {
		sum += *w++;
		nleft -= 2;
	}

	if (nleft == 1) {
		*(u_char *)(&answer) = *(u_char *)w ;
		sum += answer;
	}

	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);
	answer = ~sum;
	return(answer);
}

void send_pkt(s, s_ip, d_ip, s_port, d_port, flags, seq_num, ack_num,
	      winsize, data, data_size)
int s;
unsigned long s_ip;
unsigned long d_ip;
unsigned int s_port;
unsigned int d_port;
unsigned char flags;
unsigned long seq_num;
unsigned long ack_num;
unsigned int winsize;
unsigned char *data;
unsigned int data_size;
{
	struct sockaddr_in sin_dst;
	struct iphdr *ip;
	struct tcphdr *tcp;
	struct pseudohdr *pseudo;
	unsigned char *DATA;
	unsigned char packet[2048];

	ip = (struct iphdr *)packet;
	pseudo = (struct pseudohdr *)(packet + sizeof(struct iphdr)
		- sizeof(struct pseudohdr));
	tcp = (struct tcphdr *)(packet + sizeof(struct iphdr));
	DATA = (unsigned char *)(packet + sizeof(struct iphdr)
		+ sizeof(struct tcphdr));

	memset(packet, 0, 2048);
	memcpy(DATA, data, data_size);

	pseudo->saddr = s_ip;
	pseudo->daddr = d_ip;
	pseudo->useless = 0;
	pseudo->protocol = 6;
	pseudo->leng = htons(sizeof(struct tcphdr) + data_size);
	
	tcp->th_sport = htons(s_port);
	tcp->th_seq = htonl(seq_num);
	tcp->th_ack = htonl(ack_num);
	tcp->th_off = 5;
	tcp->th_flags = flags;
	tcp->th_win = htons(winsize);

	tcp->th_urp=0;
	tcp->th_dport = htons(d_port);
	tcp->th_sum = 0;
	tcp->th_sum = in_cksum(pseudo, sizeof(struct tcphdr)
			       + sizeof(struct pseudohdr) + data_size);

	memset(packet, 0, sizeof(struct iphdr));

	ip->saddr = s_ip;
	ip->daddr = d_ip;
	ip->version = 4;
	ip->ihl = 5;
	ip->ttl = 245;
	ip->protocol = 6;
	ip->tot_len = htons(sizeof(struct iphdr)
			+ sizeof(struct tcphdr) + data_size);
	ip->tos = 0;
	ip->id = random() % 1256;
	ip->off = 0;
	ip->check = 0;
	ip->check = in_cksum(packet, sizeof(struct iphdr));

	sin_dst.sin_addr.s_addr = ip->daddr;
	sin_dst.sin_family = AF_INET;

	sendto(s, packet, sizeof(struct iphdr) + sizeof(struct tcphdr)
		+ data_size, 0, (struct sockaddr *)&sin_dst,
		sizeof(struct sockaddr));
}

int get_pkt(int s, unsigned char *data, int size) {
	struct sockaddr_in sin;
	int res, len = sizeof(sin);

	res = recvfrom(s, data, size, 0, (struct sockaddr *)&sin, &len);
	return res;
}

int main(int argc, char **argv) {
	int n, s, sr, timeout = 0, on = 1;
	unsigned char data[400];
	unsigned long myip, yerip;
	unsigned short port;
	struct tcphdr *tcp;
	struct iphdr *ip;
	struct hostent *hp;
	char buf[256];
	unsigned long seq = htonl(getpid());
	unsigned long ack = htonl(0x1000000) + seq;
	struct in_addr in;

	progname = argv[0];
	for (n = strlen(argv[0]); n >= 0; n--)
		if (argv[0][n] == '/') {
			progname += n + 1;
			break;
	}

	if (argc != 3) usage();

	if ((myip = inet_addr(argv[1])) != -1) {
		if (myip == 0) usage();
	} else {
		if ((hp = gethostbyname(argv[1])) == NULL)
			usage();
		memcpy(&myip, hp->h_addr_list[0],
			sizeof(unsigned long));
	}

	port = atoi(argv[2]);

	if ((sr = socket(AF_INET, SOCK_RAW, IPPROTO_TCP)) == -1) {
		perror("socket");
		exit(0);
	}

	if (ioctl(sr, FIONBIO, &on) == -1) {
		perror("ioctl");
		exit(0);
	}

	if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1) {
		perror("socket");
		exit(0);
	}

	if (ioctl(sr, FIONBIO, &on) == -1) {
		perror("ioctl");
		exit(0);
	}

#ifdef IP_HDRINCL
	if(setsockopt(s, IPPROTO_IP, IP_HDRINCL,
	   (char *)&on, sizeof(on)) == -1) {
		perror("setsockopt");
		exit(0);
	}
#endif

	tcp = (struct tcphdr *)(data + sizeof(struct iphdr));
	ip = (struct iphdr *)data;

	while (timeout < TIMEOUT_COUNT) {
		usleep(USLEEP_VALUE);
		timeout++;

		lewp:
		if (fgets(buf, sizeof(buf), stdin)) {
			for (n = 0; n < strlen(buf); n++)
				if (buf[n] == '\n')
					buf[n] = 0;
			if ((yerip = inet_addr(buf)) != -1) {
				if (yerip == 0) goto lewp;
			} else {
				if ((hp = gethostbyname(buf)) == NULL)
					goto lewp;
				memcpy(&yerip, hp->h_addr_list[0],
					sizeof(unsigned long));
			}
			send_pkt(s, myip, yerip, MY_PORT, port,
				TH_FIN, seq, 0, 512, NULL, 0);
			timeout = 0;
		}

		if (get_pkt(sr, data, 398) > 0) {
			if ((tcp->th_dport == htons(MY_PORT))
			&& (tcp->th_sport == htons(port))
			&& (ip->daddr == myip)
			&& (tcp->th_flags & TH_RST)
			&& (tcp->th_ack == htonl(ack))) {
				in.s_addr = ip->saddr;
				if (addIP((u_char *)&ip->saddr))
					printf("%s\n",
						inet_ntoa(in));
				fflush(stdout);
				timeout = 0;
			}
		}
	}

	close(s);
	close(sr);

	return(1);
}
