#!/usr/bin/python

from Sym import *

import os
import string
import re

readelf_binary = "/usr/bin/readelf"
readelf_opt = " -a "
re_entry = re.compile("[ \t]*Entry point address:[ \t]*([0-9xa-fA-F]*)$")
readelf_regexp2 = re.compile("[^:]*?: ([0-9a-fA-F]{8}) +([a-fA-F0-9]+) [^ ]+ +(?:.+? ){2} +([0-9]+?) (.+)")
readelf_regexp3 = re.compile("  \[[^0-9]*([0-9]+)\] ([^ \t]+)[ \t]+([^ \t]+)[ \t]+([0-9a-fA-F]{8})[ \t]([0-9a-fA-F]{6})[ \t]([0-9a-fA-F]{6}).{15}")

class Shdr:
	def __init__(self, name, offset, size, addr):
		self.name = name
		self.offset = offset
		self.size = size
		self.addr = addr


def shdrs_offset2address(offset, shdrs):
	for k in shdrs.keys():
		s = shdrs[k]
		saddr = string.atoi("0x" + s.addr, 16)
		if saddr == 0:
			continue
		soffset = string.atoi("0x" + s.offset, 16)
		ssize = string.atoi("0x" + s.size, 16)
		if offset >= soffset:
			if offset < soffset + ssize:
				addr = saddr + offset - soffset
				return addr
	return 0

class Binary2:
#
# @p_filename
# @p_entry
# @p_shdrtable = {}
#
#
	def __init__(self, filename="a.out"):
		self.p_filename = filename
		self.p_shdrtable = {}
		self.p_symbols = {}
#		self.p_entry

		c = readelf_binary + readelf_opt + filename
		f = os.popen(c, "r")
		if not f:
			return
		for line in f.readlines():
			m = re_entry.match(line)
			if m:
				self.p_entry = "0x%08x" % (string.atoi(m.group(1), 16))
				continue
			m = readelf_regexp3.match(line)
			if m:
				index = m.group(1)
				name = m.group(2)
				type = m.group(3)
				addr = m.group(4)
				offset = m.group(5)
				size = m.group(6)
				if name == ".text":
					text_offset = string.atoi("0x" + offset, 16)

				self.p_shdrtable[index] = Shdr(name, offset, size, addr)
				continue
			m = readelf_regexp2.match(line)
			if m:
				foffset = string.atoi("0x0" + m.group(1), 16)
				size10 = string.atoi(m.group(2))
				index = m.group(3)
				tname = m.group(4)
				shdr = self.p_shdrtable[index]
				if size10 == 0:
					size10 = string.atoi(shdr.size, 16)
				if foffset == 0:
					foffset = text_offset
				addr = shdrs_offset2address(foffset, self.p_shdrtable)
				self.p_symbols[tname] = Sym(tname, foffset, size10, addr)

		
		f.close()
