#!/usr/bin/python

from Instr import *
from Arch import *

import string
import os
import re

objdump_binary = "/usr/bin/objdump"
objdump_opt = " -d "

r1 = re.compile("[ ]*([0-9a-fA-F]+):[ \t]+(?:[0-9a-fA-F]{2} )+ *\t([a-z]+) +(.+)")

class Disassem:
#
# @p_filename
# @p_asm = {}
# 
#
	def __init__(self, arch, filename):
		self.p_arch = arch
		self.p_dasm = {}
		self.p_filename = filename

		c = objdump_binary + objdump_opt + filename
		f = os.popen(c, "r")
		if not f:
			return -1
		while 1:
			line = f.readline()
			if not line:
				break
			m = r1.match(line)
			if not m:
				continue
			a = "0x%08x" % (string.atoi('0x' + m.group(1), 16))
			n = m.group(2)
			p = m.group(3)
			if m:
				self.p_dasm[a] = Instr(arch, line, a, n, p)
		f.close()

#
# FIXME: erm. yah.
#
	def m_npc(self, pc):
		for i in range(0, 13):
			pc10 = string.atoi(pc, 16)
			pc10 = pc10 + 1
			pc = "0x%08x" % (pc10)
			if self.p_dasm.has_key(pc):
				return pc

	def m_ppc(self, pc):
		for i in range(0, 13):
			pc10 = string.atoi(pc, 16)
			pc10 = pc10 - 1
			pc = "0x%08x" % (pc10)
			if self.p_dasm.has_key(pc):
				return pc
		return None
