#!/usr/bin/python

from Program import *

import string

class Printer:
#
#
#
#
	def print_proc(self, program, p):
		print "subgraph cluster_cfg_" + program.p_symtab.pc2name(p.p_address) + " {"
		print '"' + program.p_symtab.pc2name(p.p_address) + '"[',
		if p.p_linkage == "internal":
			print 'color=blue',
		elif p.p_linkage == "external":
			print 'color=brown',
		print '];'

		print '"' + program.p_symtab.pc2name(p.p_address) + '" -> "' + p.p_address + '" [color=green];'
		for q in p.p_rets:
			print '"' + q.p_pc + '" -> "' + program.p_symtab.pc2name(p.p_address) + '" [color=orange];'
		for k in p.p_graph.p_nodes.keys():
			instr = p.p_graph.p_nodes[k].p_val
			print '"' + instr.p_pc + '"'

		for k in p.p_graph.p_edges.keys():
			e = p.p_graph.p_edges[k]
			i1 = e.p_node1.p_val
			i2 = e.p_node2.p_val
			print '"' + i1.p_pc + '" -> "' + i2.p_pc + '"',
			if e.p_val:
				print e.p_val,
			print ';'
		print "}"

	def print_cg(self, program):
		for k in program.p_graph.p_nodes.keys():
			p = program.p_graph.p_nodes[k].p_val
			for qq in p.p_procs:
				q = qq[0]
				cpc = qq[1]
				print '"' + cpc + '" -> "' + program.p_symtab.pc2name(q.p_address) + '"'

		print "subgraph cluster_callgraph {"
		for k in program.p_graph.p_edges.keys():
			e = program.p_graph.p_edges[k]
			p1 = e.p_node1.p_val
			p2 = e.p_node2.p_val
			ev = e.p_val
			print '"' + program.p_symtab.pc2name(p1.p_address) + '" -> "' + program.p_symtab.pc2name(p2.p_address) + '"',
			if ev:
				print ev,
			print ';'
		print "}"

	def printer_proc(self, program, p):
		print 'PROCEDURE'
		print 'addr=%s' % (p.p_address)
		print 'name=%s' % (program.p_symtab.pc2name(p.p_address))
		print 'lvar.total_size=%s' % (p.p_var_local)
		if p.p_procargs:
			print 'argc=%i' % (len(p.p_procargs.p_vars))
			for k in p.p_procargs.p_vars.keys():
				v = p.p_procargs.p_vars[k]
				print 'argv[%s].p_size=%s' % (k, v.p_size)
		print 'END'

	def printer(self, program):
		print 'Digraph flowgraph {'
		print 'PROGRAM -> "' + program.p_symtab.pc2name(program.p_procroot.p_address) + '" [color=green];'

		for k in program.p_graph.p_nodes.keys():
			p = program.p_graph.p_nodes[k].p_val
			self.print_proc(program, p)
		self.print_cg(program)

		program.p_rtlinking.printer()
		print '}'

		print '/*'
		for k in program.p_graph.p_nodes.keys():
                        proc_call(program, p)
			p = program.p_graph.p_nodes[k].p_val
			self.printer_proc(program, p)
		print '*/'
