#!/usr/bin/python

from Disassem import *
from Var import *
from Graph import *

import string

#
# FIXME: move these to seperate source files?
#

# class ProcArg

class ProcArgs:
#
# @p_vars
#
#
	def __init__(self):
		self.p_vars = {}

	def push(self, var, n):
		self.p_vars[n] = var

class ProcLocalVars:
#
#
#
#
	def __init__(self):
		self.p_vars = None
		return

	def push(self, var):
		return

class Proc:
#
# @p_procs = []
# @p_rets = []
# @p_linkage
# @p_address
# @p_tagged
# @p_sym
# @p_graph
#
#
	def __init__(self, address, disassem, linkage = "internal", name=""):
		self.p_disassem = disassem

		self.p_procs = []
		self.p_rets = []
		self.p_address = address
		self.p_linkage = linkage
		self.p_tagged = 0

		if name != "":
			self.p_name = name
		else:
			self.p_name = 'PROCEDURE_%s' % (address)

		self.p_graph = Graph(self.p_name)

	def minternal_flowgraph(self, pc):
		if not self.p_disassem.p_dasm.has_key(pc):
			return
		instr = self.p_disassem.p_dasm[pc]
		assert pc == instr.p_pc

		if instr.p_tagged != 0:
			return
		instr.p_tagged = 1

		self.p_graph.push_node(GraphNode(instr, pc))

		if not instr.p_hasnpc:
			if instr.p_type == "ujmp":
				npc = instr.p_jumpto
				s = pc + ':' + npc
				if self.p_disassem.p_dasm.has_key(npc):
					ninstr = self.p_disassem.p_dasm[npc]
					self.p_graph.push_node(GraphNode(ninstr, npc))
					e = self.p_graph.push_edge(pc, npc, s)
					self.minternal_flowgraph(npc)
			elif instr.p_type == "ret":
				self.p_rets.append(instr)
			return


		if instr.p_jumpto:
			npc = instr.p_jumpto
			if instr.p_type == "cjmp":
				ninstr = self.p_disassem.p_dasm[npc]
				s = pc + ':' + npc
				self.p_graph.push_node(GraphNode(ninstr, npc))
				e = self.p_graph.push_edge(pc, npc, s)
				e.p_val = '[label="' + instr.p_mnemonic + '"]'
				self.minternal_flowgraph(npc)
			elif instr.p_type == "call":
				p = Proc(npc, self.p_disassem)
				self.p_procs.append((p, pc))

		npc = instr.m_npc()
		ninstr = self.p_disassem.p_dasm[npc]

		s = pc + ':' + npc
		self.p_graph.push_node(GraphNode(ninstr, npc))
		self.p_graph.push_edge(pc, npc, s)

		self.minternal_flowgraph(npc)

	def m_flowgraph(self):
		self.minternal_flowgraph(self.p_address)

	def m_var_local(self):
		self.p_var_local = None

#
# There is 0 finesse here.. however, it is useful anyway :)
#
		pc = self.p_address
		s = self.p_disassem.p_dasm[pc].p_instr_string
		m = re.compile(".*?:\t55[ \t]+push").match(s)
		if not m:
			return
		pc = "0x%08x" % (string.atoi(pc, 16) + 1)
		s = self.p_disassem.p_dasm[pc].p_instr_string
		m = re.compile(".*?:\t89 e5[ \t]+mov[ \t]+%esp,%ebp$").match(s)
		if not m:
			return
		pc = "0x%08x" % (string.atoi(pc, 16) + 2)
		s = self.p_disassem.p_dasm[pc].p_instr_string
		m = re.compile(".*?sub[ \t]+\$(0x[0-9a-f]+),%esp$").match(s)
		if not m:
			return
		self.p_var_local = m.group(1)
#		print 'LOCAL', self.p_name, self.p_var_local

	def m_var_args(self):
		self.p_procargs = ProcArgs()
		arg = {}

#
# 0 finesse X 2
#
		for k in self.p_graph.p_nodes.keys():
			instr = self.p_graph.p_nodes[k].p_val
			s = instr.p_instr_string
			m = re.compile(".*?(0x[0-9a-fA-F]+)\(%ebp\)").match(s)
			if not m:
				continue
			index = m.group(1)
			if (index[2] != 'f'):
				if not arg.has_key(index):
					arg[index] = [ instr ]
				else:
					arg[index].append(instr)
					print 'ARG', index
#			else:
#				print 'LOCAL'
		if len(arg) > 0:
			vars = []
			for k in arg.keys():
				vars.append(string.atoi(k, 16))
			vars.sort()
			for i in range(0, len(arg) - 1):
				size = vars[i + 1] - vars[i]
				var = Var(size)
				self.p_procargs.push(var, i)
			self.p_procargs.push(Var(), len(arg) - 1)

#
# FIXME: plz
#

def proc_call(program, caller_proc):
	for t in caller_proc.p_procs:
		callee_proc = t[0]
		caller_pc = t[1]

		instr0 = program.p_disassem.p_dasm[caller_pc]
		npc = instr0.m_npc()
		instr1 = program.p_disassem.p_dasm[npc]
		s = instr1.p_instr_string
		m = re.compile(".*?add[ \t]+(\$0x[0-9a-fA-F]+),%esp$").match(s)
		if not m:
			return
#		print 'STACK CORRECTION', m.group(1)
		pc = caller_pc
		c = 0
#
# FIXME: 30 is just upper limit
#
		for i in range(0, 30):
			pc = program.p_disassem.m_ppc(pc)
			instrp = program.p_disassem.p_dasm[pc]
			s = instrp.p_instr_string
#			print s
			m = re.compile(".*?push[ \t]+(.*)").match(s)
			if m:
				c = c + 1
			m = re.compile(".*?sub[ \t]+(\$0x[0-9a-fA-F]+),%esp$").match(s)
			if m:
				break
			m = re.compile(".*?add[ \t]+(\$0x[0-9a-fA-F]+),%esp$").match(s)
			if m:
				break
		if not m:
			return
#		if m:
#			print 'STACK ALLIGNMENT', m.group(1)
		if not caller_proc.p_procargs:
			return
		e = len(caller_proc.p_procargs.p_vars)
		if c != e:
			print 'BUG'
			print 'PROCARGS: Expect %i, Passed %i' % (e, c)
			print 'CALLER %s' % (program.p_symtab.pc2name(caller_proc.p_address))
			print 'CALLER_PC %s' % (caller_pc)
			print 'CALLEE %s' % (program.p_symtab.pc2name(callee_proc.p_address))
			print 'END'
