#!/usr/bin/python

from Proc import *
from ProcArgs import *

class ProcCall:
#
# @p_caller_pc
# @p_callee_pc
# @p_args
# @p_stack_correction
# @p_stack_alignment
#
#
	def __init__(self, caller_pc, callee_pc):
		self.p_caller_pc = caller_pc
		self.p_callee_pc = callee_pc
		self.p_stack_correction = None
		self.p_stack_alignment = None
		self.p_args = None

	def run(self, program):
		instr0 = program.p_disassem.p_dasm[self.p_caller_pc]
		npc = program.p_disassem.m_npc(self.p_caller_pc)
		instr1 = program.p_disassem.p_dasm[npc]
		s = instr1.p_instr_string
		m = re.compile(".*?add[ \t]+(\$0x[0-9a-fA-F]+),%esp$").match(s)
		if not m:
			return
#		print 'STACK CORRECTION', m.group(1)
		self.p_stack_correction = m.group(1)
		pc = self.p_caller_pc
		c = 0
		self.p_args = ProcArgs()
#
# FIXME: 30 is just upper limit
#
		for i in range(0, 30):
			pc = program.p_disassem.m_ppc(pc)
			instrp = program.p_disassem.p_dasm[pc]
			mn = instrp.p_mnemonic
			if mn == "push" or mn == "pushl":
				self.p_args.push(instrp.p_argv[0], c)
				c = c + 1
			if mn == "sub":
				self.p_stack_alignment = 0
				break
			if mn == "add":
				self.p_stack_alignment = 0
				break
		return
