#!/usr/bin/python

from Instr import *

import string
import os
import re

objdump_binary = "/usr/bin/objdump"
objdump_opt = " -d "
objdump_regexp = re.compile(" [^a-z0-9]*([^:]*):.*$")

class Disassem:
#
# @p_filename
# @p_asm = {}
# 
#
	def __init__(self, filename="a.out"):
		self.p_dasm = {}
		self.p_filename = filename

		c = objdump_binary + objdump_opt + filename
		f = os.popen(c, "r")
		if not f:
			return -1
		while 1:
			line = f.readline()
			if not line:
				break
#
# FIXME: empty line, not len == 1
#
			if len(line) == 1:
				continue
			m = objdump_regexp.match(line)
			if not m:
				continue
			a = "0x%08x" % (string.atoi('0x' + m.group(1), 16))
			self.p_dasm[a] = Instr(line)
		f.close()
