#!/usr/bin/python

import string
import re

re_cbranch = re.compile("^(j[^m].*?)[ \t]+(?:0x)?([0-9a-f]+).*")
re_ubranch = re.compile("^(jmp)[ \t]+(?:0x|\*0x)?([0-9a-f]+).*")
re_call = re.compile("^(call)[ \t]+(?:0x)?([0-9a-f]+).*")
re_ret = re.compile("^(ret)[ \t]+.*|^(hlt)[ \t]+.*")

re_d2 = re.compile("[^a-z0-9]*([^:]*):[\t ]*([^\t]*)[ \t]*(.*)$")
re_d3 = re.compile("[0-9a-f]{2} ")

class Instr:
#
# @p_instr_string
# @p_size
# @p_type
# @p_jumpto
#
# +m_npc
#
	def m_bytecount(self, bytestream):
		m = re_d3.findall(bytestream)
		return len(m)

	def __init__(self, instr_string):
		self.p_instr_string = instr_string
		self.p_tagged = 0
		self.p_type = "unknown"
		self.p_hasnpc = 1
		self.p_jumpto = None
		self.p_mnemonic = None
#		self.p_size

#
# FIXME: this is total shit
#
		m = re_d2.match(instr_string)
		i = m.group(3)
		a = "0x%08x" % (string.atoi('0x' + m.group(1), 16))

		self.p_pc = a

		cm = re_cbranch.match(i)
		if cm:
			self.p_type = "cjmp"
			self.p_mnemonic = cm.group(1)
			cn = "0x%08x" % (string.atoi('0x' + cm.group(2), 16))
			self.p_jumpto = cn
		else:
			um = re_ubranch.match(i)
			if um:
				self.p_type = "ujmp"
				un = "0x%08x" % (string.atoi('0x' + um.group(2), 16))
				self.p_jumpto = un
				self.p_hasnpc = None
			else:
				lm = re_call.match(i)
				if lm:
					self.p_type = "call"
					ln = "0x%08x" % (string.atoi("0x" + lm.group(2), 16))
					self.p_jumpto = ln
				else:
					km = re_ret.match(i)
					if km:
						self.p_hasnpc = None
						self.p_type = "ret"

		a10 = string.atoi(a, 16)
		bs = m.group(2)
		bc = self.m_bytecount(bs)
		self.p_size = bc

	def m_npc(self):
		npc = string.atoi(self.p_pc, 16) + self.p_size
		return "0x%08x" % (npc)
