#!/usr/bin/python

class GraphNode:
#
# @p_edges []
# @p_val
# @p_key
#
#
	def __init__(self, val, key):
		self.p_edges_i = []
		self.p_edges_o = []
		self.p_val = val
		self.p_key = key
		self.p_tag = None

class GraphEdge:
#
# @p_node1
# @p_node2
# @p_key
# @p_weight
#
#
	def __init__(self, node1, node2, key, val=None):
		self.p_node1 = node1
		self.p_node2 = node2
		self.p_key = key
		self.p_weight = 1
		self.p_val = val

class Graph:
#
# @p_edges
# @p_nodes
# @p_key
#
#
	def __init__(self, key):
		self.p_edges = {}
		self.p_nodes = {}
		self.p_key = key

	def push_node(self, n):
		if self.p_nodes.has_key(n.p_key):
			return 1
		self.p_nodes[n.p_key] = n
		return 0
		
	def push_edge(self, k1, k2, ek, val=None):
		if self.p_edges.has_key(ek):
			e = self.p_edges[ek]
			e.p_weight = e.p_weight + 1
		else:
			e = GraphEdge(self.p_nodes[k1], self.p_nodes[k2], ek, val)
			self.p_edges[ek] = e
			self.p_nodes[k1].p_edges_o.append(e)
			self.p_nodes[k2].p_edges_i.append(e)
		return e

	def internal_tagNone(self):
		for n in self.p_nodes.values():
			n.tag = None

	def internal_paths(self, graph, ki, kf):
		ni = self.p_nodes[ki]
		nf = self.p_nodes[kf]

		if ni == nf:
			return 1
		if ni.p_tag:
			return 0
		ni.p_tag = 1
		c = 0
		for e in ni.p_edges:
			n = e.p_node2
			kn = n.p_key
			r = self.internal_paths(graph, kn, kf)
			s = ki + ':' + kn
			if r != 0:
				graph.push_node(GraphNode(ni.p_val, ni.p_key))
				graph.push_node(GraphNode(n.p_val, n.p_key))
				graph.push_edge(ki, kn, s)
				c = c + 1
		return c

	def paths(self, ki, kf):
		graph = Graph("")
		self.internal_tagNone()
		self.internal_paths(graph, ki, kf)
		return graph

	def dominates(self, ki, kn, kf):
		return None

	def internal_simple(self, graph, k, block):
		root = self.p_nodes[k]
		if root.p_tag:
			return
		root.p_tag = 1
		if len(root.p_edges_o) == 0:
			graph.push_node(GraphNode(block, k))
			lk = block[0].p_key
			s = lk + ':' + k
			graph.push_edge(lk, k, s)
		elif len(root.p_edges_o) == 1 and len(root.p_edges_i) <= 1:
			e = root.p_edges_o[0]
			n = e.p_node2
			block.append(n)
			self.internal_simple(graph, n.p_key, block)
		else:
			for e in root.p_edges_o:

				graph.push_node(GraphNode(block, k))
				lk = block[0].p_key
				s = lk + ':' + k
				graph.push_edge(lk, k, s)

				n = e.p_node2
				next = [ root ]
				graph.push_node(GraphNode(next, k))
				self.internal_simple(graph, n.p_key, next)
		return

	def simple(self, k):
		graph = Graph("")
		self.internal_tagNone()
		n = self.p_nodes[k]
		graph.push_node(GraphNode(n, k))
		self.internal_simple(graph, k, [ n ])
		return graph
