#!/usr/bin/python

from Proc import *
from Arch import *
from Disassem import *
from Binary import *
from SymTab import *
from RTLibraryLinkage import *
from RTLinking import *
from linker import *

import sys
import os
import string

class Program:
#
# @p_filename
# @p_binary
# @p_syms
#
#
	def __init__(self, filename, libraries):
		self.p_libraries = libraries
		self.p_filename = filename
		self.p_binary = Binary2(filename)
		self.p_arch = Arch()
		self.p_disassem = Disassem(self.p_arch, filename)
		self.p_procroot = Proc(self.p_binary.p_entry, self.p_disassem)
		self.p_graph = Graph("CG")
		self.p_rtlinking = RTLinking(self.p_filename)
		self.p_symtab = SymTab()

		self.p_staticlinker = LibraryRecognizer()
		self.procedures_todo = []

	def run(self):
		pdict = self.p_staticlinker.recognize(self.p_filename, self.p_libraries)

		self.linklist = pdict
		l = RTLibraryLinkage(self.p_filename)
		self.m_flowgraph()
		for k in self.p_graph.p_nodes.keys():
			p = self.p_graph.p_nodes[k].p_val
			e = l.match(p.p_address)
			if e:
				sym = Sym(e.sym, 0, 0, p.p_address)
				self.p_symtab.push(sym)
#				p.p_name = e.sym
				p.p_linkage = "external"
		for k in self.p_graph.p_nodes.keys():
			p = self.p_graph.p_nodes[k].p_val
			p.m_var_local()
			p.m_var_args()

	
	def m_flowgraph(self):
		self.procedures_todo.append(self.p_procroot)
		r = self.p_graph.push_node(GraphNode(self.p_procroot, self.p_procroot.p_address))

		self.procedures_static = self.linklist
		if self.procedures_static.has_key(self.p_binary.p_entry):
			todo = self.procedures_static[self.p_binary.p_entry]
			for x in todo:
				self.procedures_todo.append(x)
				sym = Sym(x.p_name, 0, 0, x.p_address)
				self.p_symtab.push(sym)

				r = self.p_graph.push_node(GraphNode(x, x.p_address))
				s = self.p_procroot.p_address + ':' + x.p_address
				e = self.p_graph.push_edge(self.p_procroot.p_address, x.p_address, s, '[color=yellow]')

		while len(self.procedures_todo) != 0:
			p = self.procedures_todo.pop(0)
			r = self.p_graph.push_node(GraphNode(p, p.p_address))
			if r != 0:
				v = self.p_graph.p_nodes[p.p_address].p_val
				if v.p_tagged != 0:
					continue
			p.p_tagged = 1

			sym = Sym(p.p_name, 0, 0, p.p_address)
			self.p_symtab.push(sym)

			p.m_flowgraph()

			for qq in p.p_procs:
				q = qq[0]
				self.p_graph.push_node(GraphNode(q, q.p_address))
				if self.procedures_static.has_key(q.p_address):
					todo = self.procedures_static[q.p_address]
					for x in todo:
						seld.procedures_todo.append(x)
						self.p_graph.push_node(GraphNode(x, x.p_address))
						s = q.p_address + ':' + x.p_address
						e = self.p_graph.push_edge(p.p_address, x.p_address, s, '[color=yellow]')

				self.procedures_todo.append(q)

				s = p.p_address + ':' + q.p_address
				e = self.p_graph.push_edge(p.p_address, q.p_address, s, '[color=red]')
		for k in self.p_graph.p_nodes.keys():
			p = self.p_graph.p_nodes[k].p_val
			if self.p_binary.p_syms.has_key(p.p_address):
				sym = self.p_binary.p_syms[p.p_address]
				self.p_symtab.push(sym)
