#!/usr/bin/python

from Disassem import *
from Graph import *

import string

class Proc:
#
# @p_procs = []
# @p_rets = []
# @p_linkage
# @p_address
# @p_tagged
# @p_sym
# @p_graph
#
#
	def __init__(self, address, disassem, linkage = "internal", name=""):
		self.p_disassem = disassem

		self.p_procs = []
		self.p_rets = []
		self.p_address = address
		self.p_linkage = linkage
		self.p_tagged = 0

		if name != "":
			self.p_name = name
		else:
			self.p_name = 'PROCEDURE_%s' % (address)

		self.p_graph = Graph(self.p_name)

	def minternal_flowgraph(self, pc):
		if not self.p_disassem.p_dasm.has_key(pc):
			return
		instr = self.p_disassem.p_dasm[pc]
		assert pc == instr.p_pc

		if instr.p_tagged != 0:
			return
		instr.p_tagged = 1

		self.p_graph.push_node(GraphNode(instr, pc))

		if not instr.p_hasnpc:
			if instr.p_type == "ujmp":
				npc = instr.p_jumpto
				s = pc + ':' + npc
				if self.p_disassem.p_dasm.has_key(npc):
					ninstr = self.p_disassem.p_dasm[npc]
					self.p_graph.push_node(GraphNode(ninstr, npc))
					e = self.p_graph.push_edge(pc, npc, s)
					self.minternal_flowgraph(npc)
			elif instr.p_type == "ret":
				self.p_rets.append(instr)
			return


		if instr.p_jumpto:
			npc = instr.p_jumpto
			if instr.p_type == "cjmp":
				ninstr = self.p_disassem.p_dasm[npc]
				s = pc + ':' + npc
				self.p_graph.push_node(GraphNode(ninstr, npc))
				e = self.p_graph.push_edge(pc, npc, s)
				e.p_val = '[label="' + instr.p_mnemonic + '"]'
				self.minternal_flowgraph(npc)
			elif instr.p_type == "call":
				p = Proc(npc, self.p_disassem)
				self.p_procs.append((p, pc))

		npc = instr.m_npc()
		ninstr = self.p_disassem.p_dasm[npc]

		s = pc + ':' + npc
		self.p_graph.push_node(GraphNode(ninstr, npc))
		self.p_graph.push_edge(pc, npc, s)

		self.minternal_flowgraph(npc)

	def m_flowgraph(self):
		self.minternal_flowgraph(self.p_address)

	def m_var_local(self):
#
# There is 0 finesse here.. however, it is useful anyway :)
#
		pc = self.p_address
		s = self.p_disassem.p_dasm[pc].p_instr_string
		m = re.compile(".*?:\t55[ \t]+push").match(s)
		if not m:
			return
		pc = "0x%08x" % (string.atoi(pc, 16) + 1)
		s = self.p_disassem.p_dasm[pc].p_instr_string
		m = re.compile(".*?:\t89 e5[ \t]+mov[ \t]+%esp,%ebp$").match(s)
		if not m:
			return
		pc = "0x%08x" % (string.atoi(pc, 16) + 2)
		s = self.p_disassem.p_dasm[pc].p_instr_string
		m = re.compile(".*?sub[ \t]+\$(0x[0-9a-f]+),%esp$").match(s)
		if not m:
			return
		self.p_var_local = m.group(1)
#		print 'LOCAL', self.p_name, self.p_var_local
