#!/usr/bin/python

import sys
import os
import string
import re

readelf_binary = "/usr/bin/readelf"
readelf_opt = " -r "
readelf_regexp = re.compile("[ ]*([0-9a-fA-F]+)  ([0-9a-fA-F]{5}) R_386_JUMP_SLOT +([0-9a-fA-F]+)  (.*?)[ \t]+")

#
# FIXME: ELF specific
#

class PLTEntry:
	def __init__(self, off, inf, val, sym):
		self.off = off
		self.inf = inf
		self.val = val
		self.sym = sym

	def printer(self):
		print 'off=%s:inf=%s:val=%s:sym=%s' \
			% (self.off, self.inf, self.val, self.sym)
#
# FIXME: base clase
#

class RTLibraryLinkage:
#
# @p_linkage = {}
#
#
	def __init__(self, filename="a.out"):
		c = readelf_binary + readelf_opt + filename
		f = os.popen(c, "r")
		if not f:
			return
		self.p_linkage= {}
		for line in f.readlines():
			m = readelf_regexp.match(line)
			if not m:
				continue
			off = m.group(1)
			inf = m.group(2)
			val = m.group(3)
			sym = m.group(4)
			val = "0x%08x" % (string.atoi('0x' + val, 16))
			self.p_linkage[val] = PLTEntry(off, inf, val, sym)
		f.close()

	def match(self, val):
		off = "0x%08x" % (string.atoi(val, 16))
		if self.p_linkage.has_key(val):
			return self.p_linkage[val]
		return 0

#if len(sys.argv) != 2:
#	sys.exit(0)
#
#l = RTLibraryLinkage(sys.argv[1])
#e = l.match("0x08048308")
#if e:
#	e.printer()
