#!/usr/bin/python

from Program import *
from Format import *
from ProcProto import *
from LocalVarOverrun import *

import re
import string
import os

#
#
#
#		i = 0
#		for k1 in program.p_graph.p_nodes.keys():
#			p = program.p_graph.p_nodes[k1].p_val
#			if p.p_linkage == "external":
#				continue
#
# annotations
#

#	fmt = Format()
#	procproto = ProcProto()
#	overrun = LocalVarOverrun()
#	print '/*'
#	for k in program.p_graph.p_nodes.keys():
#		p = program.p_graph.p_nodes[k].p_val
#		for c in p.p_procs:
#			c.run(program)
#		fmt.checker(program, p)
#		procproto.checker(program, p)
#		overrun.checker(program, p)
#		self.printer_proc(program, p)
#	print '*/'
#
# intra -> inter glue
#
#	for k in program.p_graph.p_nodes.keys():
#		p = program.p_graph.p_nodes[k].p_val
#		for qq in p.p_procs:
#			cpc = qq.p_caller_pc
#			q = qq.p_callee_pc
#			print '"' + cpc + '" -> "' + program.p_symtab.pc2name(q) + '"'

class Printer:
#
#
#
#
	def print_callgraph(self, program, graph, filename = ""):
		if filename == "":
			filename = 'callgraph'

		f = open('%s.dot' % (filename), "w")
		if not f:
			return
		f.write('digraph callgraph {\n')

#		f.write('PROGRAM -> "%s" [color=green];\n' % (program.p_symtab.pc2name(program.p_procroot.p_address)))

		for k in graph.p_nodes.keys():
			proc = graph.p_nodes[k].p_val
			if proc.p_linkage == "external":
				continue
			f.write('"%s" [ URL="proc_%s.html" ];\n' % (program.p_symtab.pc2name(proc.p_address), program.p_symtab.pc2name(proc.p_address)))

		for k in graph.p_edges.keys():
			e = graph.p_edges[k]
			p1 = e.p_node1.p_val
			p2 = e.p_node2.p_val
			ev = e.p_val
			f.write('"%s" -> "%s" ' % (program.p_symtab.pc2name(p1.p_address), program.p_symtab.pc2name(p2.p_address)))
			if ev:
				f.write(ev)
			f.write(';\n')
		f.write('}\n')
		f.close()

		os.system('dot -Nfontsize=6 -Tgif %s.dot -o %s.gif' % (filename, filename))
		os.system('dot -Nfontsize=6 -Timap %s.dot -o %s.imap' % (filename, filename))

#
#

	def print_controlflowgraph(self, program, proc, filename = ""):
		if filename == "":
			filename = 'controlflowgraph_%s' % (program.p_symtab.pc2name(proc.p_address))

		f = open('%s.dot' % (filename), "w")
		if not f:
			return
		f.write('digraph controlflowgraph_%s {\n' % (program.p_symtab.pc2name(proc.p_address)))
		f.write('"%s" [color=blue];\n' % (program.p_symtab.pc2name(proc.p_address)))

		f.write('"%s" -> "%s" [color=green];\n' % (program.p_symtab.pc2name(proc.p_address), proc.p_address))

		for q in proc.p_rets:
			f.write('"%s" -> "%s" [color=orange];\n' % (q.p_pc, program.p_symtab.pc2name(proc.p_address)))
		for k in proc.p_graph.p_nodes.keys():
			instr = proc.p_graph.p_nodes[k].p_val
			f.write('"%s"\n' % (instr.p_pc))

		for k in proc.p_graph.p_edges.keys():
			e = proc.p_graph.p_edges[k]
			i1 = e.p_node1.p_val
			i2 = e.p_node2.p_val
			f.write('"%s" -> "%s"' % (i1.p_pc, i2.p_pc))
			if e.p_val:
				f.write(e.p_val)
			f.write(';\n')
		f.write('}\n')
		f.close()

		os.system('dot -Tgif %s.dot -o %s.gif' % (filename, filename))

	def print_basicblockgraph(self, program, proc, filename = ""):
		if filename == "":
			filename = 'basicblockgraph_%s' % (program.p_symtab.pc2name(proc.p_address))

		f = open('%s.dot' % (filename), "w")
		if not f:
			return
		f.write('digraph basicblockgraph_%s {\n' % (program.p_symtab.pc2name(proc.p_address)))
		for k2 in proc.p_bbgraph.p_edges.keys():
			e = proc.p_bbgraph.p_edges[k2]
			n1 = e.p_node1.p_val
			n2 = e.p_node2.p_val
#			print k2, len(n1), len(n2)
#			print id(e.p_node1), id(e.p_node2)
#			print id(n1), id(n2)
			label = ''
			v11 = n1[0].p_val.p_pc
			if len(n1) == 1:
				v1 = 'PC_%s' % (v11)
				mn = n1[0].p_val.p_mnemonic
				if re.compile('j.*').match(mn):
					label = 'label="' + mn + '"'
			else:
				v12 = n1[len(n1) - 1].p_val.p_pc
				if v11 == v12:
					print 'EERRM', len(n1)
				v1 = '%s-%s' % (v11, v12)
			v21 = n2[0].p_val.p_pc
			if len(n2) == 1:
				v2 = 'PC_%s' % (v21)
			else:
				v22 = n2[len(n2) - 1].p_val.p_pc
				if v21 == v22:
					print 'EERRM', len(n2)
				v2 = '%s-%s' % (v21, v22)

			f.write('"%s" -> "%s" [%s];\n' % (v1, v2, label))
		f.write('}\n')
		f.close()

		os.system('dot -Tgif %s.dot -o %s.gif' % (filename, filename))

	def print_proc(self, program, proc, filename=""):
		if filename == "":
			filename = 'proc_%s.txt' % (program.p_symtab.pc2name(proc.p_address))

		f = open(filename, "w")
		if not f:
			return
		f.write('PROCEDURE\n')
		f.write('addr=%s\n' % (proc.p_address))
		f.write('name=%s\n' % (program.p_symtab.pc2name(proc.p_address)))
		f.write('lvar.total_size=%s\n' % (proc.p_var_local))
		if proc.p_procargs:
			f.write('argc=%i\n' % (len(proc.p_procargs.p_vars)))
			for k in proc.p_procargs.p_vars.keys():
				v = proc.p_procargs.p_vars[k]
				f.write('argv[%s].p_size=%s\n' % (k, v.p_size))
		f.write('calls %i\n' % (len(proc.p_procs)))
		f.write('END\n')
		f.close()

#
# FIXME: php
#
	def print_program_html(self, program, filename=""):
		if filename == "":
			filename = 'program.html'
	
		f = open(filename, "w")
		if not f:
			return

		f.write('<HTML>\n')
		f.write('<HEAD><TITLE>CALLGRAPH</TITLE></HEAD>\n')
		f.write('<BODY>\n')

		for i in range(0, len(program.p_sections)):
			f.write('<A HREF="callgraph_%i.html">CALLGRAPH %i</A> - %i PROCEDURES<BR>\n' % (i, i, len(program.p_sections[i].p_nodes)))
		f.write('</BODY>\n')
		f.write('</HTML>\n')
		f.close()

	def print_callgraph_html(self, program, filename=""):
		if filename == "":
			filename = 'callgraph.html'

		f = open('%s.html' % (filename), "w")
		if not f:
			return

		f.write('<HTML>\n')
		f.write('<HEAD><TITLE>CALLGRAPH</TITLE></HEAD>\n')
		f.write('<BODY>\n')
		f.write('<MAP NAME="callgraph">\n')

		i = open('%s.imap' % (filename), "r")
		if i:
			r = re.compile('^rect (.*?) ([0-9]+?),([0-9]+?) ([0-9]+?),([0-9]+)')
			for line in i.readlines():
				m = r.match(line)
				if not m:
					continue
				url = m.group(1)
				x1 = m.group(2)
				y1 = m.group(5)
				x2 = m.group(4)
				y2 = m.group(3)
				f.write('<AREA SHAPE="rect" COORDS="%s,%s,%s,%s" HREF="%s">\n' % (x1, y1, x2, y2, url))
			i.close()

		f.write('<IMAGE SRC=%s.gif USEMAP="#callgraph">\n' % (filename))
		f.write('</MAP>\n')
		f.write('</BODY>\n')
		f.write('</HTML>\n')
		f.close()

	def print_proc_html(self, program, proc, filename=""):
		name = program.p_symtab.pc2name(proc.p_address)
		if filename == "":
			filename = 'proc_%s.html' % (name)

		f = open(filename, "w")
		if not f:
			return
		f.write('<HTML>\n')
		f.write('<HEAD><TITLE>%s</TITLE></HEAD>\n' % (name))
		f.write('<BODY>\n')
		f.write('<A HREF="proc_%s.txt">DESCRIPTION</A><BR>\n' % (name))
		f.write('<A HREF="controlflowgraph_%s.gif">CFG</A><BR>\n' % (name))
		f.write('<A HREF="basicblockgraph_%s.gif">BBGraph</A><BR>\n' % (name))
		f.write('</BODY>\n')
		f.write('</HTML>\n')
		f.close()

	def run(self, program):
		for i in range(0, len(program.p_sections)):
			callgraph = program.p_sections[i]
			name = 'callgraph_%i' % (i)
			self.print_callgraph(program, callgraph, name)
			self.print_callgraph_html(program, name)
		self.print_program_html(program)
		for k in program.p_graph.p_nodes.keys():
			proc = program.p_graph.p_nodes[k].p_val
			if proc.p_linkage == "external":
				continue
			self.print_proc(program, proc)
			self.print_proc_html(program, proc)
			self.print_controlflowgraph(program, proc)
			self.print_basicblockgraph(program, proc)
#		program.p_rtlinking.printer()
