#!/usr/bin/python

from BBlockGraph import *
from DisjointGraph import *

from ProcPrologue import *
from Proc import *
from Arch import *
from Disassem import *
from Binary import *
from SymTab import *
from RTLibraryLinkage import *
from RTLinking import *
from linker import *

import sys
import os
import string

class Program:
#
# @p_filename
# @p_binary
# @p_syms
#
#
	def __init__(self, filename, libraries):
		self.p_libraries = libraries
		self.p_filename = filename
		self.p_binary = Binary2(filename)
		self.p_arch = Arch()
		self.p_disassem = Disassem(self.p_arch, self.p_binary)
		self.p_procroot = Proc(self.p_binary.p_entry, self.p_disassem)
		self.p_graph = Graph("CG")
		self.p_rtlinking = RTLinking(self.p_filename)
		self.p_symtab = SymTab()

		self.p_staticlinker = LibraryRecognizer()
		self.procedures_todo = []

	def run(self):

# straight line analysis
#
		pdict = self.p_staticlinker.recognize(self.p_filename, self.p_libraries, self.p_disassem)

		self.linklist = pdict


		if 1:
			prologue = ProcPrologue().run(self.p_disassem)
			for pc in prologue:
				proc = Proc(pc, self.p_disassem)
				self.procedures_todo.append(proc)
		self.procedures_todo.append(self.p_procroot)

		for k in self.p_binary.p_syms.keys():
			sym = self.p_binary.p_syms[k]
			self.p_symtab.push(sym)

		l = RTLibraryLinkage(self.p_filename)
		l.copyto(self.p_symtab)

# control flow analysis
# 
		self.m_flowgraph()

#
# callgraph analysis

		root = self.p_graph.p_nodes.values()[0]
		self.p_sections = DisjointGraph().disjoint(self.p_graph, root)
		print 'DGRAPH', len(self.p_sections)

#
# intra-procedural analysis

		for k in self.p_graph.p_nodes.keys():
			p = self.p_graph.p_nodes[k].p_val
			if p.p_linkage == "external":
				continue
			p.m_var_local()
			p.m_var_args()
#			print '|%s|%s|' % (k, p.p_address)
			p.p_bbgraph = BBlockGraph("")
			p.p_bbgraph.simple(p.p_graph, p.p_address)


	def m_flowgraph(self):
		r = self.p_graph.push_node(GraphNode(self.p_procroot, self.p_procroot.p_address))

		self.procedures_static = self.linklist
		if self.procedures_static.has_key(self.p_binary.p_entry):
			todo = self.procedures_static[self.p_binary.p_entry]
			for x in todo:
				self.procedures_todo.append(x)
				sym = Sym(x.p_address, x.p_name)
				self.p_symtab.push(sym)

				r = self.p_graph.push_node(GraphNode(x, x.p_address))
				s = self.p_procroot.p_address + ':' + x.p_address
				e = self.p_graph.push_edge(self.p_procroot.p_address, x.p_address, s, '[color=yellow]')

		while len(self.procedures_todo) != 0:
			p = self.procedures_todo.pop(0)
			r = self.p_graph.push_node(GraphNode(p, p.p_address))
			if r != 0:
				v = self.p_graph.p_nodes[p.p_address].p_val
				if v.p_tagged != 0:
					continue
			p.p_tagged = 1

			if p.p_linkage == "external":
#				print 'EXTERNAL LINKAGE', p.p_name
				continue

#			sym = self.p_symtab.peek(p.p_address)
#			if not sym:
#			sym = Sym(p.p_name, 0, 0, p.p_address)
			sym = Sym(p.p_address, p.p_name)
			self.p_symtab.push(sym)

			p.m_flowgraph()

			for qq in p.p_procs:
				sym = self.p_symtab.peek(qq.p_callee_pc)
				if not sym:
					q = Proc(qq.p_callee_pc, self.p_disassem)
					sym = Sym(q.p_address, q.p_name, q)
					self.p_symtab.push(sym)
				else:
#					print 'PRESENT', qq.p_callee_pc, sym.p_name
					if sym.p_val:
						q = Proc(qq.p_callee_pc, self.p_disassem, "external", sym.p_name)
					else:
						q = Proc(qq.p_callee_pc, self.p_disassem, "internal", sym.p_name)


				self.p_graph.push_node(GraphNode(q, q.p_address))
				if self.procedures_static.has_key(q.p_address):
					todo = self.procedures_static[q.p_address]
					for x in todo:
						seld.procedures_todo.append(x)
						self.p_graph.push_node(GraphNode(x, x.p_address))
						s = q.p_address + ':' + x.p_address
						e = self.p_graph.push_edge(p.p_address, x.p_address, s, '[color=yellow]')

				self.procedures_todo.append(q)

				s = p.p_address + ':' + q.p_address
				e = self.p_graph.push_edge(p.p_address, q.p_address, s, '[color=red]')
