#!/usr/bin/python

from ProcCFG import *
from ProcLocalVars import *
from ProcArgs import *

from Disassem import *
from Var import *
from Graph import *

import string

class Proc:
#
# @p_procs = []
# @p_rets = []
# @p_linkage
# @p_address
# @p_tagged
# @p_sym
# @p_graph
#
#
	def __init__(self, address, disassem = None, linkage = "internal", name=""):
		self.p_disassem = disassem

		self.p_procargs = None
		self.p_var_local = None

		self.p_procs = []
		self.p_rets = []
		self.p_address = address
		self.p_linkage = linkage
		self.p_tagged = 0

		if name != "":
			self.p_name = name
		else:
			self.p_name = 'PROC_%s' % (address)

		self.p_graph = Graph(self.p_name)

	def m_flowgraph(self):
		self.p_cfg = ProcCFG()
		self.p_cfg.cfg(self)

	def m_var_local(self):
		self.p_localvars = ProcLocalVars()
		self.p_localvars.run(self)

	def m_var_args(self):
		self.p_procargs = ProcArgs()
		self.p_procargs.run(self)
