#include "Agent_SchemaXML.h"

#include <iostream.h>

int
Agent_SchemaXML::m_parse_input(Detective *detective, xmlDocPtr doc,
	xmlNodePtr root)
{
	xmlChar *name;

	name = xmlGetProp(root, (const xmlChar *)"NAME");
cout << "AGENT INPUT " << (char *)name << endl;
	xmlFree(name);
	return 0;
}

int
Agent_SchemaXML::m_parse_agent(Detective *detective, xmlDocPtr doc,
	xmlNodePtr root)
{
	xmlChar *agent;

	agent = xmlGetProp(root, (const xmlChar *)"NAME");
cout << "AGENT name " << (char *)agent << endl;
	xmlFree(agent);

	for (xmlNodePtr p = root->xmlChildrenNode; p != NULL; p = p->next) {
		const char *name = (const char *)p->name;
		int ret;

		if (strcmp(name, "INPUT") == 0) {
			ret = m_parse_input(detective, doc, p);
		}
	}
	return 0;
}

int
Agent_SchemaXML::m_parse_agentbase(Detective *detective, xmlDocPtr doc,
	xmlNodePtr root)
{
	for (xmlNodePtr p = root->xmlChildrenNode; p != NULL; p = p->next) {
		const char *name = (const char *)p->name;
		int ret;

		if (strcmp(name, "AGENT") == 0) {
			ret = m_parse_agent(detective, doc, p);
		}
	}
	return 0;
}

int
Agent_SchemaXML::parse(const std::string filename, Detective *detective)
{
	xmlNodePtr root;
	xmlDocPtr doc;

cout << ":" << filename.data() << ":" << endl;
	doc = xmlParseFile("etc/schemas/agentbase.xml");
	root = xmlDocGetRootElement(doc);
	if (strcmp((const char *)root->name, "AGENTBASE") == 0) {
		int ret;
		ret = m_parse_agentbase(detective, doc, root);
	}
	xmlFreeDoc(doc);
	xmlCleanupParser();
	return 0;
}
