#include "Schema_Statement.h"

#include <cstdlib>
#include <list>

Schema_Statement::Schema_Statement(const int *matrix, size_t size) :
	i_size(size)
{
	i_matrix = new (int *)[size];
	for (size_t x = 0; x < i_size; x++) {
		i_matrix[x] = new int[size];
		for (size_t y = 0; y < i_size; y++) {
			i_matrix[x][y] = matrix[x + i_size*y];
		}
	}
}

Schema_Statement::Schema_Statement(const std::string filename)
{
}

Schema_Statement::Schema_Statement(const char *filename)
{
}

Schema_Statement::~Schema_Statement()
{
}

int
Schema_Statement::m_correlate(Statement *s, vector< Evidence* > &v,
	size_t x, size_t y)
{
	int ret;

	if (i_matrix[x][y] == 0) return 0;

	if (v[x] != NULL) {
		if (v[y] != NULL) {
			ret = s->insert(v[x], v[y]);
		} else {
			ret = s->insert(v[x]);
		}
	} else if (v[y] != NULL) {
		ret = s->insert(v[y]);
	}
	return ret;
}

Statement*
Schema_Statement::correlate(vector< Evidence* > *v)
{
	Statement *s;

	s = new Statement;
	for (size_t y = 0; y < i_size; y++) {
		for (size_t x = 0; x < y; x++) {
			int ret;

			ret = m_correlate(s, *v, x, y);
		}
	}
	return 0;
}
