#ifndef SEGMENT_ELF32_H
#define SEGMENT_ELF32_H

#include "BinaryImage_MappedFile.h"

#include <cstdlib>

#include <elf.h>

class Segment_ELF32 : public BinaryImage_MappedFile {
public:
	Segment_ELF32(Elf32_Phdr *phdr, const char *image,
		const char *filename
	) :
		BinaryImage_MappedFile(image, phdr->p_filesz,
			phdr->p_vaddr, filename),
		i_phdr(phdr) {}

	size_t	memsz(void) const	{ return i_phdr->p_memsz;	}

protected:
	Elf32_Phdr*	i_phdr;
};

#endif
