#ifndef DETECTIVE_H
#define DETECTIVE_H

#include "Evidence.h"
#include "Designation.h"
#include "Generator.h"
#include "TimeTable.h"
#include "Contract.h"
#include "KnowledgeBase.h"
#include "ContractGenerator.h"

#include <list>

class Detective {
public:
	Detective(
		Designation designation,
		KnowledgeBase *kb
//		TimeTable< Generator > timetable
	) :
		i_kb(kb),
		i_designation(designation)
//		i_timetable(timetable)
	{}
		
	ContractGenerator*	associate	(Generator *generator);
	int	disassociate	(ContractGenerator *contract);

/*
	int	receive 	(Contract *contract, Generator *generator,
				 Evidence *evidence);
	int	tell		(Generator *generator);
*/
	int	inform		(Generator *generator, Evidence *evidence);
	int	investigate	();

	list< Evidence* >	evidence	() const { return i_evidence; }

protected:
	KnowledgeBase*			i_kb;
	Designation			i_designation;
//	TimeTable< Generator* >		i_timetable;
	list< ContractGenerator* >	i_contract;
	list< Evidence* >		i_evidence;
private:
};

#endif
