#ifndef EVIDENCE_H
#define EVIDENCE_H

#include "TimeStamp.h"

#include <iostream.h>
#include <string>
#include <vector>
#include <map>
#include <cstdlib>

class Evidence {
public:
	Evidence(const std::string name) : i_name(name) {}
	Evidence(const char *name) : i_name(name) {}
	virtual ~Evidence() {}

	virtual int atom() const { return 0; }
	virtual vector<Evidence *> *decompose() {
		vector<Evidence *> *v = new vector<Evidence *>;
		v->push_back(this);
		return v;
	}
	const std::string name() const { return i_name; }

virtual const char*	image() const {}
virtual size_t		 size() const {}
virtual int		print() const {}

protected:
	const std::string	i_name;
private:
};

class EvidenceReceipt {
public:
	virtual ~EvidenceReceipt() {}

	virtual int	put	(Evidence *evidence) = 0;

protected:
	TimeStamp	timestamp;
private:
};

#endif
